/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.io.Serializable;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.SerializableObject;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityContextImpl;
import oracle.adf.share.security.resource.ADFSecurityMessages;

public class ADFSecurityUtil {
    public static final String LOGGER_COMPONENT_NAME = "oracle.adf.share.security";
    private static ADFLogger _adfSecLogger = ADFLogger.createADFLogger((String)"oracle.adf.share.security");

    public static ADFLogger getADFLogger() {
        return _adfSecLogger;
    }

    public static String getMessage(String msgKey) {
        return ADFSecurityUtil.getMessage(msgKey, null);
    }

    public static String getMessage(String msgKey, Object[] params) {
        String message = "";
        ResourceBundle resources = ADFSecurityMessages.getBundle();
        try {
            message = resources.getString(msgKey);
        }
        catch (MissingResourceException e) {
            message = msgKey;
        }
        return params == null ? message : MessageFormat.format(message, params);
    }

    public static boolean hasAnyoneRole(Subject subject) {
        if (subject != null) {
            for (Principal p : subject.getPrincipals()) {
                if (!p.getName().equals("anyone")) continue;
                return true;
            }
        }
        return false;
    }

    public static String getApplicationName() {
        Object value = ADFSecurityUtil.getEnvValue("oracle.adf.security.application.name");
        if (value == null) {
            return ADFSecurityUtil.isXSMode() || ADFSecurityUtil.isUseJps() ? "adf.j2se" : "default";
        }
        return (String)value;
    }

    public static boolean isXSMode() {
        return false;
    }

    public static boolean isAuthorizationEnabled() {
        Object value = ADFSecurityUtil.getEnvValue("oracle.adf.security.authorization.enforce");
        return value != null ? !value.equals(Boolean.FALSE.toString()) : false;
    }

    public static boolean isAuthenticationRequired() {
        if (ADFSecurityUtil.isAuthorizationEnabled()) {
            return true;
        }
        Object value = ADFSecurityUtil.getEnvValue("oracle.adf.security.authentication.require");
        return value != null ? !value.equals(Boolean.FALSE.toString()) : false;
    }

    public static boolean isSecurity1013Mode() {
        if (ADFContext.getCurrent().hasSecurityContext()) {
            return ((SecurityContextImpl)ADFContext.getCurrent().getSecurityContext()).isSecurity1013Mode();
        }
        return false;
    }

    static Object getEnvValue(String prop) {
        Map env = ADFContext.getCurrent().getADFConfig().getConfigObject("http://xmlns.oracle.com/adf/security/config");
        return env != null ? env.get(prop) : null;
    }

    public static String getIdentityManagementProviderClassName() {
        String providerClassName = null;
        SecurityContext secCtx = ADFContext.getCurrent().getSecurityContext();
        try {
            providerClassName = (String)secCtx.getEnvironment().get("oracle.adf.security.identity.provider");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return providerClassName;
    }

    public static void checkNotNull(String className, String methodName, String name, Object obj) throws IllegalArgumentException {
        if (obj == null) {
            IllegalArgumentException ex = new IllegalArgumentException(ADFSecurityUtil.getMessage("EXC_MISSING_PARAMETER", new Object[]{name}));
            ADFSecurityUtil.getADFLogger().throwing(className, methodName, (Throwable)ex);
            throw ex;
        }
    }

    public static String getSecurityNamespace() {
        return (String)ADFSecurityUtil.getEnvValue("securityNamespace");
    }

    public static String getNamespacePrefix() {
        return (String)ADFSecurityUtil.getEnvValue("prefix");
    }

    public static boolean checkSerializable(Object obj) {
        if (obj instanceof Serializable) {
            SerializableObject serObject = new SerializableObject((Serializable)obj);
            String str = serObject.streamToString();
            return str != null;
        }
        return false;
    }

    static boolean isUseJps() {
        Object value = ADFSecurityUtil.getEnvValue("oracle.adf.security.context");
        return value == null ? false : ((String)value).equals("oracle.adf.share.security.providers.jps.JpsSecurityContext");
    }

    public static boolean isWildcardEnable() {
        SecurityContext secCtx = ADFContext.getCurrent().getSecurityContext();
        return ((SecurityContextImpl)secCtx).isWildcardPermissionEnabled();
    }

    public static boolean isPermissionCacheEnable() {
        SecurityContext secCtx = ADFContext.getCurrent().getSecurityContext();
        return ((SecurityContextImpl)secCtx).isPermissionCacheEnabled();
    }

    public static boolean isSSO() {
        if (!ADFContext.getCurrent().hasSecurityContext()) {
            return false;
        }
        SecurityContext secCtx = ADFContext.getCurrent().getSecurityContext();
        try {
            Boolean value = (Boolean)secCtx.getEnvironment().get("oracle.adf.security.auth.sso");
            return value == null ? false : value;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Deprecated
    public static boolean hasIdentityManagementSupport(SecurityContext secCtx) {
        String providerClassName = null;
        try {
            providerClassName = (String)secCtx.getEnvironment().get("oracle.adf.security.identity.provider");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return providerClassName != null;
    }
}

