/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.lang.reflect.Constructor;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.util.ADFPropertiesUtil;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.TenantInfo;

public class TenantService {
    private static TenantInfo tenantInfoProvider;
    private static ADFLogger logger;
    private static final String ORACLE_SHARED_IDM_TENANTNAME = "oracle.sharedidm.tenantname";
    private static final String JPS_TENANT_INFO = "oracle.adf.share.security.providers.jps.JpsTenantInfo";
    private static final String FALLBACK_TENANT_INFO = "oracle.adf.share.security.FallbackTenantInfo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TenantInfo getInstance() {
        if (tenantInfoProvider != null) return tenantInfoProvider;
        Class<TenantService> clazz = TenantService.class;
        synchronized (TenantService.class) {
            if (tenantInfoProvider != null) return tenantInfoProvider;
            tenantInfoProvider = TenantService.isSharedIdmEnabled() ? TenantService.create(JPS_TENANT_INFO) : TenantService.create(FALLBACK_TENANT_INFO);
            // ** MonitorExit[var0] (shouldn't be in output)
            return tenantInfoProvider;
        }
    }

    static TenantInfo create(String clsName) {
        TenantInfo info = null;
        try {
            Class cls = ClassUtils.forName((String)clsName);
            Constructor ctor = cls.getConstructor(new Class[0]);
            info = (TenantInfo)ctor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ADFSecurityRuntimeException("EXC_UNEXPECTED_ERROR", ex);
        }
        return info;
    }

    public static boolean isSharedIdmEnabled() {
        String value = ADFPropertiesUtil.getSystemProperty((String)ORACLE_SHARED_IDM_TENANTNAME);
        return value != null;
    }

    static {
        logger = ADFSecurityUtil.getADFLogger();
    }
}

