/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.credentialstore;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import oracle.adf.share.ADFConfig;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.config.resources.Messages;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.CredentialNotFoundException;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityEnv;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.spi.CredentialProvisioning;
import oracle.adf.share.security.credentialstore.spi.CredentialStorage;
import oracle.adf.share.security.resource.ADFSecurityMessages;

public class CredentialStoreContext {
    private static CredentialStoreContext _singleton;
    private static final Object __LOCK__;
    private Map mEnv = null;
    private static final String resourceBundle;
    private static final ResourceBundle resBundle;
    private static final ADFLogger sLogger;
    public static final String SESSION_CREDENTIALS = "__session_credentials__";
    public static final String ADF_NO_CRED_STORE_CLASS = "oracle.adf.share.security.ADFNoCredentialSupportStore";
    private static final String CLASS_NAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialStoreContext getInstance() {
        Object object = __LOCK__;
        synchronized (object) {
            if (null == _singleton) {
                _singleton = new CredentialStoreContext(null);
                return _singleton;
            }
        }
        return _singleton;
    }

    public CredentialStoreContext(Hashtable env) {
        this.mEnv = env;
    }

    public void initialize(Properties props) {
    }

    public CredentialStorage getDefaultCredentialStoreProvider() {
        return this.getCredentialStorage(null);
    }

    public CredentialProvisioning getDefaultCredentialProvisioner() {
        return (CredentialProvisioning)((Object)this.getDefaultCredentialStoreProvider());
    }

    public CredentialProvisioning getCredentialProvisioner(String providerClassName) {
        return (CredentialProvisioning)((Object)this.getCredentialStorage(providerClassName));
    }

    public CredentialStorage getCredentialStoreProvider(String providerClassName) {
        return this.getCredentialStorage(providerClassName);
    }

    public CredentialStorage getCredentialStorage(String contextName) {
        CredentialStorage instance = null;
        String providerClassName = null;
        ADFContext adfCtx = null;
        if (contextName != null && contextName.length() > 0) {
            try {
                adfCtx = ADFContext.get(contextName);
                ADFConfig cfg = adfCtx.getADFConfig();
                this.mEnv = cfg.getConfigObject("http://xmlns.oracle.com/adf/security/config");
            }
            catch (Exception e) {
                throw new ADFSecurityRuntimeException("EXC_CREDENTIAL_STORE_INIT", e);
            }
        }
        contextName = "default";
        try {
            adfCtx = ADFContext.getCurrent();
            this.mEnv = adfCtx.getSecurityContext().getEnvironment();
        }
        catch (Exception e) {
            // empty catch block
        }
        String string = providerClassName = this.mEnv != null ? (String)this.mEnv.get("oracle.adf.security.credentialstore") : null;
        if (AdfServerPlatformUtil.isTomcat() || AdfServerPlatformUtil.isGlassFish()) {
            providerClassName = ADF_NO_CRED_STORE_CLASS;
            sLogger.warning(resBundle.getString("ADF_NO_CREDSTORE_SUPPORT_WARN"));
        } else if (providerClassName == null || providerClassName.length() == 0) {
            providerClassName = SecurityEnv.CREDENTIAL_STORE_PROVIDER_DEFAULT;
        }
        String CRED_STORE_PROVIDER_RT = "oracle.adf.share.security.providers.jps.CSFCredentialStore";
        String CRED_STORE_PROVIDER_DT = "oracle.adf.share.dt.security.providers.jps.CSFDTCredentialStore";
        if (providerClassName.equals("oracle.adf.share.security.providers.jps.CSFCredentialStore") && adfCtx.isDesignTime()) {
            providerClassName = "oracle.adf.share.dt.security.providers.jps.CSFDTCredentialStore";
        }
        try {
            Class cls = ClassUtils.forName((String)providerClassName, CredentialStoreContext.class);
            Constructor ctor = cls.getConstructor(String.class);
            instance = (CredentialStorage)ctor.newInstance(contextName);
        }
        catch (Exception ex) {
            throw new ADFSecurityRuntimeException(ex, "EXC_CREDENTIAL_STORE_INIT", ADFSecurityMessages.getBundle(), null);
        }
        return instance;
    }

    public static void storeSessionCredential(Credential cred, String credKey) {
        String METHOD_NAME = "storeSessionCredential";
        if (!ADFContext.getCurrent().getSecurityContext().isAuthenticated()) {
            throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_UNSUPPORTED_CREDENTIAL_OPERATION"));
        }
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeSessionCredential", "credential key", credKey);
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeSessionCredential", "credential", cred);
        Hashtable sessionCredentials = CredentialStoreContext.getSessionCredentials();
        sessionCredentials.put(credKey, cred);
        ADFContext.getCurrent().getSessionScope().put(SESSION_CREDENTIALS, sessionCredentials);
    }

    public static Credential fetchSessionCredential(String credKey) throws CredentialNotFoundException {
        String METHOD_NAME = "fetchSessionCredential";
        if (!ADFContext.getCurrent().getSecurityContext().isAuthenticated()) {
            throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_UNSUPPORTED_CREDENTIAL_OPERATION"));
        }
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "fetchSessionCredential", "credential key", credKey);
        Hashtable sessionCredentials = CredentialStoreContext.getSessionCredentials();
        Credential cred = (Credential)sessionCredentials.get(credKey);
        if (cred == null) {
            throw new CredentialNotFoundException(credKey, "session store");
        }
        if (cred.getProperties() == null) {
            sessionCredentials.remove(credKey);
            ADFContext.getCurrent().getSessionScope().put(SESSION_CREDENTIALS, sessionCredentials);
            throw new CredentialNotFoundException(credKey, "session store");
        }
        return cred;
    }

    String getDefaultCredentialStoreClassName() {
        SecurityContext secCtx = ADFContext.getCurrent().getSecurityContext();
        String credStore = null;
        try {
            credStore = (String)secCtx.getEnvironment().get("oracle.adf.security.credentialstore");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (credStore == null) {
            credStore = SecurityEnv.CREDENTIAL_STORE_PROVIDER_DEFAULT;
        }
        return credStore;
    }

    public static void checkSerializable(String className, String methodName, Credential cred, String credKey) {
        if (!ADFSecurityUtil.checkSerializable(cred.getProperties())) {
            ADFSecurityRuntimeException sre = new ADFSecurityRuntimeException("EXC_STORE_CREDENTIAL_NOT_SERIALIZABLE", new String[]{credKey});
            sLogger.throwing(Level.WARNING, className, methodName, (Throwable)sre);
            throw sre;
        }
    }

    static Hashtable getSessionCredentials() {
        Map sessionScope = ADFContext.getCurrent().getSessionScope();
        Hashtable sessionCredentials = (Hashtable)ADFContext.getCurrent().getSessionScope().get(SESSION_CREDENTIALS);
        if (sessionCredentials == null) {
            sessionCredentials = new Hashtable();
            ADFContext.getCurrent().getSessionScope().put(SESSION_CREDENTIALS, sessionCredentials);
        }
        return sessionCredentials;
    }

    static {
        __LOCK__ = new Object();
        resourceBundle = Messages.class.getName();
        resBundle = ResourceBundle.getBundle(resourceBundle);
        sLogger = ADFSecurityUtil.getADFLogger();
        CLASS_NAME = CredentialStoreContext.class.getName();
    }
}

