/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.identitymanagement;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import oracle.adf.share.security.identitymanagement.ADFIdentity;
import oracle.adf.share.security.identitymanagement.ADFIdentityType;
import oracle.adf.share.security.identitymanagement.ADFRole;
import oracle.adf.share.security.identitymanagement.RoleManager;
import oracle.adf.share.security.identitymanagement.UserManager;

public class Role
implements ADFRole {
    private String _name;
    private ArrayList<Principal> _members = new ArrayList();
    private RoleManager _roleMgr = null;
    private UserManager _userMgr = null;
    private List<ADFIdentity> _idyMembers = null;

    public Role() {
    }

    public Role(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void addMember(Principal member) {
        this._members.add(member);
    }

    public void removeMember(Principal member) {
        int ix = this._members.indexOf(member);
        if (ix != -1) {
            this._members.remove(ix);
        }
    }

    public Principal[] getMembers() {
        return this._members.toArray(new Principal[this._members.size()]);
    }

    @Override
    public List<ADFIdentity> getADFIdentityMembers() {
        if (this._idyMembers != null) {
            return this._idyMembers;
        }
        this._idyMembers = new ArrayList<ADFIdentity>();
        RoleManager roleMgr = this.getRoleManager();
        if (roleMgr != null) {
            for (Principal p : this._members) {
                UserManager userMgr;
                ADFIdentity idy = roleMgr.getRole(p);
                if (idy == null && (userMgr = this.getUserManager()) != null) {
                    idy = userMgr.getUser(p);
                }
                if (idy == null) continue;
                this._idyMembers.add(idy);
            }
        }
        return this._idyMembers;
    }

    public boolean hasMember(Principal member) {
        for (int i = 0; i < this._members.size(); ++i) {
            if (!this._members.get(i).getName().equals(member.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Role)) {
            return false;
        }
        return this._name != null ? this._name.equals(((Role)obj).getName()) : false;
    }

    @Override
    public ADFIdentityType getType() {
        return ADFIdentityType.ROLE;
    }

    private RoleManager getRoleManager() {
        if (this._roleMgr == null) {
            this._roleMgr = new RoleManager();
        }
        return this._roleMgr;
    }

    private UserManager getUserManager() {
        if (this._userMgr == null) {
            this._userMgr = new UserManager();
        }
        return this._userMgr;
    }
}

