/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.adf.share.ADFContext;
import oracle.adf.share.ADFScope;
import oracle.adf.share.ADFScopeListener;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.MetadataRegistry;
import oracle.adf.share.config.ADFConfigFactory;
import oracle.adf.share.config.resources.Messages;
import oracle.adf.share.connection.metadata.ADFConnectionCredentialInfo;
import oracle.adf.share.jndi.AdfInitialContext;
import oracle.adf.share.jndi.DocumentHelper;
import oracle.adf.share.jndi.MetadataRefAddr;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.adf.share.jndi.StringELRefAddr;
import oracle.adf.share.jndi.XmlRefAddr;
import oracle.adf.share.jndi.xml.v2.AnyXmlType;
import oracle.adf.share.jndi.xml.v2.MetadataRefAddrType;
import oracle.adf.share.jndi.xml.v2.ObjectFactory;
import oracle.adf.share.jndi.xml.v2.RefAddressListType;
import oracle.adf.share.jndi.xml.v2.ReferenceFactoryType;
import oracle.adf.share.jndi.xml.v2.ReferenceListType;
import oracle.adf.share.jndi.xml.v2.ReferenceType;
import oracle.adf.share.jndi.xml.v2.SecureRefAddrType;
import oracle.adf.share.jndi.xml.v2.StringRefAddrType;
import oracle.adf.share.jndi.xml.v2.XmlRefAddrType;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.logging.internal.perf.SensorTable;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AdfShareUtils {
    private static ADFLogger logger = ADFLogger.createADFLogger(AdfShareUtils.class);
    private static final String _SEP_ = ",";
    private static final String CONNECTIONS_DOMAINCONFIG_METADATA = "hasConnectionDomainConfigMetadata";
    private static final String CONN_METADATA_FILE_LOCATION = "META-INF/adf-connection-metadata.xml";
    private static final String CONN_METADATA_ATTRIBUTE = "adf-connection";
    private static final String resourceBundle = Messages.class.getName();
    private static final ResourceBundle resBundle = ResourceBundle.getBundle(resourceBundle);
    private static final String SENSOR_TABLE_ATTR_NAME = SensorTable.class.getName();

    private AdfShareUtils() {
    }

    private static ADFLogger getLogger() {
        return logger;
    }

    public static String encodeUserNameAttrsInfo(ADFConnectionCredentialInfo[] connCredInfos) {
        if (connCredInfos == null || connCredInfos.length < 1) {
            return "";
        }
        StringBuilder str = new StringBuilder(connCredInfos[0].getUserAttributeName());
        for (int i = 1; i < connCredInfos.length; ++i) {
            str.append(_SEP_);
            str.append(connCredInfos[i].getUserAttributeName());
        }
        return str.toString();
    }

    public static String encodePasswordAttrsInfo(ADFConnectionCredentialInfo[] connCredInfos) {
        if (connCredInfos == null || connCredInfos.length < 1) {
            return "";
        }
        StringBuilder str = new StringBuilder(connCredInfos[0].getPasswordAttributeName());
        for (int i = 1; i < connCredInfos.length; ++i) {
            str.append(_SEP_);
            str.append(connCredInfos[i].getPasswordAttributeName());
        }
        return str.toString();
    }

    public static ADFConnectionCredentialInfo[] decode(String usernameAttrInfoString, String passwordAttrInfoString) {
        String[] passwordAttrs;
        String[] userAttrs = usernameAttrInfoString.split(_SEP_);
        if (userAttrs.length != (passwordAttrs = passwordAttrInfoString.split(_SEP_)).length) {
            return new ADFConnectionCredentialInfo[0];
        }
        ADFConnectionCredentialInfo[] credInfo = new ADFConnectionCredentialInfo[userAttrs.length];
        for (int i = 0; i < credInfo.length; ++i) {
            credInfo[i] = new ADFConnectionCredentialInfo(userAttrs[i], passwordAttrs[i]);
        }
        return credInfo;
    }

    public static boolean isConnectionAttributeSecure(Reference ref, String attrName) {
        RefAddr addr = ref.get(attrName);
        return addr instanceof SecureRefAddr;
    }

    public static String[] getDomainConfigAttributes(String mbeanConnectionType) {
        ConnMeta meta = AdfShareUtils.lookupCachedConnMetaInfo(mbeanConnectionType);
        if (meta != null && meta.adfDomainConfigAttrs != null) {
            return meta.adfDomainConfigAttrs.toArray(new String[0]);
        }
        return new String[0];
    }

    public static final String getUpgradeHandlerClassName(String mbeanConnectionType) {
        ConnMeta meta = AdfShareUtils.lookupCachedConnMetaInfo(mbeanConnectionType);
        return meta != null ? meta.handlerClass : "";
    }

    public static String exportWithResolvedExpressions(URL adfConfigUrl, String ctxName, Hashtable env) throws Exception {
        ObjectFactory jaxbFactory = new ObjectFactory();
        ADFContext oldCtx = ADFContext.hasCurrent() ? ADFContext.getCurrent() : null;
        ADFContext.registerNamedContext(ctxName, adfConfigUrl);
        ADFContext namedADFContext = ADFContext.get(ctxName);
        namedADFContext.setAsCurrent();
        String exportStr = "";
        try {
            String connxmlpath = (String)env.get("java.naming.provider.url");
            ReferenceListType refTypeList = AdfShareUtils.createReferenceListType(AdfShareUtils.readDocument(connxmlpath));
            Document doc = AdfShareUtils.generateResolvedDocument(refTypeList, env, jaxbFactory);
            exportStr = AdfShareUtils.export(doc);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ADFContext.resetADFContext(oldCtx);
            ADFContext.unregisterNamedContext(ctxName);
        }
        return exportStr;
    }

    public static String runtimeExportEithELsResolved(Document connDoc, String connpath) throws Exception {
        ObjectFactory jaxbFactory = new ObjectFactory();
        ReferenceListType reference = AdfShareUtils.createReferenceListType(connDoc);
        Hashtable<String, String> connCtxEnv = new Hashtable<String, String>();
        connCtxEnv.put("java.naming.factory.initial", "oracle.adf.share.jndi.InitialContextFactoryImpl");
        connCtxEnv.put("oracle.adf.share.jndi.documentstore", "oracle.adf.share.jndi.MDSBackingStore");
        connCtxEnv.put("java.naming.provider.url", connpath);
        connCtxEnv.put("oracle.adf.share.jndi.DocumentBackingStore.isReadOnly", "false");
        connCtxEnv.put("oracle.adf.share.jndi.DocumentBackingStore.doCreateSession", "true");
        Document doc = AdfShareUtils.generateResolvedDocument(reference, connCtxEnv, jaxbFactory);
        return AdfShareUtils.export(doc);
    }

    public static String export(Document doc) throws Exception {
        return AdfShareUtils.getDocumentAsString(AdfShareUtils.getUnformattedDocument(doc));
    }

    public static ReferenceListType createReferenceListType(Document doc) {
        NodeList childNodes;
        Element element;
        ReferenceListType references = new ReferenceListType();
        if (doc != null && (element = doc.getDocumentElement()) != null && (childNodes = element.getChildNodes()).getLength() > 0) {
            references.getReference().addAll(DocumentHelper.getReference(childNodes));
        }
        return references;
    }

    private static Document generateResolvedDocument(ReferenceListType oldRefTypeList, Hashtable env, ObjectFactory jaxbFactory) throws Exception {
        AdfInitialContext connCtx = AdfShareUtils.getNamedContext(env);
        ReferenceListType references = jaxbFactory.createReferenceListType();
        Iterator<ReferenceType> iter = oldRefTypeList.getReference().iterator();
        ArrayList<ReferenceType> elResolvedRefList = new ArrayList<ReferenceType>();
        while (iter.hasNext()) {
            ReferenceType oldRefType = iter.next();
            String connName = oldRefType.getName();
            Referenceable ref = null;
            try {
                ref = (Referenceable)connCtx.lookup(connName);
            }
            catch (Exception e) {
                String message = Messages.format("EL_RESOLUTION_SKIPPING", connName);
                AdfShareUtils.getLogger().severe(message, (Throwable)e);
            }
            if (ref == null) {
                elResolvedRefList.add(oldRefType);
                continue;
            }
            ReferenceType newRefType = AdfShareUtils.createReferenceType(connName, ref.getReference());
            if (oldRefType.isPartial() != null) {
                newRefType.setPartial(oldRefType.isPartial());
            }
            if (oldRefType.isDeployable() != null) {
                newRefType.setDeployable(oldRefType.isDeployable());
            }
            if (oldRefType.isManageInOracleEnterpriseManager() != null) {
                newRefType.setManageInOracleEnterpriseManager(oldRefType.isManageInOracleEnterpriseManager());
            }
            if (oldRefType.isDeployable() != null) {
                newRefType.setDeployable(oldRefType.isDeployable());
            }
            String adfCredKey = oldRefType.getAdfCredentialStoreKey();
            String mapName = oldRefType.getAdfCredentialStoreMapName();
            String credKey = oldRefType.getCredentialStoreKey();
            if (credKey != null) {
                newRefType.setCredentialStoreKey(credKey);
            }
            if (adfCredKey != null) {
                newRefType.setAdfCredentialStoreKey(adfCredKey);
            }
            if (mapName != null) {
                newRefType.setAdfCredentialStoreMapName(mapName);
            }
            elResolvedRefList.add(newRefType);
        }
        references.getReference().addAll(elResolvedRefList);
        Document doc = DocumentHelper.createConnectionsDocument(references);
        return doc;
    }

    private static AdfInitialContext getNamedContext(Hashtable env) throws Exception {
        return new AdfInitialContext(env);
    }

    private static Document getUnformattedDocument(Document document) {
        Document unformatted;
        block2: {
            unformatted = document;
            try {
                DOMParser parser = new DOMParser();
                parser.retainCDATASection(true);
                parser.setPreserveWhitespace(false);
                parser.parse((Reader)new StringReader(AdfShareUtils.getDocumentAsString(document)));
                unformatted = parser.getDocument();
            }
            catch (Exception e) {
                if (!AdfShareUtils.getLogger().isLoggable(Level.FINE)) break block2;
                AdfShareUtils.getLogger().fine((Throwable)e);
            }
        }
        return unformatted;
    }

    public static String getDocumentAsString(Node document) {
        String text = "";
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setAttribute("indent-number", new Integer(2));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult strResult = new StreamResult(new StringWriter());
            DOMSource domSource = new DOMSource(document);
            transformer.transform(domSource, strResult);
            text = strResult.getWriter().toString();
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return text;
    }

    private static Document elementFromString(String xmlText) throws IOException, SAXException, XMLParseException {
        DOMParser parser = new DOMParser();
        parser.parse((Reader)new StringReader(xmlText));
        return parser.getDocument();
    }

    private static ReferenceType createReferenceType(String id, Reference ref) {
        ObjectFactory mJaxbFactory = new ObjectFactory();
        ReferenceType aRef = mJaxbFactory.createReferenceType();
        aRef.setName(id);
        aRef.setClassName(ref.getClassName());
        ReferenceFactoryType refFact = mJaxbFactory.createReferenceFactoryType();
        refFact.setClassName(ref.getFactoryClassName());
        aRef.setFactory(refFact);
        RefAddressListType addrList = mJaxbFactory.createRefAddressListType();
        Enumeration<RefAddr> e = ref.getAll();
        while (e.hasMoreElements()) {
            String content;
            RefAddr refAddr = e.nextElement();
            if (refAddr instanceof StringRefAddr) {
                StringRefAddrType strRefAddrType = mJaxbFactory.createStringRefAddrType();
                content = (String)((StringRefAddr)refAddr).getContent();
                strRefAddrType.setContents(content);
                strRefAddrType.setAddrType(refAddr.getType());
                addrList.getReferenceAddrGroup().add(strRefAddrType);
                continue;
            }
            if (refAddr instanceof XmlRefAddr) {
                XmlRefAddrType xmlRef = mJaxbFactory.createXmlRefAddrType();
                xmlRef.setAddrType(refAddr.getType());
                AnyXmlType anyXml = mJaxbFactory.createAnyXmlType();
                String xmlText = AdfShareUtils.getDocumentAsString(((XmlRefAddr)refAddr).getDocumentFragment());
                String resolvedText = StringELRefAddr.checkAndResolveExpression(xmlText).toString();
                Document doc = null;
                NodeList nl = null;
                try {
                    doc = AdfShareUtils.elementFromString(resolvedText);
                    nl = doc.getChildNodes();
                }
                catch (Exception pe) {
                    DocumentFragment df = ((XmlRefAddr)refAddr).getDocumentFragment();
                    nl = df.getChildNodes();
                }
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node = nl.item(i);
                    anyXml.getAny().add(node);
                }
                xmlRef.setContents(anyXml);
                addrList.getReferenceAddrGroup().add(xmlRef);
                continue;
            }
            if (refAddr instanceof SecureRefAddr) {
                SecureRefAddr secref = (SecureRefAddr)refAddr;
                String v = secref.getValue();
                SecureRefAddrType secRefType = mJaxbFactory.createSecureRefAddrType();
                secRefType.setAddrType(refAddr.getType());
                addrList.getReferenceAddrGroup().add(secRefType);
                continue;
            }
            if (!(refAddr instanceof MetadataRefAddr)) continue;
            MetadataRefAddrType mtRefAddrType = mJaxbFactory.createMetadataRefAddrType();
            content = (String)((MetadataRefAddr)refAddr).getContent();
            mtRefAddrType.setContents(content);
            mtRefAddrType.setAddrType(refAddr.getType());
            addrList.getReferenceAddrGroup().add(mtRefAddrType);
        }
        aRef.setRefAddresses(addrList);
        return aRef;
    }

    private static Document readDocument(String url) throws Exception {
        File file = AdfShareUtils.getFile(url);
        return MetadataRegistry.newInstance().getDomDocument(file.toURL());
    }

    private static File getFile(String url) throws Exception {
        if (url != null && url.length() > 5 && url.charAt(4) == ':' && url.substring(0, 4).equalsIgnoreCase("file")) {
            return new File(url.substring(5));
        }
        return new File(url);
    }

    private static ConnMeta lookupCachedConnMetaInfo(String connType) {
        AdfShareUtils.loadConnectionsMetadata();
        Map<String, Object> map = ADFContext.getCurrent().getApplicationScope();
        Map metaInfo = (Map)map.get(CONNECTIONS_DOMAINCONFIG_METADATA);
        return metaInfo != null ? (ConnMeta)metaInfo.get(connType) : null;
    }

    private static synchronized void loadConnectionsMetadata() {
        Map<String, Object> map = ADFContext.getCurrent().getApplicationScope();
        if (map.containsKey(CONNECTIONS_DOMAINCONFIG_METADATA)) {
            return;
        }
        StringBuffer excepMsg = null;
        String loc = CONN_METADATA_FILE_LOCATION;
        HashMap<String, ConnMeta> connMetaProps = new HashMap<String, ConnMeta>();
        MetadataRegistry mdr = null;
        try {
            Enumeration<URL> urls = ClassUtils.getClassLoader(AdfShareUtils.class).getResources(loc);
            mdr = MetadataRegistry.newInstance();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try {
                    Document doc = mdr.getDomDocument(url);
                    NodeList connsMetaList = doc.getElementsByTagName(CONN_METADATA_ATTRIBUTE);
                    int n = connsMetaList != null ? connsMetaList.getLength() : 0;
                    for (int i = 0; i < n; ++i) {
                        ConnMeta meta;
                        Element elem = (Element)connsMetaList.item(i);
                        if (elem == null || (meta = AdfShareUtils.getConnMeta(elem)) == null || meta.connType == null || meta.adfDomainConfigAttrs == null || meta.adfDomainConfigAttrs.size() <= 0) continue;
                        connMetaProps.put(meta.connType, meta);
                    }
                }
                catch (Exception e) {
                    AdfShareUtils.getLogger().info(resBundle.getString("CONN_METADATA_PARSE_ERR") + url);
                    AdfShareUtils.getLogger().finest((Throwable)e);
                    if (excepMsg == null) {
                        excepMsg = new StringBuffer();
                    }
                    excepMsg.append(resBundle.getString("CONN_METADATA_PARSE_ERR") + url + e + "\n");
                }
            }
            if (connMetaProps.size() == 0) {
                if (excepMsg != null) {
                    throw new RuntimeException(excepMsg.toString());
                }
                throw new RuntimeException(MessageFormat.format(resBundle.getString("RESOURCE_NOT_FOUND"), "adf-connections-metadata.xml"));
            }
        }
        catch (IOException ex) {
            AdfShareUtils.getLogger().warning(MessageFormat.format(resBundle.getString("RESOURCE_NOT_FOUND"), "adf-connections-metadata.xml"));
            throw new RuntimeException(MessageFormat.format(resBundle.getString("RESOURCE_NOT_FOUND"), "adf-connections-metadata.xml"), ex);
        }
        finally {
            ADFContext.getCurrent().getApplicationScope().put(CONNECTIONS_DOMAINCONFIG_METADATA, connMetaProps);
        }
    }

    private static ConnMeta getConnMeta(Element e) {
        ConnMeta c = new ConnMeta();
        if (e != null) {
            c.connType = e.getAttribute("referenceType");
            c.handlerClass = e.getAttribute("upgradeHandler");
            String propsList = e.getAttribute("oracleFusionAppsAdfDomainConfigProperties");
            if (propsList != null) {
                String[] attrs;
                for (String s : attrs = propsList.split(_SEP_)) {
                    c.adfDomainConfigAttrs.add(s.trim());
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getSensorTable(int flags) {
        if (!ADFContext.hasCurrent()) {
            return null;
        }
        if (ADFConfigFactory.findADFConfig() == null) {
            return null;
        }
        Map<String, Object> scope = ADFContext.getCurrent().getApplicationScope();
        Map sensors = null;
        sensors = (flags & 2) > 1 ? (ConcurrentHashMap)scope.remove(SENSOR_TABLE_ATTR_NAME) : (Map)scope.get(SENSOR_TABLE_ATTR_NAME);
        if (sensors == null && (flags & 1) > 0) {
            String string = SENSOR_TABLE_ATTR_NAME;
            synchronized (string) {
                sensors = (Map)scope.get(SENSOR_TABLE_ATTR_NAME);
                if (sensors == null) {
                    sensors = new ConcurrentHashMap();
                    scope.put(SENSOR_TABLE_ATTR_NAME, sensors);
                    if (scope instanceof ADFScope) {
                        ((ADFScope)scope).addScopeListener(new ADFScopeListener(){

                            @Override
                            public void scopeInvalidated(String scopeName) {
                                SensorTable.cleanupSensors(null);
                            }
                        });
                    }
                }
            }
        }
        return sensors;
    }

    private static class ConnMeta {
        public String connType = null;
        public List<String> adfDomainConfigAttrs = new ArrayList<String>();
        public String handlerClass = null;
    }
}

