/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

public class AggregatePredicate
implements Predicate {
    boolean isUpperBound;
    String attribute;
    Predicate predicate;

    public AggregatePredicate(String string, Predicate predicate, boolean bl) {
        this.isUpperBound = bl;
        this.attribute = string;
        this.predicate = predicate;
    }

    @Override
    public MaterializedPredicate eval(Parsed parsed) {
        MaterializedPredicate materializedPredicate = this.predicate.eval(parsed);
        Integer n = materializedPredicate.getAttribute(this.attribute);
        if (n == null) {
            throw new AssertionError((Object)("Predicate " + materializedPredicate.name + " doesn't have " + this.attribute + " attribute"));
        }
        MaterializedPredicate materializedPredicate2 = new MaterializedPredicate(materializedPredicate.attributes, parsed.getSrc(), materializedPredicate.name);
        for (ParseNode[] parseNodeArray : materializedPredicate.tuples) {
            this.eval(parseNodeArray, materializedPredicate2.tuples, n);
        }
        return materializedPredicate2;
    }

    private void eval(ParseNode[] parseNodeArray, ArrayList<ParseNode[]> arrayList, int n) {
        ParseNode[] parseNodeArray2 = null;
        boolean bl = false;
        for (ParseNode[] parseNodeArray3 : arrayList) {
            boolean bl2 = true;
            bl = false;
            for (int i = 0; i < parseNodeArray.length; ++i) {
                if (i == n) {
                    boolean bl3;
                    boolean bl4 = parseNodeArray[n].to < parseNodeArray3[n].to;
                    boolean bl5 = parseNodeArray[n].to == parseNodeArray3[n].to;
                    boolean bl6 = parseNodeArray3[n].from < parseNodeArray[n].from;
                    boolean bl7 = bl3 = parseNodeArray3[n].from == parseNodeArray[n].from;
                    if (this.isUpperBound) {
                        if (!bl6 && (!bl3 || !bl4)) continue;
                        bl = true;
                        continue;
                    }
                    if (!bl4 && (!bl5 || !bl6)) continue;
                    bl = true;
                    continue;
                }
                if (parseNodeArray3[i].from == parseNodeArray[i].from && parseNodeArray3[i].to == parseNodeArray[i].to) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            parseNodeArray2 = parseNodeArray3;
            break;
        }
        if (parseNodeArray2 != null && bl) {
            arrayList.remove(parseNodeArray2);
        }
        if (parseNodeArray2 == null || bl) {
            arrayList.add(parseNodeArray);
        }
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(this.attribute);
        if (this.isUpperBound) {
            stringBuffer.append("\\/");
        } else {
            stringBuffer.append("/\\");
        }
        stringBuffer.append(this.predicate.toString(n));
        return stringBuffer.toString();
    }

    @Override
    public boolean eval(Map<String, ParseNode> map, List<LexerToken> list) {
        throw new AssertionError((Object)"N/A");
    }

    @Override
    public void variables(Set<String> set, boolean bl) {
        this.predicate.variables(set, false);
    }

    @Override
    public Predicate isRelated(String string, String string2, Map<String, Attribute> map) {
        return this.predicate.isRelated(string, string2, map);
    }

    @Override
    public Map<String, Boolean> dependencies() {
        return this.predicate.dependencies();
    }
}

