/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Oper;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

class CompositeExpr
implements Predicate {
    Predicate lft;
    Predicate rgt;
    Oper oper;

    public CompositeExpr(Predicate predicate, Predicate predicate2, Oper oper) {
        this.lft = predicate;
        this.rgt = predicate2;
        this.oper = oper;
    }

    @Override
    public boolean eval(Map<String, ParseNode> map, List<LexerToken> list) {
        if (this.oper == Oper.CONJUNCTION) {
            return this.lft.eval(map, list) && this.rgt.eval(map, list);
        }
        if (this.oper == Oper.DISJUNCTION) {
            return this.lft.eval(map, list) || this.rgt.eval(map, list);
        }
        if (this.oper == Oper.NEGATION) {
            return !this.lft.eval(map, list);
        }
        throw new AssertionError((Object)"Unexpected case");
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(this.oper.toString().substring(0, 4) + '\n');
        stringBuffer.append(this.lft.toString(n + 1));
        if (this.rgt != null) {
            stringBuffer.append(this.rgt.toString(n + 1));
        }
        return stringBuffer.toString();
    }

    @Override
    public void variables(Set<String> set, boolean bl) {
        if (this.rgt == null) {
            this.lft.variables(set, this.oper == Oper.CONJUNCTION);
            return;
        }
        this.lft.variables(set, this.oper == Oper.CONJUNCTION);
        this.rgt.variables(set, this.oper == Oper.CONJUNCTION);
    }

    @Override
    public MaterializedPredicate eval(Parsed parsed) {
        if (this.oper == Oper.DISJUNCTION) {
            MaterializedPredicate materializedPredicate = this.lft.eval(parsed);
            if (materializedPredicate == null) {
                return null;
            }
            MaterializedPredicate materializedPredicate2 = this.rgt.eval(parsed);
            if (materializedPredicate2 == null) {
                return null;
            }
            return MaterializedPredicate.union(materializedPredicate, materializedPredicate2);
        }
        if (this.oper == Oper.CONJUNCTION) {
            MaterializedPredicate materializedPredicate = this.lft.eval(parsed);
            if (materializedPredicate == null) {
                return null;
            }
            MaterializedPredicate materializedPredicate3 = this.rgt.eval(parsed);
            if (materializedPredicate3 == null) {
                return null;
            }
            return MaterializedPredicate.join(materializedPredicate, materializedPredicate3);
        }
        if (this.oper == Oper.DIFFERENCE) {
            MaterializedPredicate materializedPredicate = this.lft.eval(parsed);
            if (materializedPredicate == null) {
                return null;
            }
            MaterializedPredicate materializedPredicate4 = this.rgt.eval(parsed);
            if (materializedPredicate4 == null) {
                return null;
            }
            return MaterializedPredicate.difference(materializedPredicate, materializedPredicate4);
        }
        return null;
    }

    @Override
    public Predicate isRelated(String string, String string2, Map<String, Attribute> map) {
        if (this.oper != Oper.CONJUNCTION && this.oper != Oper.DISJUNCTION) {
            return null;
        }
        Predicate predicate = this.lft.isRelated(string, string2, map);
        Predicate predicate2 = this.rgt.isRelated(string, string2, map);
        if (predicate != null && predicate2 != null) {
            return new CompositeExpr(predicate, predicate2, this.oper);
        }
        if (predicate == null && predicate2 != null && this.oper == Oper.CONJUNCTION) {
            return predicate2;
        }
        if (predicate != null && predicate2 == null && this.oper == Oper.CONJUNCTION) {
            return predicate;
        }
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        if (this.oper == Oper.CONJUNCTION) {
            Map<String, Boolean> map = this.lft.dependencies();
            map.putAll(this.rgt.dependencies());
            return map;
        }
        if (this.oper == Oper.DIFFERENCE) {
            Map<String, Boolean> map = this.lft.dependencies();
            for (String string : this.rgt.dependencies().keySet()) {
                map.put(string, false);
            }
            return map;
        }
        if (this.oper == Oper.DISJUNCTION) {
            if (this.rgt instanceof MaterializedPredicate && ((MaterializedPredicate)this.rgt).tuples.size() == 0) {
                return this.lft.dependencies();
            }
            if (this.lft instanceof MaterializedPredicate && ((MaterializedPredicate)this.lft).tuples.size() == 0) {
                return this.rgt.dependencies();
            }
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (String string : this.lft.dependencies().keySet()) {
                hashMap.put(string, false);
            }
            for (String string : this.rgt.dependencies().keySet()) {
                hashMap.put(string, false);
            }
            return hashMap;
        }
        if (this.oper == Oper.NEGATION) {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (String string : this.lft.dependencies().keySet()) {
                hashMap.put(string, false);
            }
            return hashMap;
        }
        throw new AssertionError((Object)"Unexpected case");
    }
}

