/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.AggregatePredicate;
import oracle.dbtools.arbori.AncestorDescendantNodes;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.Column;
import oracle.dbtools.arbori.CompositeExpr;
import oracle.dbtools.arbori.EqualExpr;
import oracle.dbtools.arbori.IndependentAttribute;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.NodeContent;
import oracle.dbtools.arbori.NodeMatchingSrc;
import oracle.dbtools.arbori.NodesWMatchingSrc;
import oracle.dbtools.arbori.Oper;
import oracle.dbtools.arbori.Parent;
import oracle.dbtools.arbori.PosType;
import oracle.dbtools.arbori.PositionalRelation;
import oracle.dbtools.arbori.PredRef;
import oracle.dbtools.arbori.Predecessor;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.PredicateDependency;
import oracle.dbtools.arbori.SameNodes;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Successor;
import oracle.dbtools.arbori.True;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;

public class Program {
    public static boolean debug = false;
    Earley parser;
    private static int atomic_predicate = -1;
    private static int bind_var = -1;
    private static int backslash = -1;
    private static int closePar = -1;
    private static int closeBr = -1;
    private static int col = -1;
    private static int conj = -1;
    private static int disj = -1;
    private static int dot = -1;
    private static int eq = -1;
    private static int excl = -1;
    private static int identifier = -1;
    private static int header = -1;
    private static int lt = -1;
    private static int minus = -1;
    private static int node_parent = -1;
    private static int node_predecessor = -1;
    private static int node_position = -1;
    private static int node_successor = -1;
    private static int node = -1;
    private static int openBr = -1;
    private static int openPar = -1;
    private static int output = -1;
    private static int predicate = -1;
    private static int rule = -1;
    private static int srcPtr = -1;
    private static int semicol = -1;
    private static int slash = -1;
    private static int statement = -1;
    private static int string_literal = -1;
    private List<String> execOrder = new LinkedList<String>();
    Map<String, Predicate> namedPredicates = new HashMap<String, Predicate>();
    Map<String, Predicate> symbolicPredicates = new HashMap<String, Predicate>();
    private PredicateDependency dependency = new PredicateDependency();
    private Set<String> outputRelations = new HashSet<String>();

    public Program(Earley earley) {
        this.parser = earley;
    }

    public static void main(String[] stringArray) throws Exception {
        Parsed parsed = new Parsed(Service.readFile("c:/raptor_trunk/db/src/oracle/dbtools/raptor/phighlight/semantic_analysis.prg"), Program.getArboriParser(), "program");
        if (false & debug) {
            parsed.getRoot().printTree();
        }
        final Parsed parsed2 = new Parsed(Service.readFile(Program.class, "test.sql"), SqlEarley.getInstance(), "sql_statements");
        if (false & debug) {
            parsed2.getRoot().printTree();
        }
        SqlProgram sqlProgram = new SqlProgram(){
            int cursor;
            int offset;
            String newName;
            {
                this.cursor = parsed2.getInput().indexOf("p(pl_n)");
                this.offset = LexerToken.scanner2parserOffset(parsed2.getSrc(), this.cursor) + 1;
                this.newName = "-new name-";
            }
        };
        sqlProgram.program(parsed.getRoot(), parsed.getSrc(), parsed.getInput());
        System.out.println(sqlProgram.dependency);
        parsed2.getRoot();
        long l = System.currentTimeMillis();
        Map<String, MaterializedPredicate> map = sqlProgram.eval(parsed2);
        System.out.println("\n *********** eval time =" + (System.currentTimeMillis() - l) + "\n");
    }

    public static void replace(String string, String string2) throws Exception {
    }

    public static Earley getArboriParser() throws IOException {
        Set<RuleTuple> set = Program.getRules();
        Earley earley = new Earley((Set)set){

            @Override
            protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
                LexerToken lexerToken = list.get(n);
                return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING;
            }
        };
        atomic_predicate = (Integer)earley.symbolIndexes.get("atomic_predicate");
        bind_var = (Integer)earley.symbolIndexes.get("bind_var");
        backslash = (Integer)earley.symbolIndexes.get("'\\'");
        closePar = (Integer)earley.symbolIndexes.get("')'");
        closeBr = (Integer)earley.symbolIndexes.get("']'");
        col = (Integer)earley.symbolIndexes.get("':'");
        conj = (Integer)earley.symbolIndexes.get("'&'");
        disj = (Integer)earley.symbolIndexes.get("'|'");
        dot = (Integer)earley.symbolIndexes.get("'.'");
        eq = (Integer)earley.symbolIndexes.get("'='");
        excl = (Integer)earley.symbolIndexes.get("'!'");
        identifier = (Integer)earley.symbolIndexes.get("identifier");
        header = (Integer)earley.symbolIndexes.get("header");
        lt = (Integer)earley.symbolIndexes.get("'<'");
        minus = (Integer)earley.symbolIndexes.get("'-'");
        node_parent = (Integer)earley.symbolIndexes.get("node_parent");
        node_position = (Integer)earley.symbolIndexes.get("node_position");
        node_predecessor = (Integer)earley.symbolIndexes.get("node_predecessor");
        node_successor = (Integer)earley.symbolIndexes.get("node_successor");
        node = (Integer)earley.symbolIndexes.get("node");
        openBr = (Integer)earley.symbolIndexes.get("'['");
        openPar = (Integer)earley.symbolIndexes.get("'('");
        output = (Integer)earley.symbolIndexes.get("output");
        predicate = (Integer)earley.symbolIndexes.get("predicate");
        rule = (Integer)earley.symbolIndexes.get("rule");
        semicol = (Integer)earley.symbolIndexes.get("';'");
        slash = (Integer)earley.symbolIndexes.get("'/'");
        srcPtr = (Integer)earley.symbolIndexes.get("'?'");
        statement = (Integer)earley.symbolIndexes.get("statement");
        string_literal = (Integer)earley.symbolIndexes.get("string_literal");
        return earley;
    }

    private static Set<RuleTuple> getRules() throws IOException {
        String string = Service.readFile(Program.class, "arbori.grammar");
        List<LexerToken> list = LexerToken.parse(string);
        ParseNode parseNode = Grammar.parseGrammarFile(list, string);
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        Grammar.grammar(parseNode, list, treeSet);
        return treeSet;
    }

    public void program(ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.contains(statement)) {
            this.statement(parseNode, list, string);
            this.copyPredicates();
            return;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            this.program(parseNode2, list, string);
        }
        this.copyPredicates();
    }

    private void copyPredicates() {
        for (String string : this.namedPredicates.keySet()) {
            this.symbolicPredicates.put(string, this.namedPredicates.get(string));
        }
    }

    private void statement(ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.contains(rule)) {
            this.rule(parseNode, list, string);
        } else if (parseNode.contains(output)) {
            this.output(parseNode, list, string);
        }
    }

    private void rule(ParseNode parseNode, List<LexerToken> list, String string) {
        String string2 = null;
        boolean bl = false;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (string2 == null) {
                if (parseNode2.from + 1 == parseNode2.to) {
                    string2 = parseNode2.content(list);
                    continue;
                }
                return;
            }
            if (!bl) {
                if (parseNode2.contains(col)) {
                    bl = true;
                    continue;
                }
                return;
            }
            if (!parseNode2.contains(predicate)) continue;
            Predicate predicate = this.predicate(parseNode2, list, string);
            Map<String, Boolean> map = predicate.dependencies();
            for (String string3 : map.keySet()) {
                this.dependency.addDependency(string3, string2, map.get(string3));
            }
            this.execOrder.add(string2);
            this.namedPredicates.put(string2, predicate);
            return;
        }
    }

    private void output(ParseNode parseNode, List<LexerToken> list, String string) {
        for (ParseNode parseNode2 : parseNode.children()) {
            this.outputRelations.add(parseNode2.content(list));
        }
    }

    private Predicate predicate(ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.contains(identifier)) {
            return new PredRef(parseNode.content(list), this);
        }
        Predicate predicate = this.isBrackets(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        predicate = this.isParenthesis(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        predicate = this.isConjunction(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        predicate = this.isDisjunction(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        predicate = this.isDifference(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        predicate = this.isAtomicPredicate(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        throw new AssertionError((Object)("unexpected case for: " + parseNode.content(list)));
    }

    private Predicate isConjunction(ParseNode parseNode, List<LexerToken> list, String string) {
        ParseNode parseNode2 = null;
        boolean bl = false;
        for (ParseNode parseNode3 : parseNode.children()) {
            if (parseNode2 == null) {
                parseNode2 = parseNode3;
                continue;
            }
            if (!bl) {
                if (parseNode3.contains(conj)) {
                    bl = true;
                    continue;
                }
                return null;
            }
            Predicate predicate = this.predicate(parseNode2, list, string);
            Predicate predicate2 = this.predicate(parseNode3, list, string);
            return new CompositeExpr(predicate, predicate2, Oper.CONJUNCTION);
        }
        return null;
    }

    private Predicate isDisjunction(ParseNode parseNode, List<LexerToken> list, String string) {
        ParseNode parseNode2 = null;
        boolean bl = false;
        for (ParseNode parseNode3 : parseNode.children()) {
            if (parseNode2 == null) {
                parseNode2 = parseNode3;
                continue;
            }
            if (!bl) {
                if (parseNode3.contains(disj)) {
                    bl = true;
                    continue;
                }
                return null;
            }
            Predicate predicate = this.predicate(parseNode2, list, string);
            Predicate predicate2 = this.predicate(parseNode3, list, string);
            return new CompositeExpr(predicate, predicate2, Oper.DISJUNCTION);
        }
        return null;
    }

    private Predicate isDifference(ParseNode parseNode, List<LexerToken> list, String string) {
        ParseNode parseNode2 = null;
        boolean bl = false;
        for (ParseNode parseNode3 : parseNode.children()) {
            if (parseNode2 == null) {
                parseNode2 = parseNode3;
                continue;
            }
            if (!bl) {
                if (parseNode3.contains(minus)) {
                    bl = true;
                    continue;
                }
                return null;
            }
            Predicate predicate = this.predicate(parseNode2, list, string);
            Predicate predicate2 = this.predicate(parseNode3, list, string);
            return new CompositeExpr(predicate, predicate2, Oper.DIFFERENCE);
        }
        return null;
    }

    private Predicate isParenthesis(ParseNode parseNode, List<LexerToken> list, String string) {
        boolean bl = false;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!bl) {
                if (parseNode2.contains(openPar)) {
                    bl = true;
                    continue;
                }
                return null;
            }
            if (bl && parseNode2.contains(predicate)) {
                return this.predicate(parseNode2, list, string);
            }
            return null;
        }
        return null;
    }

    private Predicate isBrackets(ParseNode parseNode, List<LexerToken> list, String string) {
        boolean bl = false;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!bl) {
                if (parseNode2.contains(openBr)) {
                    bl = true;
                    continue;
                }
                return null;
            }
            if (bl) {
                if (parseNode2.contains(header)) {
                    return this.header(parseNode2, list, string);
                }
                if (!parseNode2.contains(closeBr)) continue;
                return new MaterializedPredicate(new ArrayList<String>(), list, "[]");
            }
            return null;
        }
        return null;
    }

    private MaterializedPredicate header(ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.contains(identifier)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(parseNode.content(list));
            return new MaterializedPredicate(arrayList, list, "[" + parseNode.content(list) + "]");
        }
        MaterializedPredicate materializedPredicate = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (materializedPredicate == null) {
                materializedPredicate = this.header(parseNode2, list, string);
                continue;
            }
            materializedPredicate = MaterializedPredicate.join(materializedPredicate, this.header(parseNode2, list, string));
        }
        return materializedPredicate;
    }

    private Predicate isAtomicPredicate(ParseNode parseNode, List<LexerToken> list, String string) {
        Predicate predicate = this.isExclamation(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        predicate = this.isNodeContent(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        predicate = this.isNodeMatchingSrc(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        predicate = this.isSameNode(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        predicate = this.isNodeAncestorDescendant(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        predicate = this.isAggregate(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        predicate = this.isPositionalRelation(parseNode, list, string);
        if (predicate != null) {
            return predicate;
        }
        return null;
    }

    private Predicate isAggregate(ParseNode parseNode, List<LexerToken> list, String string) {
        Boolean bl = null;
        boolean bl2 = false;
        ParseNode parseNode2 = null;
        boolean bl3 = false;
        ParseNode parseNode3 = null;
        for (ParseNode parseNode4 : parseNode.children()) {
            if (bl == null) {
                if (parseNode4.contains(slash)) {
                    bl = false;
                    continue;
                }
                if (parseNode4.contains(backslash)) {
                    bl = true;
                    continue;
                }
                return null;
            }
            if (!bl2) {
                if (bl & parseNode4.contains(slash) || bl == false & parseNode4.contains(backslash)) {
                    bl2 = true;
                    continue;
                }
                throw new AssertionError((Object)"Syntax error not caught by parsing?");
            }
            if (parseNode2 == null) {
                parseNode2 = parseNode4;
                continue;
            }
            if (!bl3) {
                if (parseNode4.contains(openPar)) {
                    bl3 = true;
                    continue;
                }
                throw new AssertionError((Object)"Syntax error not caught by parsing?");
            }
            parseNode3 = parseNode4;
            break;
        }
        Predicate predicate = this.predicate(parseNode3, list, string);
        return new AggregatePredicate(parseNode2.content(list), predicate, bl);
    }

    private Predicate isExclamation(ParseNode parseNode, List<LexerToken> list, String string) {
        boolean bl = false;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!bl) {
                if (parseNode2.contains(excl)) {
                    bl = true;
                    continue;
                }
                return null;
            }
            if (!bl) continue;
            return new CompositeExpr(this.predicate(parseNode2, list, string), null, Oper.NEGATION);
        }
        return null;
    }

    private Predicate isNodeContent(ParseNode parseNode, List<LexerToken> list, String string) {
        boolean bl = false;
        String string2 = null;
        boolean bl2 = false;
        String string3 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!bl) {
                if (parseNode2.contains(openBr)) {
                    bl = true;
                    continue;
                }
                return null;
            }
            if (string2 == null && parseNode2.contains(node)) {
                if (parseNode2.from + 1 == parseNode2.to || parseNode2.contains(node_parent) || parseNode2.contains(node_predecessor) || parseNode2.contains(node_successor)) {
                    string2 = parseNode2.content(list);
                    continue;
                }
                return null;
            }
            if (!bl2) {
                if (parseNode2.contains(closePar)) {
                    bl2 = true;
                    continue;
                }
                return null;
            }
            if (string3 == null) {
                string3 = parseNode2.content(list);
                continue;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        Integer n = (Integer)this.parser.symbolIndexes.get(string3);
        if (n == null) {
            throw new AssertionError((Object)("Symbol '" + string3 + "' not found"));
        }
        return new NodeContent(string2, n);
    }

    private Predicate isNodeMatchingSrc(ParseNode parseNode, List<LexerToken> list, String string) {
        boolean bl = false;
        String string2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!bl) {
                if (parseNode2.contains(srcPtr)) {
                    bl = true;
                    continue;
                }
                return null;
            }
            if (string2 == null) {
                if (parseNode2.contains(node)) {
                    string2 = parseNode2.content(list);
                    continue;
                }
                return null;
            }
            if (!bl2) {
                if (parseNode2.contains(eq)) {
                    bl2 = true;
                    continue;
                }
                return null;
            }
            if (!bl3) {
                if (parseNode2.contains(srcPtr)) {
                    bl3 = true;
                    continue;
                }
                if (parseNode2.contains(string_literal)) {
                    return new NodeMatchingSrc(string2, parseNode2.content(list));
                }
                return null;
            }
            if (string3 == null) {
                if (parseNode2.contains(node)) {
                    string3 = parseNode2.content(list);
                    continue;
                }
                return null;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        return new NodesWMatchingSrc(string2, string3);
    }

    private Predicate isNodeAncestorDescendant(ParseNode parseNode, List<LexerToken> list, String string) {
        boolean bl = true;
        Pair<String, String> pair = this.binaryPredicateNames(parseNode, list, lt);
        if (pair == null) {
            pair = this.binaryPredicateNames(parseNode, list, lt, eq);
            if (pair == null) {
                return null;
            }
            bl = false;
        }
        return new AncestorDescendantNodes(pair.first(), pair.second(), bl);
    }

    private Predicate isSameNode(ParseNode parseNode, List<LexerToken> list, String string) {
        Pair<String, String> pair = this.binaryPredicateNames(parseNode, list, eq);
        if (pair == null) {
            return null;
        }
        return new SameNodes(pair.first(), pair.second());
    }

    public Pair<String, String> binaryPredicateNames(ParseNode parseNode, List<LexerToken> list, int n) throws AssertionError {
        return this.binaryPredicateNames(parseNode, list, n, -1);
    }

    public Pair<String, String> binaryPredicateNames(ParseNode parseNode, List<LexerToken> list, int n, int n2) throws AssertionError {
        String string = null;
        boolean bl = false;
        boolean bl2 = -1 == n2;
        String string2 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (string == null) {
                if (parseNode2.contains(node)) {
                    string = parseNode2.content(list);
                    continue;
                }
                return null;
            }
            if (!bl) {
                if (parseNode2.contains(n)) {
                    bl = true;
                    continue;
                }
                return null;
            }
            if (!bl2) {
                if (parseNode2.contains(n2)) {
                    bl2 = true;
                    continue;
                }
                return null;
            }
            if (string2 == null) {
                if (parseNode2.contains(node)) {
                    string2 = parseNode2.content(list);
                    continue;
                }
                return null;
            }
            if (!parseNode2.contains(semicol)) {
                throw new AssertionError((Object)("unexpected case for: " + parseNode.content(list)));
            }
        }
        return new Pair<Object, Object>(string, string2);
    }

    private Predicate isPositionalRelation(ParseNode parseNode, List<LexerToken> list, String string) {
        Pair<String, PosType> pair = null;
        boolean bl = false;
        boolean bl2 = false;
        Pair<String, PosType> pair2 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (pair == null) {
                pair = this.nodeRelativePosition(parseNode2, list, string);
                if (pair != null) continue;
                return null;
            }
            if (!bl) {
                if (parseNode2.contains(lt)) {
                    bl = true;
                    continue;
                }
                return null;
            }
            if (parseNode2.contains(eq)) {
                bl2 = true;
                continue;
            }
            if (pair2 == null) {
                pair2 = this.nodeRelativePosition(parseNode2, list, string);
                if (pair2 != null) continue;
                return null;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        return new PositionalRelation((String)pair.first(), (PosType)((Object)pair.second()), (String)pair2.first(), (PosType)((Object)pair2.second()), bl2, this);
    }

    private Pair<String, PosType> nodeRelativePosition(ParseNode parseNode, List<LexerToken> list, String string) {
        String string2 = null;
        PosType posType = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (string2 == null && parseNode2.contains(node) || posType == PosType.BINDVAR) {
                string2 = parseNode2.content(list);
                continue;
            }
            if (posType != null) continue;
            if (parseNode2.contains(openBr)) {
                posType = PosType.HEAD;
                continue;
            }
            if (parseNode2.contains(closePar)) {
                posType = PosType.TAIL;
                continue;
            }
            if (parseNode2.contains(col)) {
                posType = PosType.BINDVAR;
                continue;
            }
            throw new AssertionError();
        }
        if (string2 == null) {
            throw new AssertionError((Object)"name == null");
        }
        if (posType == null) {
            throw new AssertionError((Object)"t == null");
        }
        return new Pair<Object, Object>(string2, posType);
    }

    public Map<String, MaterializedPredicate> eval(Parsed parsed) {
        parsed.getRoot();
        long l = System.currentTimeMillis();
        HashMap<String, MaterializedPredicate> hashMap = new HashMap<String, MaterializedPredicate>();
        boolean bl = this.outputRelations.size() == 0;
        for (String string : this.execOrder) {
            long l2 = System.currentTimeMillis();
            if (debug) {
                System.out.println(">=================================<     " + string);
            }
            MaterializedPredicate materializedPredicate = null;
            if (!bl && this.skipEmptyRelationEval(string)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                HashMap<String, Attribute> hashMap2 = new HashMap<String, Attribute>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                this.evalDimensions(string, hashMap2, arrayList2, arrayList, parsed, true);
                materializedPredicate = new MaterializedPredicate(arrayList, parsed.getSrc(), null);
            } else {
                materializedPredicate = new MaterializedPredicate(string, this.eval(parsed, string));
            }
            materializedPredicate.name = string;
            hashMap.put(string, materializedPredicate);
            this.namedPredicates.put(string, materializedPredicate);
            materializedPredicate.trimAttributes();
            if (!debug) continue;
            System.out.println(string + "=" + materializedPredicate);
        }
        this.namedPredicates = new HashMap<String, Predicate>();
        for (String string : this.symbolicPredicates.keySet()) {
            this.namedPredicates.put(string, this.symbolicPredicates.get(string));
        }
        long l3 = System.currentTimeMillis();
        if (debug) {
            System.out.println("eval time = " + (l3 - l));
        }
        return hashMap;
    }

    private MaterializedPredicate eval(Parsed parsed, String string) {
        int n;
        int n2;
        Predicate predicate = this.namedPredicates.get(string);
        MaterializedPredicate materializedPredicate = predicate.eval(parsed);
        if (materializedPredicate != null) {
            return materializedPredicate;
        }
        HashMap<String, Attribute> hashMap = new HashMap<String, Attribute>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int[] nArray = this.evalDimensions(string, hashMap, arrayList, arrayList2, parsed, false);
        if (nArray[0] == 0) {
            return new MaterializedPredicate(arrayList2, parsed.getSrc(), null);
        }
        boolean bl = true;
        if (debug) {
            System.out.print("Eval space = ");
            for (n2 = 0; n2 < nArray.length; ++n2) {
                System.out.print((bl ? "" : "x") + nArray[n2]);
                bl = false;
            }
            System.out.println();
        }
        bl = true;
        n2 = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= nArray[n2]) continue;
            n2 = i;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(n2);
        String string2 = arrayList.get(n2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add(string2);
        Attribute attribute = (Attribute)hashMap.get(string2);
        materializedPredicate = ((IndependentAttribute)attribute).getContent();
        while (hashSet.size() < nArray.length && (n = Program.minimalRelatedDimension(hashSet, nArray, arrayList, hashMap, predicate)) != -1) {
            hashSet.add(n);
            Attribute attribute2 = (Attribute)hashMap.get(arrayList.get(n));
            MaterializedPredicate materializedPredicate2 = ((IndependentAttribute)attribute2).getContent();
            Predicate predicate2 = new True();
            if (hashSet.size() != nArray.length) {
                for (String string3 : materializedPredicate.attributes) {
                    if (materializedPredicate.name != null) {
                        string3 = materializedPredicate.name + "." + string3;
                    }
                    for (String string4 : materializedPredicate2.attributes) {
                        Predicate predicate3;
                        if (materializedPredicate2.name != null) {
                            string4 = materializedPredicate2.name + "." + string4;
                        }
                        if ((predicate3 = predicate.isRelated(string3, string4, hashMap)) == null) continue;
                        predicate2 = new CompositeExpr(predicate2, predicate3, Oper.CONJUNCTION);
                    }
                }
                if (predicate2 instanceof True) {
                    throw new AssertionError((Object)"Cartesian product evaluation; check for missing binary predicates");
                }
            } else {
                predicate2 = predicate;
            }
            materializedPredicate = MaterializedPredicate.filteredCartesianProduct(materializedPredicate, materializedPredicate2, predicate2, hashMap, parsed.getRoot());
            if (!debug) continue;
            System.out.println("dim#" + hashSet.size() + ",cardinality=" + materializedPredicate.cardinality());
        }
        if (hashSet.size() == nArray.length) {
            return materializedPredicate;
        }
        throw new AssertionError((Object)("Missing dyadic predicate in predvar " + string + "; won't evaluate cartesian product"));
    }

    private int[] evalDimensions(String string, Map<String, Attribute> map, ArrayList<String> arrayList, ArrayList<String> arrayList2, Parsed parsed, boolean bl) {
        String string2;
        Predicate predicate = this.namedPredicates.get(string);
        Object object = new HashSet<String>();
        predicate.variables((Set<String>)object, true);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            this.extractDependentAttributes(string2, this.namedPredicates, map, arrayList);
        }
        if (debug) {
            System.out.println("Independent variables = " + arrayList);
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            string2 = arrayList.get(i);
            if (!bl) {
                IndependentAttribute independentAttribute = (IndependentAttribute)map.get(string2);
                if (((Object)object).length == 1) {
                    independentAttribute.putFilter(predicate);
                }
                independentAttribute.initContent(parsed.getRoot(), parsed.getSrc(), map, string);
                object[i] = independentAttribute.getLimits();
            } else {
                object[i] = false;
            }
            if (object[i] != false) continue;
            for (String string3 : map.keySet()) {
                if (map.get(string3) instanceof MaterializedPredicate) continue;
                arrayList2.add(string3);
            }
            object = new int[arrayList.size()];
            break;
        }
        return object;
    }

    private boolean skipEmptyRelationEval(String string) {
        for (String string2 : this.outputRelations) {
            if (!this.dependency.isDependent(string, string2)) continue;
            Map<String, Boolean> map = this.dependency.backward.get(string2);
            boolean bl = false;
            for (String string3 : map.keySet()) {
                Predicate predicate;
                if (Boolean.FALSE == map.get(string3) || !((predicate = this.namedPredicates.get(string3)) instanceof MaterializedPredicate) || ((MaterializedPredicate)predicate).tuples.size() != 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (debug) {
                System.out.println("No nullifier for " + string2);
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void extractDependentAttributes(String string, Map<String, Predicate> map, Map<String, Attribute> map2, ArrayList<String> arrayList) {
        if (map2.containsKey(string)) {
            return;
        }
        String string2 = Attribute.referredTo(string);
        if (string2 != null) {
            if (0 < string.indexOf(61)) {
                int n = string.indexOf(61);
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1);
                if (null == Attribute.referredTo(string3)) {
                    EqualExpr equalExpr = new EqualExpr(string3, string4);
                    map2.put(equalExpr.name, equalExpr);
                    arrayList.remove(equalExpr.name);
                    string2 = string4;
                } else {
                    if (null != Attribute.referredTo(string4)) {
                        this.extractDependentAttributes(string3, map, map2, arrayList);
                        this.extractDependentAttributes(string4, map, map2, arrayList);
                        return;
                    }
                    EqualExpr equalExpr = new EqualExpr(string4, string3);
                    map2.put(equalExpr.name, equalExpr);
                    arrayList.remove(equalExpr.name);
                    string2 = string3;
                }
            } else if (string.endsWith("^")) {
                map2.put(string, new Parent(string));
            } else if (string.endsWith("-1")) {
                map2.put(string, new Predecessor(string));
            } else if (string.endsWith("+1")) {
                map2.put(string, new Successor(string));
            } else {
                String string5;
                if (0 >= string.indexOf(46)) throw new AssertionError((Object)"unexpected case");
                String string6 = string.substring(0, string.indexOf(46));
                MaterializedPredicate materializedPredicate = (MaterializedPredicate)this.namedPredicates.get(string6);
                if (materializedPredicate.getAttribute(string5 = string.substring(string6.length() + 1)) == null) {
                    throw new AssertionError((Object)("Undefined variable " + string5 + " in " + string6));
                }
                map2.put(string, new Column(string));
                string2 = string6;
            }
            this.extractDependentAttributes(string2, map, map2, arrayList);
            return;
        }
        arrayList.add(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if ("eval".equals(stackTraceElementArray[2].getMethodName())) {
            map2.put(string, new IndependentAttribute(string, map));
            return;
        }
        Predicate predicate = this.namedPredicates.get(string);
        if (predicate == null) {
            map2.put(string, new IndependentAttribute(string, map));
            return;
        }
        if (!(predicate instanceof MaterializedPredicate)) {
            throw new AssertionError((Object)(" !(" + string + " instanceof MaterializedPredicate)"));
        }
        MaterializedPredicate materializedPredicate = (MaterializedPredicate)predicate;
        map2.put(string, materializedPredicate);
        materializedPredicate.name = string;
    }

    private static int minimalRelatedDimension(Set<Integer> set, int[] nArray, ArrayList<String> arrayList, Map<String, Attribute> map, Predicate predicate) {
        int n = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (set.contains(i) || !Program.isConnected(set, i, arrayList, map, predicate) || n != -1 && nArray[i] >= nArray[n]) continue;
            n = i;
        }
        return n;
    }

    private static boolean isConnected(Set<Integer> set, int n, ArrayList<String> arrayList, Map<String, Attribute> map, Predicate predicate) {
        String string = arrayList.get(n);
        for (int n2 : set) {
            String string2 = arrayList.get(n2);
            if (!Program.isRelated(string, string2, map, predicate)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRelated(String string, String string2, Map<String, Attribute> map, Predicate predicate) {
        for (String string3 : Program.functions(string, map)) {
            for (String string4 : Program.functions(string2, map)) {
                if (predicate.isRelated(string3, string4, map) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static List<String> functions(String string, Map<String, Attribute> map) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            linkedList.add(string2);
        }
        return linkedList;
    }
}

