/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class UnitTest {
    static boolean debug = false;
    static int testNo = 0;
    static boolean unitTestIsOK = true;
    private static int assertion = -1;
    private static int attribute = -1;
    private static int closePar = -1;
    private static int comment = -1;
    private static int col = -1;
    private static int content = -1;
    private static int header = -1;
    private static int marker = -1;
    private static int openPar = -1;
    private static int output = -1;
    private static int program_with_input = -1;
    private static int sql_prefix = -1;
    private static int sql_postfix = -1;
    private static int table = -1;
    private static int tables = -1;
    private static int value = -1;
    static Map<String, Parsed> parsed = new HashMap<String, Parsed>();
    static Map<String, UTProgram> programs = new HashMap<String, UTProgram>();

    public static void main(String[] stringArray) throws Exception {
        Set<RuleTuple> set = UnitTest.getRules();
        Earley earley = new Earley((Set)set){

            @Override
            protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
                LexerToken lexerToken = list.get(n);
                return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING;
            }
        };
        assertion = (Integer)earley.symbolIndexes.get("assertion");
        attribute = (Integer)earley.symbolIndexes.get("attribute");
        closePar = (Integer)earley.symbolIndexes.get("')'");
        col = (Integer)earley.symbolIndexes.get("':'");
        comment = (Integer)earley.symbolIndexes.get("comment");
        content = (Integer)earley.symbolIndexes.get("content");
        header = (Integer)earley.symbolIndexes.get("header");
        output = (Integer)earley.symbolIndexes.get("output");
        marker = (Integer)earley.symbolIndexes.get("marker");
        openPar = (Integer)earley.symbolIndexes.get("'('");
        program_with_input = (Integer)earley.symbolIndexes.get("program_with_input");
        sql_prefix = (Integer)earley.symbolIndexes.get("\"sql prefix\"");
        sql_postfix = (Integer)earley.symbolIndexes.get("\"sql postfix\"");
        table = (Integer)earley.symbolIndexes.get("table");
        tables = (Integer)earley.symbolIndexes.get("tables");
        value = (Integer)earley.symbolIndexes.get("value");
        String string = Service.readFile(UnitTest.class, "unit.test");
        List<LexerToken> list = LexerToken.parse(string);
        Visual visual = null;
        Matrix matrix = new Matrix(earley);
        earley.parse(list, matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax(string, new String[]{"atest"}, list, earley, matrix);
        if (syntaxError != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string2 : syntaxError.getSuggestions()) {
                System.out.print(string2 + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode parseNode = earley.forest(list, matrix);
        UnitTest.atest(parseNode, list, string);
        if (unitTestIsOK) {
            System.out.println("*** ALL TESTS are OK *** ---> ");
        } else {
            System.out.println("*** TEST FAILED! *** ---> ");
        }
    }

    private static Set<RuleTuple> getRules() throws Exception {
        String string = Service.readFile(UnitTest.class, "unitTest.grammar");
        List<LexerToken> list = LexerToken.parse(string);
        ParseNode parseNode = Grammar.parseGrammarFile(list, string);
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        Grammar.grammar(parseNode, list, treeSet);
        return treeSet;
    }

    private static void atest(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        if (parseNode.contains(assertion)) {
            UnitTest.assertion(parseNode, list, string);
            return;
        }
        if (parseNode.contains(output)) {
            UnitTest.output(parseNode, list, string);
            return;
        }
        if (parseNode.contains(comment)) {
            UnitTest.comment(parseNode, list, string);
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            UnitTest.atest(parseNode2, list, string);
        }
    }

    private static void output(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        Iterator<ParseNode> iterator = parseNode.children().iterator();
        if (iterator.hasNext()) {
            ParseNode parseNode2 = iterator.next();
            Map<String, MaterializedPredicate> map = UnitTest.runProgram(parseNode2, list, string);
            for (String string2 : map.keySet()) {
                MaterializedPredicate materializedPredicate = map.get(string2);
                if (materializedPredicate == null) {
                    System.err.println("!!! missing predicate " + string2);
                    continue;
                }
                System.out.println(string2 + "=" + materializedPredicate.toString(string2.length() + 1));
            }
            System.out.println("TEST#" + testNo++ + ":  ^^^^^ ");
            return;
        }
    }

    private static Map<String, MaterializedPredicate> runProgram(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> arrayList = null;
        boolean bl3 = false;
        String string3 = null;
        int n = -1;
        String string4 = null;
        for (ParseNode object2 : parseNode.children()) {
            if (string2 == null && object2.from + 1 == object2.to) {
                string2 = object2.content(list);
                if (string2.charAt(0) != '\"') continue;
                string2 = string2.substring(1, string2.length() - 1);
                continue;
            }
            if (!bl && object2.contains(col)) {
                bl = true;
                continue;
            }
            if (!bl2 && object2.contains(openPar)) {
                bl2 = true;
                continue;
            }
            if (arrayList == null) {
                arrayList = UnitTest.values(object2, list);
                continue;
            }
            if (!bl3 && object2.contains(closePar)) {
                bl3 = true;
                continue;
            }
            if (string3 == null && object2.contains(sql_prefix)) {
                string3 = string.substring(list.get((int)object2.from).begin, list.get((int)(object2.to - 1)).end);
                n = object2.to - object2.from;
                continue;
            }
            if (object2.contains(marker)) continue;
            if (string4 == null && object2.contains(sql_postfix)) {
                string4 = string.substring(list.get((int)object2.from).begin, list.get((int)(object2.to - 1)).end);
                continue;
            }
            throw new AssertionError((Object)"Unexpected case");
        }
        Object object3 = parsed.get(string2);
        if (object3 == null) {
            object3 = new Parsed(0 < string2.indexOf(47) || 0 < string2.indexOf(92) ? Service.readFile(string2) : Service.readFile(UnitTest.class, string2), Program.getArboriParser(), "program");
        }
        Parsed parsed = new Parsed(string4 == null ? string3 : string3 + ' ' + string4, SqlEarley.getInstance(), "sql_statements");
        UTProgram uTProgram = programs.get(string2);
        if (uTProgram == null) {
            uTProgram = new UTProgram();
            Program.debug = debug;
            uTProgram.program(((Parsed)object3).getRoot(), ((Parsed)object3).getSrc(), ((Parsed)object3).getInput());
        }
        uTProgram.offset = n;
        Map<String, MaterializedPredicate> map = uTProgram.eval(parsed);
        HashMap<String, MaterializedPredicate> hashMap = new HashMap<String, MaterializedPredicate>();
        for (String string5 : arrayList) {
            hashMap.put(string5, map.get(string5));
        }
        return hashMap;
    }

    private static void comment(ParseNode parseNode, List<LexerToken> list, String string) {
        System.out.println(string.substring(list.get((int)(parseNode.from + 2)).begin, list.get((int)(parseNode.to - 1)).end - 1));
    }

    private static void assertion(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        Map<String, MaterializedPredicate> map = null;
        HashMap<String, MaterializedPredicate> hashMap = null;
        boolean bl = false;
        boolean bl2 = false;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (map == null && parseNode2.contains(program_with_input)) {
                map = UnitTest.runProgram(parseNode2, list, string);
                continue;
            }
            if (!bl && parseNode2.from + 1 == parseNode2.to && "-".equals(parseNode2.content(list))) {
                bl = true;
                continue;
            }
            if (!bl2 && parseNode2.from + 1 == parseNode2.to && ">".equals(parseNode2.content(list))) {
                bl2 = true;
                continue;
            }
            if (hashMap == null && parseNode2.contains(tables)) {
                hashMap = new HashMap<String, MaterializedPredicate>();
                UnitTest.tables(hashMap, parseNode2, list, string);
                continue;
            }
            if (parseNode2.from + 1 != parseNode2.to || !";".equals(parseNode2.content(list))) {
                throw new AssertionError((Object)"Unexpected case");
            }
        }
        boolean bl3 = UnitTest.areMatching(map, hashMap);
        if (!bl3) {
            unitTestIsOK = false;
        }
        System.out.println("TEST#" + testNo++ + ":  ---> " + bl3);
    }

    private static boolean areMatching(Map<String, MaterializedPredicate> map, Map<String, MaterializedPredicate> map2) {
        if (map.size() != map2.size()) {
            return false;
        }
        for (String string : map.keySet()) {
            MaterializedPredicate materializedPredicate = map.get(string);
            MaterializedPredicate materializedPredicate2 = map2.get(string);
            if (materializedPredicate != null && materializedPredicate2 != null && UnitTest.areMatching(materializedPredicate, materializedPredicate2)) continue;
            return false;
        }
        return true;
    }

    private static boolean areMatching(MaterializedPredicate materializedPredicate, MaterializedPredicate materializedPredicate2) {
        ParseNode[] parseNodeArray;
        ParseNode[] parseNodeArray2;
        int n;
        if (materializedPredicate.arity() != materializedPredicate2.arity()) {
            return false;
        }
        if (materializedPredicate.tuples.size() != materializedPredicate2.tuples.size()) {
            return false;
        }
        for (n = 0; n < materializedPredicate.arity(); ++n) {
            parseNodeArray2 = materializedPredicate.getAttribute(n);
            if (parseNodeArray2.equals(parseNodeArray = materializedPredicate2.getAttribute(n))) continue;
            return false;
        }
        for (n = 0; n < materializedPredicate.cardinality(); ++n) {
            parseNodeArray2 = materializedPredicate.tuples.get(n);
            parseNodeArray = materializedPredicate2.tuples.get(n);
            for (int i = 0; i < parseNodeArray2.length; ++i) {
                if (parseNodeArray2[i].from == parseNodeArray[i].from && parseNodeArray2[i].to == parseNodeArray[i].to) continue;
                return false;
            }
        }
        return true;
    }

    private static void tables(Map<String, MaterializedPredicate> map, ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.contains(table)) {
            UnitTest.table(map, parseNode, list, string);
            return;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            UnitTest.tables(map, parseNode2, list, string);
        }
    }

    private static void table(Map<String, MaterializedPredicate> map, ParseNode parseNode, List<LexerToken> list, String string) {
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        MaterializedPredicate materializedPredicate = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (string2 == null && parseNode2.from + 1 == parseNode2.to) {
                string2 = parseNode2.content(list);
                continue;
            }
            if (!bl && parseNode2.from + 1 == parseNode2.to && "=".equals(parseNode2.content(list))) {
                bl = true;
                continue;
            }
            if (!bl2 && parseNode2.from + 1 == parseNode2.to && "[".equals(parseNode2.content(list))) {
                bl2 = true;
                continue;
            }
            if (materializedPredicate == null && parseNode2.contains(header)) {
                materializedPredicate = new MaterializedPredicate(UnitTest.values(parseNode2, list), list, null);
                continue;
            }
            if (!bl3 && parseNode2.from + 1 == parseNode2.to && "]".equals(parseNode2.content(list))) {
                bl3 = true;
                continue;
            }
            if (parseNode2.contains(content)) {
                UnitTest.addContent(materializedPredicate, parseNode2, list);
                continue;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        map.put(string2, materializedPredicate);
    }

    private static ArrayList<String> values(ParseNode parseNode, List<LexerToken> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (parseNode.from + 1 == parseNode.to && (list.get((int)parseNode.from).type == Token.IDENTIFIER || list.get((int)parseNode.from).type == Token.DQUOTED_STRING) || parseNode.contains(value) || parseNode.contains(attribute)) {
            arrayList.add(parseNode.content(list));
        } else {
            for (ParseNode parseNode2 : parseNode.children()) {
                arrayList.addAll(UnitTest.values(parseNode2, list));
            }
        }
        return arrayList;
    }

    private static void addContent(MaterializedPredicate materializedPredicate, ParseNode parseNode, List<LexerToken> list) {
        int n = 0;
        ParseNode[] parseNodeArray = new ParseNode[materializedPredicate.arity()];
        for (String string : UnitTest.values(parseNode, list)) {
            int n2 = string.indexOf(44);
            int n3 = string.indexOf(41);
            int n4 = Integer.parseInt(string.substring(1, n2));
            int n5 = Integer.parseInt(string.substring(n2 + 1, n3));
            parseNodeArray[n % materializedPredicate.arity()] = new ParseNode(n4, n5, -1, -1, null);
            if (n % materializedPredicate.arity() == materializedPredicate.arity() - 1) {
                materializedPredicate.addContent(parseNodeArray);
                parseNodeArray = new ParseNode[materializedPredicate.arity()];
            }
            ++n;
        }
    }

    static class UTProgram
    extends SqlProgram {
        int offset = -1;
        String newName = "-new name-";

        UTProgram() {
        }
    }
}

