/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.parser.Token;

public class LexerToken {
    public String content;
    public int begin;
    public int end;
    public Token type;

    public LexerToken(CharSequence charSequence, int n, int n2, Token token) {
        this.content = charSequence.toString().intern();
        this.begin = n;
        this.end = n2;
        this.type = token;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return "[" + this.begin + "," + this.end + ") " + this.content + "   <" + (Object)((Object)this.type) + ">";
    }

    public static void print(List<LexerToken> list) {
        int n = 0;
        for (LexerToken lexerToken : list) {
            System.out.print(n + "    ");
            lexerToken.print();
            ++n;
        }
    }

    public static void print(List<LexerToken> list, int n, int n2) {
        LexerToken.print(list, n, n2, false);
    }

    public static void print(List<LexerToken> list, int n, int n2, boolean bl) {
        for (int i = n; i < n2; ++i) {
            if (bl) {
                System.err.print(" " + list.get((int)i).content);
                continue;
            }
            System.out.print(" " + list.get((int)i).content);
        }
        if (bl) {
            System.err.println();
        } else {
            System.out.println();
        }
    }

    private static LinkedList<LexerToken> tokenize(String string, boolean bl, String string2) {
        LinkedList<LexerToken> linkedList = new LinkedList<LexerToken>();
        String string3 = "(){}[]^-|!*+.><='\",;:%@?/\\#" + string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3 + " \n\r\t", true);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            n += string4.length();
            LexerToken lexerToken = null;
            if (linkedList.size() > 0) {
                lexerToken = linkedList.getLast();
            }
            if (lexerToken != null && lexerToken.type == Token.COMMENT && (!lexerToken.content.endsWith("*/") || lexerToken.content.equals("/*/"))) {
                lexerToken.content = "*".equals(string4) || "/".equals(string4) ? lexerToken.content + string4 : "/* ... ";
                lexerToken.end = n;
                if (lexerToken == null || lexerToken.type != Token.COMMENT || !lexerToken.content.endsWith("*/") || lexerToken.content.equals("/*/")) continue;
                lexerToken.content = string.substring(lexerToken.begin, lexerToken.end);
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.LINE_COMMENT && !"\n".equals(string4)) {
                lexerToken.content = lexerToken.content + string4;
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.LINE_COMMENT && "\n".equals(string4)) {
                lexerToken.end = n - string4.length();
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
            }
            if (lexerToken != null && lexerToken.type == Token.QUOTED_STRING && !lexerToken.isStandardLiteral() && !lexerToken.isAltLiteral()) {
                lexerToken.content = lexerToken.content + string4;
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.DQUOTED_STRING && !"\"".equals(string4) && (!lexerToken.content.endsWith("\"") || lexerToken.content.length() <= 1)) continue;
            if (lexerToken != null && lexerToken.type == Token.DQUOTED_STRING && "\"".equals(string4)) {
                lexerToken.end = n;
                lexerToken.content = string.substring(lexerToken.begin, lexerToken.end);
                continue;
            }
            if ("*".equals(string4) && lexerToken != null && "/".equals(lexerToken.content)) {
                lexerToken.content = lexerToken.content + string4;
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
                lexerToken.type = Token.COMMENT;
                continue;
            }
            if ("-".equals(string4) && lexerToken != null && "-".equals(lexerToken.content)) {
                lexerToken.content = lexerToken.content + string4;
                lexerToken.type = Token.LINE_COMMENT;
                continue;
            }
            if (("rem".equalsIgnoreCase(string4) || "rema".equalsIgnoreCase(string4) || "remar".equalsIgnoreCase(string4) || "remark".equalsIgnoreCase(string4)) && (lexerToken == null || "\n".equals(lexerToken.content) || "\r".equals(lexerToken.content))) {
                linkedList.add(new LexerToken(string4, n - 1, -9, Token.LINE_COMMENT));
                continue;
            }
            if ("@".equalsIgnoreCase(string4) && (lexerToken == null || "\n".equals(lexerToken.content) || "\r".equals(lexerToken.content))) {
                linkedList.add(new LexerToken(string4, n - 1, -11, Token.IDENTIFIER));
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.IDENTIFIER && lexerToken.end == -11 && lexerToken.content.startsWith("@") && !"\n".equals(string4) && !"\r".equals(string4)) {
                lexerToken.content = lexerToken.content + string4;
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.IDENTIFIER && lexerToken.end == -11 && lexerToken.content.startsWith("@") && ("\n".equals(string4) || "\r".equals(string4))) {
                lexerToken.end = n - 1;
                linkedList.add(new LexerToken(string4, n - 1, n, Token.WS));
                continue;
            }
            if (bl && "'".equals(string4)) {
                if (lexerToken != null && ("q".equalsIgnoreCase(lexerToken.content) || "N".equalsIgnoreCase(lexerToken.content) || "nq".equalsIgnoreCase(lexerToken.content))) {
                    lexerToken.content = lexerToken.content + string4;
                    lexerToken.type = Token.QUOTED_STRING;
                    continue;
                }
                linkedList.add(new LexerToken(string4, n - 1, -10, Token.QUOTED_STRING));
                continue;
            }
            if (bl && "\"".equals(string4)) {
                linkedList.add(new LexerToken(string4, n - 1, -11, Token.DQUOTED_STRING));
                continue;
            }
            if (string3.contains(string4)) {
                linkedList.add(new LexerToken(string4, n - 1, n, Token.OPERATION));
                continue;
            }
            if (" \n\r\t".contains(string4)) {
                linkedList.add(new LexerToken(string4, n - 1, n, Token.WS));
                continue;
            }
            if ('0' <= string4.charAt(0) && string4.charAt(0) <= '9') {
                if (LexerToken.fixedExponent(string4, linkedList, n - string4.length())) continue;
                linkedList.add(new LexerToken(string4, n - string4.length(), n, Token.DIGITS));
                continue;
            }
            linkedList.add(new LexerToken(string4, n - string4.length(), n, Token.IDENTIFIER));
        }
        return linkedList;
    }

    private static boolean fixedExponent(String string, List<LexerToken> list, int n) {
        if (!(string.contains("e") || string.contains("f") || string.contains("d"))) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "efd", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n += string2.length();
            if ('0' <= string2.charAt(0) && string2.charAt(0) <= '9') {
                list.add(new LexerToken(string2, n - string2.length(), n, Token.DIGITS));
                continue;
            }
            list.add(new LexerToken(string2, n - string2.length(), n, Token.IDENTIFIER));
        }
        return true;
    }

    public static List<LexerToken> parse(String string) {
        return LexerToken.parse(string, false);
    }

    public static List<LexerToken> parse(String string, String string2) {
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        LexerToken.parse(string, false, true, string2, arrayList);
        return arrayList;
    }

    public static List<LexerToken> parse(String string, boolean bl) {
        return LexerToken.parse(string, bl, true);
    }

    public static List<LexerToken> parse(String string, boolean bl, boolean bl2) {
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        LexerToken.parse(string, bl, bl2, "", arrayList);
        return arrayList;
    }

    private static void parse(String string, boolean bl, boolean bl2, String string2, List<LexerToken> list) {
        LexerToken lexerToken = null;
        for (LexerToken lexerToken2 : LexerToken.tokenize(string, bl2, string2)) {
            if (lexerToken2.type == Token.QUOTED_STRING) {
                if (lexerToken != null && lexerToken.type == Token.QUOTED_STRING) {
                    lexerToken.content = lexerToken.content + lexerToken2.content;
                    lexerToken.end = lexerToken2.end;
                    continue;
                }
                if (lexerToken != null && lexerToken.type == Token.IDENTIFIER && "n".equalsIgnoreCase(lexerToken.content) && lexerToken.end == lexerToken2.begin) {
                    lexerToken.begin = lexerToken2.begin;
                    lexerToken.end = lexerToken2.end;
                    lexerToken.type = lexerToken2.type;
                    lexerToken.content = lexerToken2.content;
                    continue;
                }
            }
            if (lexerToken2.content.startsWith("@")) {
                lexerToken2.end = lexerToken2.begin + lexerToken2.content.length();
            }
            if ("#".equals(lexerToken2.content) && lexerToken != null && lexerToken.type == Token.IDENTIFIER) {
                ++lexerToken.end;
                lexerToken.content = lexerToken.content + "#";
                continue;
            }
            if ((lexerToken2.type == Token.IDENTIFIER || lexerToken2.type == Token.DIGITS) && lexerToken != null && lexerToken.content.endsWith("#") && lexerToken.type == Token.IDENTIFIER) {
                lexerToken.end += lexerToken2.content.length();
                lexerToken.content = lexerToken.content + lexerToken2.content;
                continue;
            }
            if (bl || lexerToken2.type != Token.WS && lexerToken2.type != Token.COMMENT && lexerToken2.type != Token.LINE_COMMENT) {
                list.add(lexerToken2);
            }
            lexerToken = lexerToken2;
        }
    }

    public static int scanner2parserOffset(List<LexerToken> list, int n) {
        int n2 = -1;
        for (LexerToken lexerToken : list) {
            ++n2;
            if (lexerToken.end <= n) continue;
            break;
        }
        return n2;
    }

    private static char matchingDelimiter(char c) {
        if ('<' == c) {
            return '>';
        }
        if ('[' == c) {
            return ']';
        }
        if ('{' == c) {
            return '}';
        }
        if ('(' == c) {
            return ')';
        }
        return c;
    }

    private boolean isStandardLiteral() {
        if (this.content.length() < 2) {
            return false;
        }
        if (this.content.charAt(0) != '\'' && this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N') {
            return false;
        }
        String string = this.content;
        if (string.charAt(0) == 'n' || string.charAt(0) == 'N') {
            if (string.length() < 3) {
                return false;
            }
            string = string.substring(1);
        }
        if (string.length() < 2) {
            return false;
        }
        return string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'';
    }

    private boolean isAltLiteral() {
        if (this.content.length() < 5) {
            return false;
        }
        if (this.content.charAt(0) != 'q' && this.content.charAt(0) != 'Q' && this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N') {
            return false;
        }
        String string = this.content;
        if (this.content.charAt(0) == 'q' || this.content.charAt(0) == 'Q') {
            string = string.substring(1);
        } else if (!(this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N' || this.content.charAt(1) != 'q' && this.content.charAt(1) != 'Q')) {
            if (string.length() < 6) {
                return false;
            }
            string = string.substring(2);
        } else {
            return false;
        }
        if (string.charAt(0) != '\'' || string.charAt(string.length() - 1) != '\'') {
            return false;
        }
        string = string.substring(1, string.length() - 1);
        return LexerToken.matchingDelimiter(string.charAt(0)) == string.charAt(string.length() - 1);
    }

    public static void moveInterval(List<LexerToken> list, int n) {
        for (LexerToken lexerToken : list) {
            lexerToken.begin += n;
            lexerToken.end += n;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2;
        for (String string : stringArray2 = new String[]{"q'#without it does not#'", "i# := 1; i#j := 2;"}) {
            LexerToken.testInput(string);
        }
    }

    private static void testInput(String string) {
        System.gc();
        long l = System.currentTimeMillis();
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = Runtime.getRuntime().freeMemory();
        List<LexerToken> list = LexerToken.parse(string);
        long l4 = System.currentTimeMillis();
        l2 = Runtime.getRuntime().totalMemory();
        l3 = Runtime.getRuntime().freeMemory();
        LexerToken.print(list);
    }
}

