/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Parser;

public class Matrix {
    private Parser parser;
    private Map<Integer, Cell>[] cells = null;
    private int lastY = 0;

    public Matrix(Parser parser) {
        this.parser = parser;
    }

    public Cell get(int n, int n2) {
        return this.cells[n2].get(n);
    }

    public void put(int n, int n2, Cell cell) {
        if (this.lastY < n2) {
            this.lastY = n2;
        }
        this.cells[n2].put(n, cell);
    }

    public void initCells(int n) {
        this.cells = new Map[n + 1];
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i] = new HashMap<Integer, Cell>();
        }
    }

    public int lastY() {
        return this.lastY;
    }

    public Map<Integer, Cell> getXRange(int n) {
        return this.cells[n];
    }

    public boolean contains(int n, int n2, int n3) {
        Cell cell = this.get(n, n2);
        if (cell == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = this.parser instanceof Earley;
        for (int i = 0; i < cell.size(); ++i) {
            if (bl && cell.getSymbol(i) == n3) {
                return true;
            }
            if (!bl2) continue;
            Earley earley = (Earley)this.parser;
            Earley.Tuple tuple = earley.rules[cell.getRule(i)];
            if (tuple.head != n3 || tuple.rhs.length != cell.getPosition(i)) continue;
            return true;
        }
        return false;
    }

    public String toString() throws RuntimeException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.cells.length; ++i) {
            for (int n : this.cells[i].keySet()) {
                stringBuffer.append("[" + i + "," + n + ")");
                Cell cell = this.get(i, n);
                if (cell == null) {
                    throw new AssertionError((Object)("no value corresponding to the key [" + i + "," + n + ")"));
                }
                for (int j = 0; j < cell.size() && j < 6; ++j) {
                    if (j == 5) {
                        stringBuffer.append(" ...");
                    }
                    ((Earley)this.parser).toString(cell.getRule(j), cell.getPosition(j), stringBuffer);
                }
                stringBuffer.append('\n');
            }
        }
        return stringBuffer.toString();
    }

    List<Integer> getCykBackptrs(int n, int n2, int n3) {
        throw new AssertionError((Object)"CYK parser is no longer maintained");
    }

    List<Integer> getEarleyBackptrs(int n, int n2, Cell cell, int n3) {
        Object object;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n == n2 && n == 0) {
            arrayList.add(n);
            return arrayList;
        }
        int n4 = cell.getRule(n3);
        Earley.Tuple tuple = ((Earley)this.parser).rules[n4];
        int n5 = cell.getPosition(n3);
        if (n == n2) {
            Map<Integer, Cell> map = this.cells[n2];
            block0: for (int n6 : map.keySet()) {
                Cell cell2;
                if (n < n6 || (cell2 = this.get(n6, n)) == null) continue;
                for (int i = 0; i < cell2.size(); ++i) {
                    Earley.Tuple tuple2 = ((Earley)this.parser).rules[cell2.getRule(i)];
                    int n7 = cell2.getPosition(i);
                    if (n7 >= tuple2.rhs.length || tuple2.rhs[n7] != tuple.head) continue;
                    if (arrayList.contains(n6)) continue block0;
                    arrayList.add(n6);
                    continue block0;
                }
            }
            return arrayList;
        }
        Cell cell3 = this.get(n, n2 - 1);
        if (cell3 != null) {
            for (int i = 0; i < cell3.size(); ++i) {
                int n8;
                int n9 = cell3.getRule(i);
                if (n4 != n9 || (n8 = cell3.getPosition(i)) + 1 != n5) continue;
                object = ((Earley)this.parser).rules[n9];
                if (((Earley.Tuple)object).rhs[n8] != ((Earley)this.parser).identifier && ((Earley.Tuple)object).rhs[n8] != ((Earley)this.parser).string_literal && ((Earley.Tuple)object).rhs[n8] != ((Earley)this.parser).digits && this.parser.allSymbols[((Earley.Tuple)object).rhs[n8]].charAt(0) != '\'') continue;
                arrayList.add(n2 + 1);
                break;
            }
        }
        Map<Integer, Cell> map = this.cells[n2];
        block3: for (int n8 : map.keySet()) {
            Cell cell4;
            if (n8 < n || n2 < n8 || (object = this.get(n, n8)) == null || (cell4 = this.get(n8, n2)) == null) continue;
            for (int i = 0; i < object.size(); ++i) {
                for (int j = 0; j < cell4.size(); ++j) {
                    int n10;
                    int n11 = object.getRule(i);
                    int n12 = cell4.getRule(j);
                    int n13 = object.getPosition(i);
                    int n14 = cell4.getPosition(j);
                    Earley.Tuple tuple3 = ((Earley)this.parser).rules[n11];
                    Earley.Tuple tuple4 = ((Earley)this.parser).rules[n12];
                    if (tuple4.size() != n14 || n11 != n4 || n13 + 1 != n5 || (n10 = tuple3.content(n13)) != tuple4.head) continue;
                    arrayList.add(n8);
                    continue block3;
                }
            }
        }
        return arrayList;
    }
}

