/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SqlEarley;

public class LazyNode
extends ParseNode {
    public String startToken;
    List<LexerToken> src;
    private ParseNode branch = null;

    public LazyNode(int n, String string, List<LexerToken> list) {
        super(n, -1, -1, -1, null);
        this.startToken = string;
        this.src = list;
    }

    public ParseNode getBranch() {
        return this.branch;
    }

    @Override
    public Set<ParseNode> children() {
        if (this.branch == null) {
            return super.children();
        }
        TreeSet<ParseNode> treeSet = new TreeSet<ParseNode>();
        treeSet.addAll(super.children());
        treeSet.add(this.branch);
        return treeSet;
    }

    @Override
    public ParseNode childAt(int n, int n2) {
        if (this.branch == null) {
            return super.childAt(n, n2);
        }
        return this.branch.childAt(n, n2);
    }

    public List<LazyNode> shallowChildren() {
        ArrayList<LazyNode> arrayList = new ArrayList<LazyNode>();
        for (ParseNode parseNode : super.children()) {
            if (!(parseNode instanceof LazyNode)) continue;
            arrayList.add((LazyNode)parseNode);
        }
        return arrayList;
    }

    public List<LazyNode> shallowDescendants() {
        ArrayList<LazyNode> arrayList = new ArrayList<LazyNode>();
        arrayList.add(this);
        for (ParseNode parseNode : this.shallowChildren()) {
            arrayList.addAll(((LazyNode)parseNode).shallowDescendants());
        }
        return arrayList;
    }

    public List<LazyNode> shallowIntermediates(int n, int n2) {
        ArrayList<LazyNode> arrayList = new ArrayList<LazyNode>();
        if (this.from <= n && n2 <= this.to) {
            arrayList.add(this);
        }
        for (LazyNode lazyNode : this.shallowChildren()) {
            if (lazyNode.from > n || n2 > lazyNode.to) continue;
            arrayList.addAll(lazyNode.shallowIntermediates(n, n2));
        }
        return arrayList;
    }

    public LazyNode shallowParent(int n, int n2) {
        for (LazyNode lazyNode : this.shallowIntermediates(n, n2)) {
            for (LazyNode lazyNode2 : lazyNode.shallowChildren()) {
                if (lazyNode2.from != n || lazyNode2.to != n2) continue;
                return lazyNode;
            }
        }
        return null;
    }

    public LazyNode shallowLeaf(int n, int n2) {
        for (LazyNode lazyNode : this.shallowIntermediates(n, n2)) {
            if (lazyNode.shallowChildren().size() != 0 || lazyNode.from > n || n2 > lazyNode.to) continue;
            return lazyNode;
        }
        return null;
    }

    public LazyNode ancestor(int n, int n2) {
        List<LazyNode> list = this.shallowChildren();
        if (list.size() == 0) {
            return this;
        }
        for (LazyNode lazyNode : list) {
            if (lazyNode.from > n || n2 > lazyNode.to) continue;
            return lazyNode.ancestor(n, n2);
        }
        return this;
    }

    @Override
    public boolean isAuxiliary() {
        return false;
    }

    @Override
    protected String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("[" + this.from + "," + this.to + ") ");
        stringBuffer.append("  " + this.startToken);
        return stringBuffer.toString();
    }

    public boolean isAs() {
        return "is".equalsIgnoreCase(this.startToken) || "as".equalsIgnoreCase(this.startToken) || "before".equalsIgnoreCase(this.startToken) || "after".equalsIgnoreCase(this.startToken) || "of".equalsIgnoreCase(this.startToken);
    }

    public boolean isCompilationUnit() {
        return "package".equalsIgnoreCase(this.startToken) || "trigger".equalsIgnoreCase(this.startToken) || this.isProcedure();
    }

    public boolean isProcedure() {
        return "function".equalsIgnoreCase(this.startToken) || "procedure".equalsIgnoreCase(this.startToken);
    }

    public boolean isDML() {
        return this.isDML(null);
    }

    public boolean isDML(String string) {
        return !"(".equals(string) && !";".equals(string) && ("insert".equalsIgnoreCase(this.startToken) || "update".equalsIgnoreCase(this.startToken) || "delete".equalsIgnoreCase(this.startToken) || "select".equalsIgnoreCase(this.startToken) || "with".equalsIgnoreCase(this.startToken) && !"context".equalsIgnoreCase(string) || "cursor".equalsIgnoreCase(this.startToken) && !"is".equalsIgnoreCase(string) && !"as".equalsIgnoreCase(string) || "merge".equalsIgnoreCase(this.startToken) || "fetch".equalsIgnoreCase(this.startToken));
    }

    public boolean isDDL(String string) {
        return "alter".equalsIgnoreCase(this.startToken) || "create".equalsIgnoreCase(this.startToken) || "grant".equalsIgnoreCase(this.startToken) || "drop".equalsIgnoreCase(this.startToken) || "comment".equalsIgnoreCase(this.startToken) || "administer".equalsIgnoreCase(this.startToken) && "key".equalsIgnoreCase(string);
    }

    boolean isControlStmt(LazyNode lazyNode) {
        String string = "N/A";
        ParseNode parseNode = lazyNode.parent(this.from, this.to);
        if (parseNode != null && parseNode instanceof LazyNode) {
            string = ((LazyNode)parseNode).startToken;
        }
        return "if".equalsIgnoreCase(this.startToken) || "case".equalsIgnoreCase(this.startToken) || "for".equalsIgnoreCase(this.startToken) || "while".equalsIgnoreCase(this.startToken) || "loop".equalsIgnoreCase(this.startToken) && !"for".equalsIgnoreCase(string) && !"while".equalsIgnoreCase(string);
    }

    public boolean isStmt(LazyNode lazyNode) {
        if ("declare".equalsIgnoreCase(this.startToken)) {
            return true;
        }
        if ("begin".equalsIgnoreCase(this.startToken)) {
            ParseNode parseNode = lazyNode.parent(this.from, this.to);
            LazyNode lazyNode2 = (LazyNode)parseNode;
            if (lazyNode2 == null) {
                return true;
            }
            if (!"declare".equalsIgnoreCase(lazyNode2.startToken) && !lazyNode2.isProcedure()) {
                return true;
            }
        }
        return this.isControlStmt(lazyNode) || this.isDML(null) || this.isDDL(null);
    }

    public void expand() throws FragmentTooLargeException {
        if (this.from + 20000 < this.to) {
            throw new FragmentTooLargeException();
        }
        if (this.branch != null) {
            return;
        }
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        int n = -1;
        for (LexerToken object2 : this.src) {
            if (this.from > ++n || n >= this.to) continue;
            arrayList.add(object2);
        }
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix(sqlEarley);
        sqlEarley.parse(arrayList, matrix);
        this.branch = sqlEarley.forest(arrayList, matrix);
        this.branch.moveInterval(this.from);
    }

    public List<LexerToken> getSrcFragment() {
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        int n = -1;
        int n2 = 0;
        for (LexerToken lexerToken : this.src) {
            if (this.to <= ++n) break;
            if (this.from == n) {
                n2 = lexerToken.begin;
            }
            if (this.from > n) continue;
            arrayList.add(new LexerToken(lexerToken.content, lexerToken.begin - n2, lexerToken.end - n2, lexerToken.type));
        }
        return arrayList;
    }

    @Override
    public void addContent(String string) {
        this.startToken = string;
    }

    public static class FragmentTooLargeException
    extends Exception {
    }
}

