/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parseable;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.UnifiedRules;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class SqlEarley
extends Earley
implements Parseable {
    private static SqlEarley instance = null;
    private static SqlEarley fullRecInst = null;
    private static Set<RuleTuple> origRules;
    private int begin;
    private int body;
    private int dotted_name;
    public int decl_id;
    private int distinct;
    public int multiset_except;
    private int pkg_spec;
    public int sql_statements;
    public int subprg_body;
    private int start;
    public int table_reference;
    public boolean fifteenPctLAImpr = true;
    Integer LAsuspect = null;
    private Set<Integer> keywords = new TreeSet<Integer>();

    public static void main(String[] stringArray) throws Exception {
        Cell cell;
        System.out.println("!nil=" + SqlEarley.getInstance().getSymbol("!nil"));
        System.out.println("allSymbols[0]=" + SqlEarley.getInstance().allSymbols[0]);
        System.out.println("allSymbols[1]=" + SqlEarley.getInstance().allSymbols[1]);
        System.out.println("allSymbols[2]=" + SqlEarley.getInstance().allSymbols[2]);
        boolean bl = false;
        block0: for (RuleTuple ruleTuple : origRules) {
            if (ruleTuple.head.contains("subprg_d")) {
                System.out.println(ruleTuple.toString());
                continue;
            }
            if (bl) continue;
            for (int i = 0; i < ruleTuple.rhs.length; ++i) {
                if (!ruleTuple.rhs[i].contains("subprg_d")) continue;
                System.out.println(ruleTuple.toString());
                continue block0;
            }
        }
        String string = Service.readFile(SqlEarley.class, "test.sql");
        long l = System.currentTimeMillis();
        List<LexerToken> list = LexerToken.parse(string);
        if (list.size() > Integer.MAX_VALUE) {
            throw new AssertionError((Object)(list.size() + " tokens"));
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Lex time = " + (l2 - l));
        l = System.currentTimeMillis();
        SqlEarley sqlEarley = SqlEarley.fullRecognizer();
        sqlEarley = SqlEarley.partialRecognizer();
        l2 = System.currentTimeMillis();
        System.out.println("Earley init time = " + (l2 - l));
        Matrix matrix = new Matrix(sqlEarley);
        Visual visual = null;
        if (list.size() < 1000) {
            visual = new Visual(list, sqlEarley);
        }
        l = System.currentTimeMillis();
        sqlEarley.parse(list, matrix);
        l2 = System.currentTimeMillis();
        System.out.println("Earley parse time = " + (l2 - l));
        if (visual != null) {
            visual.draw(matrix);
        }
        if ((cell = matrix.get(0, list.size())) != null) {
            System.out.println(list.size() + " tokens, top = " + cell.toString());
        } else {
            System.out.println("***** Syntactically Invalid fargment *****");
        }
        l = System.currentTimeMillis();
        ParseNode parseNode = sqlEarley.forest(list, matrix);
        l2 = System.currentTimeMillis();
        System.out.println("Reduction time = " + (l2 - l));
        if (list.size() < 1000) {
            parseNode.printTree();
        }
    }

    public static SqlEarley partialRecognizer() {
        if (instance == null) {
            instance = new SqlEarley();
        }
        return instance;
    }

    public static SqlEarley getInstance() {
        return SqlEarley.fullRecognizer();
    }

    public static SqlEarley fullRecognizer() {
        if (fullRecInst == null) {
            fullRecInst = new SqlEarley(){
                long[] content = null;

                @Override
                protected void initCell00(List<LexerToken> list, Matrix matrix) {
                    long l = 0L;
                    if (this.visual != null) {
                        l = System.nanoTime();
                    }
                    if (this.content == null) {
                        for (int i = 0; i < this.rules.length; ++i) {
                            Earley.Tuple tuple = this.rules[i];
                            String string = this.allSymbols[tuple.head];
                            if (string.charAt(string.length() - 1) == ')') continue;
                            this.content = Array.insert(this.content, this.makeMatrixCellElem(i, 0, tuple));
                        }
                    }
                    matrix.initCells(list.size());
                    matrix.put(0, 0, new Earley.EarleyCell(Arrays.copyOf(this.content, this.content.length)));
                    this.allXs = Array.insert(this.allXs, 0);
                    if (this.visual != null) {
                        long l2 = System.nanoTime();
                        long[] lArray = this.visual.visited[0];
                        lArray[0] = lArray[0] + (long)((int)(l2 - l));
                    }
                }

                @Override
                protected void complete(Matrix matrix) {
                    if (matrix.lastY() == 0) {
                        return;
                    }
                    super.complete(matrix);
                }

                @Override
                protected void predict(Matrix matrix) {
                    if (matrix.lastY() == 0) {
                        return;
                    }
                    super.predict(matrix);
                }
            };
        }
        return fullRecInst;
    }

    private SqlEarley() {
        super(origRules, false);
        this.initKeywords();
        this.begin = this.getSymbol("'BEGIN'");
        this.body = this.getSymbol("'BODY'");
        this.dotted_name = this.getSymbol("dotted_name");
        this.decl_id = this.getSymbol("decl_id");
        this.distinct = this.getSymbol("'DISTINCT'");
        this.multiset_except = this.getSymbol("multiset_except");
        this.pkg_spec = this.getSymbol("pkg_spec");
        this.sql_statements = this.getSymbol("sql_statements");
        this.subprg_body = this.getSymbol("subprg_body");
        this.start = this.getSymbol("'START'");
        this.table_reference = this.getSymbol("table_reference");
        this.prioritizeRules();
        this.precomputePredictions();
    }

    private void prioritizeRules() {
        this.prioritizeRules(this.getSymbol("expr"), new int[]{this.getSymbol("simple_expression"), this.getSymbol("function_expression"), this.getSymbol("object_access_expression"), this.getSymbol("type_constructor_expression")});
        this.prioritizeRules(this.getSymbol("simple_expression"), new int[]{this.getSymbol("column"), this.getSymbol("identifier")});
        this.prioritizeRules(this.getSymbol("function_expression"), new int[]{this.getSymbol("function"), this.getSymbol("count"), this.getSymbol("function_call")});
        this.prioritizeRules(this.getSymbol("function"), new int[]{this.getSymbol("analytic_function"), this.getSymbol("aggregate_function"), this.getSymbol("single_row_function"), this.getSymbol("user_defined_function"), this.getSymbol("object_reference_function")});
        this.prioritizeRules(this.getSymbol("comparison_condition"), new int[]{this.getSymbol("between_condition"), this.getSymbol("group_comparison_condition"), this.getSymbol("simple_comparison_condition")});
        this.prioritizeRules(this.getSymbol("analytic_function"), new int[]{this.getSymbol("count"), this.getSymbol("nth_value"), this.getSymbol("first_last_value"), this.getSymbol("listagg"), this.getSymbol("a_f")});
        this.prioritizeRules(this.getSymbol("windowing_clause[31,73)"), new int[]{this.getSymbol("'UNBOUNDED'"), this.getSymbol("expr")});
        this.prioritizeRules(this.getSymbol("windowing_clause[81,123)"), new int[]{this.getSymbol("'UNBOUNDED'"), this.getSymbol("expr")});
    }

    private void prioritizeRules(int n, int[] nArray) {
        int n2;
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < this.rules.length; ++i) {
            Earley.Tuple tuple = this.rules[i];
            if (tuple.head != n) continue;
            for (int j = 0; j < nArray.length; ++j) {
                if (tuple.rhs[0] != nArray[j]) continue;
                nArray2[j] = -i;
            }
        }
        Earley.Tuple[] tupleArray = new Earley.Tuple[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            tupleArray[n2] = this.rules[-nArray2[n2]];
        }
        Arrays.sort(nArray2);
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            this.rules[-nArray2[n2]] = tupleArray[n2];
        }
    }

    @Override
    protected void initCell00(List<LexerToken> list, Matrix matrix) {
        long l = 0L;
        if (this.visual != null) {
            l = System.nanoTime();
        }
        matrix.initCells(list.size());
        this.initCell(matrix, new int[]{this.sql_statements, this.subprg_body}, 0);
        if (this.visual != null) {
            long l2 = System.nanoTime();
            long[] lArray = this.visual.visited[0];
            lArray[0] = lArray[0] + (long)((int)(l2 - l));
        }
    }

    @Override
    protected boolean scan(Matrix matrix, List<LexerToken> list) {
        int n = matrix.lastY();
        if (list.size() <= n) {
            return false;
        }
        LexerToken lexerToken = list.get(n);
        Integer n2 = (Integer)this.symbolIndexes.get("'" + lexerToken.content.toUpperCase() + "'");
        this.LAsuspect = null;
        if (this.fifteenPctLAImpr && n + 1 < list.size()) {
            LexerToken lexerToken2 = list.get(n + 1);
            this.LAsuspect = (Integer)this.symbolIndexes.get("'" + lexerToken2.content.toUpperCase() + "'");
        }
        boolean bl = false;
        for (int i = this.allXs.length - 1; 0 <= i; --i) {
            int n3 = this.allXs[i];
            if (!this.scan(matrix, n, list, n3, n2)) continue;
            bl = true;
        }
        if (this.scan(matrix, n, list, n, n2)) {
            bl = true;
        }
        return bl;
    }

    private boolean scan(Matrix matrix, int n, List<LexerToken> list, int n2, Integer n3) {
        long l = 0L;
        if (this.visual != null) {
            l = System.nanoTime();
        }
        long[] lArray = null;
        Cell cell = matrix.get(n2, n);
        if (cell == null) {
            return false;
        }
        for (int i = 0; i < cell.size(); ++i) {
            int n4 = cell.getPosition(i);
            int n5 = cell.getRule(i);
            Earley.Tuple tuple = this.rules[n5];
            if (tuple.size() - 1 < n4 || !this.isScannedSymbol(n, list, n4, tuple, n3) || !this.lookaheadOK(tuple, n4 + 1)) continue;
            lArray = Array.insert(lArray, this.makeMatrixCellElem(n5, n4 + 1, tuple));
        }
        if (lArray == null) {
            return false;
        }
        matrix.put(n2, n + 1, new Earley.EarleyCell(lArray));
        this.allXs = Array.insert(this.allXs, n2);
        if (this.visual != null) {
            long l2 = System.nanoTime();
            long[] lArray2 = this.visual.visited[n2];
            int n6 = n + 1;
            lArray2[n6] = lArray2[n6] + (long)((int)(l2 - l));
        }
        return true;
    }

    @Override
    protected boolean lookaheadOK(Earley.Tuple tuple, int n) {
        if (n > tuple.size() - 1) {
            return true;
        }
        int n2 = tuple.content(n);
        return this.LAsuspect == null || !this.isTerminal(n2) || n2 == this.LAsuspect;
    }

    @Override
    protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
        if (n2 != this.identifier) {
            return false;
        }
        if (n3 != null && this.keywords.contains(n3)) {
            return false;
        }
        LexerToken lexerToken = list.get(n);
        if (lexerToken.type == Token.DQUOTED_STRING) {
            return true;
        }
        if (lexerToken.type != Token.IDENTIFIER) {
            return false;
        }
        if (n3 == null) {
            return true;
        }
        LexerToken lexerToken2 = null;
        if (0 < n) {
            lexerToken2 = list.get(n - 1);
        }
        return lexerToken2 != null && !"YEAR".equalsIgnoreCase(lexerToken2.content) && !"HOUR".equalsIgnoreCase(lexerToken2.content) && !"MINUTE".equalsIgnoreCase(lexerToken2.content) || !"TO".equalsIgnoreCase(lexerToken.content);
    }

    @Override
    protected boolean notConfusedAsId(int n, int n2, int n3) {
        return !(n == this.begin && (n2 == this.dotted_name || n2 == this.decl_id) && n3 == 0 || n == this.start && n2 == this.table_reference && n3 == 1 || n == this.distinct && n2 == this.multiset_except && n3 == 3 || n == this.body && n2 == this.pkg_spec && n3 == 1);
    }

    @Override
    public synchronized void parse(List<LexerToken> list, Matrix matrix) {
        super.parse(list, matrix);
    }

    public int recognize(List<LexerToken> list) {
        Matrix matrix = new Matrix(SqlEarley.getInstance());
        this.parse(list, matrix);
        for (int i = list.size(); 0 < i; --i) {
            Cell cell = matrix.get(0, i);
            if (cell == null) continue;
            return i;
        }
        throw new AssertionError((Object)"all empty cells?");
    }

    void initKeywords() {
        this.keywords.add(this.getSymbol("'SELECT'"));
        this.keywords.add(this.getSymbol("'FROM'"));
        this.keywords.add(this.getSymbol("'WHERE'"));
        this.keywords.add(this.getSymbol("'AND'"));
        this.keywords.add(this.getSymbol("'OR'"));
        this.keywords.add(this.getSymbol("'NOT'"));
        this.keywords.add(this.getSymbol("'DISTINCT'"));
        this.keywords.add(this.getSymbol("'UNION'"));
        this.keywords.add(this.getSymbol("'ALL'"));
        this.keywords.add(this.getSymbol("'INNER'"));
        this.keywords.add(this.getSymbol("'LEFT'"));
        this.keywords.add(this.getSymbol("'NATURAL'"));
        this.keywords.add(this.getSymbol("'FULL'"));
        this.keywords.add(this.getSymbol("'OUTER'"));
        this.keywords.add(this.getSymbol("'JOIN'"));
        this.keywords.add(this.getSymbol("'ON'"));
        this.keywords.add(this.getSymbol("'INSERT'"));
        this.keywords.add(this.getSymbol("'UPDATE'"));
        this.keywords.add(this.getSymbol("'CREATE'"));
        this.keywords.add(this.getSymbol("'ALTER'"));
        this.keywords.add(this.getSymbol("'TABLE'"));
        this.keywords.add(this.getSymbol("'TABLESPACE'"));
        this.keywords.add(this.getSymbol("'VALUES'"));
        this.keywords.add(this.getSymbol("'NUMBER'"));
        this.keywords.add(this.getSymbol("'VARCHAR2'"));
        this.keywords.add(this.getSymbol("'DATE'"));
        this.keywords.add(this.getSymbol("'INTEGER'"));
        this.keywords.add(this.getSymbol("'MULTISET'"));
        this.keywords.add(this.getSymbol("'CASE'"));
        this.keywords.add(this.getSymbol("'WHEN'"));
    }

    @Override
    public ParseNode parse(List<LexerToken> list) {
        Matrix matrix = new Matrix(this);
        this.parse(list, matrix);
        return this.forest(list, matrix);
    }

    static {
        try {
            origRules = UnifiedRules.getRules();
            origRules.remove(new RuleTuple("identifier", new String[]{"idq"}));
            origRules.remove(new RuleTuple("identifier", new String[]{"id"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

