/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.util.Messages;
import oracle.dbtools.util.Service;

public class SyntaxError
extends AssertionError {
    public int line;
    public int offset;
    public int end;
    public String code;
    public String marker;
    private long[] suggestions;
    private Earley earley;
    static final String TITLE = Messages.getString("SyntaxError_Title");
    static final String MESSAGE_KEY = "SyntaxError_Message";
    static final String DETAILED_MESSAGE_KEY = "SyntaxError_DetailedMessage";

    public static SyntaxError checkSQLQuerySyntax(String string) {
        return SyntaxError.checkSyntax(string, new String[]{"subquery", "select", "sql_statement"});
    }

    public static SyntaxError checkSQLStatementSyntax(String string) {
        return SyntaxError.checkSyntax(string, new String[]{"sql_statements"});
    }

    public String[] getSuggestions() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Long l : this.topNsuggestions()) {
            String string = this.earley.allSymbols[Service.lX(l)];
            if (linkedList.contains(string) || 0 < string.indexOf(91)) continue;
            linkedList.add(string);
        }
        return linkedList.toArray(new String[0]);
    }

    public static SyntaxError checkSyntax(String string, String[] stringArray) {
        List<LexerToken> list = LexerToken.parse(string);
        SqlEarley sqlEarley = SqlEarley.partialRecognizer();
        Matrix matrix = new Matrix(sqlEarley);
        ((Earley)sqlEarley).parse(list, matrix);
        return SyntaxError.checkSyntax(string, stringArray, list, sqlEarley, matrix);
    }

    public static SyntaxError checkSyntax(String string, String[] stringArray, List<LexerToken> list, Earley earley, Matrix matrix) {
        Object object;
        int n;
        Cell cell = matrix.get(0, list.size());
        if (cell != null) {
            for (String string2 : stringArray) {
                for (n = 0; n < cell.size(); ++n) {
                    Earley.Tuple tuple = earley.rules[cell.getRule(n)];
                    String string3 = earley.allSymbols[tuple.head];
                    if (!string3.equals(string2)) continue;
                    return null;
                }
            }
        }
        int n2 = matrix.lastY();
        int n3 = 0;
        if (0 < n2) {
            n3 = list.get((int)(n2 - 1)).end;
        }
        int n4 = 0;
        int n5 = 0;
        n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\n') continue;
            if (i < n3) {
                ++n4;
                n5 = i;
                continue;
            }
            n = i;
            break;
        }
        String string4 = string.substring(n5, n);
        int n6 = n3 - n5;
        TreeSet<Long> treeSet = new TreeSet<Long>();
        for (int i = 0; i <= n2; ++i) {
            object = matrix.get(i, n2);
            if (object == null) continue;
            for (int j = 0; j < object.size(); ++j) {
                String string5;
                int n7 = object.getRule(j);
                int n8 = object.getPosition(j);
                if (n8 >= earley.rules[n7].rhs.length || (string5 = earley.allSymbols[earley.rules[n7].rhs[n8]]).startsWith("xml")) continue;
                treeSet.add(Service.lPair(earley.rules[n7].rhs[n8], earley.rules[n7].head));
            }
        }
        LexerToken lexerToken = null;
        if (n2 < list.size()) {
            lexerToken = list.get(n2);
        } else if (n2 == list.size()) {
            lexerToken = list.get(n2 - 1);
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            long l = (Long)object.next();
            String string6 = earley.allSymbols[Service.lX(l)];
            if (!SyntaxError.isTypo(string6, lexerToken)) continue;
            return new SyntaxError(n4, n6, lexerToken.begin, string4, Service.identln(n6, "^^^"), new long[]{l}, earley);
        }
        return new SyntaxError(n4, n6, n3, string4, Service.identln(n6, "^^^"), SyntaxError.order(treeSet, earley), earley);
    }

    private static long[] order(Set<Long> set, Earley earley) {
        long[] lArray = new long[set.size()];
        int n = 0;
        for (long l : set) {
            lArray[n++] = l;
        }
        return lArray;
    }

    private static boolean isTypo(String string, LexerToken lexerToken) {
        if (lexerToken == null || lexerToken.begin + 1 == lexerToken.end || lexerToken.begin + 2 == lexerToken.end) {
            return false;
        }
        String string2 = "'" + lexerToken.content.toUpperCase() + "'";
        if (string.length() + 1 == string2.length() || string.length() == string2.length() + 1 || string.length() == string2.length()) {
            int n;
            int n2 = 0;
            int n3 = -1;
            for (n = 0; n < string.length() && n < string2.length(); ++n) {
                if (string.charAt(n) == string2.charAt(n)) {
                    ++n2;
                    continue;
                }
                n3 = n;
                break;
            }
            if (n3 + 1 < string.length() && n3 + 1 < string2.length() && string.charAt(n3 + 1) == string2.charAt(n3 + 1)) {
                for (n = n3 + 1; n < string.length() && n < string2.length() && string.charAt(n) == string2.charAt(n); ++n) {
                    ++n2;
                }
            } else if (n3 + 1 < string.length() && string.charAt(n3 + 1) == string2.charAt(n3)) {
                for (n = n3; n + 1 < string.length() && n < string2.length() && string.charAt(n + 1) == string2.charAt(n); ++n) {
                    ++n2;
                }
            } else if (n3 + 1 < string2.length() && string.charAt(n3) == string2.charAt(n3 + 1)) {
                for (n = n3; n < string.length() && n + 1 < string2.length() && string.charAt(n) == string2.charAt(n + 1); ++n) {
                    ++n2;
                }
            }
            if (n2 == string.length() - 1 || n2 == string2.length() - 1) {
                return true;
            }
        }
        return false;
    }

    private SyntaxError(int n, int n2, int n3, String string, String string2, long[] lArray, Earley earley) {
        this.line = n;
        this.offset = n2;
        this.end = n3;
        this.code = string;
        this.marker = string2;
        this.suggestions = lArray;
        this.earley = earley;
    }

    public String toString() {
        return this.getDetailedMessage();
    }

    public String getDetailedMessage() {
        String string = Service.padln(this.marker, this.code.length());
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<String> linkedList = new LinkedList<String>();
        Object object = this.topNsuggestions().iterator();
        while (object.hasNext()) {
            long l = object.next();
            String string2 = this.earley.allSymbols[Service.lX(l)];
            if (linkedList.contains(string2) || 0 < string2.indexOf(91)) continue;
            linkedList.add(string2);
            stringBuilder.append(string2 + ',');
        }
        object = stringBuilder.toString();
        if (60 < ((String)object).length()) {
            object = ((String)object).substring(0, 50);
        }
        return Messages.format(DETAILED_MESSAGE_KEY, this.line, this.offset, object, this.code, string);
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        SqlEarley sqlEarley = SqlEarley.getInstance();
        LinkedList<String> linkedList = new LinkedList<String>();
        Object object = this.topNsuggestions().iterator();
        while (object.hasNext()) {
            long l = object.next();
            String string = sqlEarley.allSymbols[Service.lX(l)];
            if (linkedList.contains(string) || 0 < string.indexOf(91)) continue;
            linkedList.add(string);
            stringBuilder.append(string + ',');
        }
        object = stringBuilder.toString();
        if (60 < ((String)object).length()) {
            object = ((String)object).substring(0, 50);
        }
        return Messages.format(MESSAGE_KEY, this.line, this.offset, object);
    }

    public String getTitle() {
        return TITLE;
    }

    public List<Long> topNsuggestions() {
        TreeMap<Long, Integer> treeMap = new TreeMap<Long, Integer>();
        for (long l : this.suggestions) {
            long l2 = -1L;
            int n = Integer.MAX_VALUE;
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                long l3 = (Long)iterator.next();
                int n2 = (Integer)treeMap.get(l3);
                if (n2 >= n) continue;
                l2 = l3;
                n = n2;
            }
            long l4 = l;
            Integer n3 = HarvestDoc.getFrequencies().get(l);
            if (n3 == null) {
                n3 = 0;
            }
            if (treeMap.size() == 5) {
                if (n3 == null || n >= n3) continue;
                treeMap.remove(l2);
                treeMap.put(l4, n3);
                continue;
            }
            treeMap.put(l4, n3);
        }
        Object object = new ArrayList();
        for (Map.Entry entry : treeMap.entrySet()) {
            object.add(entry);
        }
        Collections.sort(object, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry entry, Map.Entry entry2) {
                return ((Integer)entry2.getValue()).compareTo((Integer)entry.getValue());
            }
        });
        LinkedList linkedList = new LinkedList();
        int n = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (5 < n) break;
            linkedList.add(entry.getKey());
            ++n;
        }
        return linkedList;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "SELECT count(d.department_id) FRO departments d";
        SyntaxError syntaxError = SyntaxError.checkSQLStatementSyntax(string);
        if (syntaxError != null) {
            System.out.println(syntaxError.getDetailedMessage());
        }
    }
}

