/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql.doc;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.util.Service;

public class Substr
implements Serializable {
    static final long serialVersionUID = 3L;
    final int from;
    final int to;
    final String src;
    final DocURL doc;
    final long weight;

    public Substr(int n, int n2, String string, long l, DocURL docURL) {
        this.from = n;
        this.to = n2;
        this.src = string;
        this.weight = l;
        this.doc = docURL;
    }

    public DocURL getDoc() {
        return this.doc;
    }

    public boolean le(Substr substr) {
        if (this.weight != substr.weight) {
            return this.weight > substr.weight;
        }
        return this.to - this.from < substr.to - substr.from;
    }

    public String cutSrc() {
        return this.src.substring(this.from, this.to);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Substr)) {
            return false;
        }
        Substr substr = (Substr)object;
        return this.cutSrc().equals(substr.cutSrc());
    }

    public int hashCode() {
        return this.cutSrc().hashCode();
    }

    public String toString() {
        return this.cutSrc();
    }

    static void add(Set<Substr> set, Substr substr) {
        String string = substr.cutSrc();
        List<LexerToken> list = LexerToken.parse(string);
        Substr substr2 = null;
        for (Substr substr3 : set) {
            int n;
            String string2 = substr3.cutSrc();
            List<LexerToken> list2 = LexerToken.parse(string2);
            int n2 = -1;
            int n3 = list.size();
            int n4 = list2.size();
            int n5 = n = substr.weight == 0L ? 8 : 20;
            if (n3 == n4 || n3 == n4 + 1 && list.get((int)(n3 - 1)).content.equals(";") || n4 == n3 + 1 && list2.get((int)(n4 - 1)).content.equals(";") || n3 > n && n4 > n) {
                substr2 = substr3;
                for (LexerToken lexerToken : list2) {
                    boolean bl;
                    if (++n2 >= n || n3 <= n2) break;
                    Token token = list.get((int)n2).type;
                    String string3 = list.get((int)n2).content;
                    boolean bl2 = bl = !string3.equals(lexerToken.content);
                    if (substr.weight == -1L) {
                        bl = n2 == 0 ? (bl = !string3.equalsIgnoreCase(lexerToken.content)) : token != lexerToken.type;
                    } else if (substr.weight == 0L) {
                        bl = token != lexerToken.type;
                    } else if (token == Token.IDENTIFIER) {
                        boolean bl3 = bl = !string3.equalsIgnoreCase(lexerToken.content);
                    }
                    if (!bl) continue;
                    substr2 = null;
                    break;
                }
            }
            if (substr2 == null) continue;
            break;
        }
        if (substr2 == null) {
            set.add(substr);
        } else if (substr.le(substr2)) {
            set.remove(substr2);
            set.add(substr);
        }
    }

    static void generateTemplate(ParseNode parseNode, List<LexerToken> list, String string, Map<Long, Set<Substr>> map, long l, DocURL.Manual manual, String string2) {
        for (ParseNode parseNode2 : parseNode.descendants()) {
            if (parseNode2.to - parseNode2.from < 3 || parseNode2.to - parseNode2.from == 3 && ".".equals(list.get((int)(parseNode2.from + 1)).content)) continue;
            for (int n : parseNode2.content()) {
                String string3 = SqlEarley.getInstance().allSymbols[n];
                if (string3.charAt(0) == '\'' || string3.contains("[") || string3.equals("iteration_scheme") || string3.equals("select_clause") || string3.equals("DECLARE_decls_opt") || string3.equals("subprg_spec")) continue;
                ParseNode parseNode3 = parseNode.parent(parseNode2.from, parseNode2.to);
                if (parseNode3 != null) {
                    for (int n2 : parseNode3.content()) {
                        long l2 = Service.lPair(n, n2);
                        Set<Substr> set = map.get(l2);
                        if (set == null) {
                            set = new HashSet<Substr>();
                            map.put(l2, set);
                        }
                        DocURL docURL = null;
                        if (manual != null) {
                            docURL = new DocURL(manual, string2);
                        }
                        if (string3.equals("aggregate_function")) {
                            l = -1L;
                        }
                        Substr.add(set, new Substr(list.get((int)parseNode2.from).begin, list.get((int)(parseNode2.to - 1)).end, string.intern(), l, docURL));
                    }
                    continue;
                }
                long l3 = Service.lPair(n, 0);
                Set<Substr> set = map.get(l3);
                if (set == null) {
                    set = new HashSet<Substr>();
                    map.put(l3, set);
                }
                DocURL docURL = null;
                if (manual != null) {
                    docURL = new DocURL(manual, string2);
                }
                if (string3.equals("aggregate_function")) {
                    l = -1L;
                }
                Substr.add(set, new Substr(list.get((int)parseNode2.from).begin, list.get((int)(parseNode2.to - 1)).end, string.intern(), l, docURL));
            }
        }
    }

    public static void listSuggestions(Set<Long> set, String string, String string2, Map<Long, Set<Substr>> map, Set<Substr> set2, int n) {
        for (Long l : set) {
            Set<Substr> set3 = map.get(l);
            if (set3 == null) continue;
            for (Substr substr : set3) {
                List<LexerToken> list;
                String string3 = substr.cutSrc().toLowerCase();
                Substr substr2 = substr;
                if (!string3.startsWith(string.toLowerCase())) continue;
                if (string2 != null) {
                    list = LexerToken.parse(string3);
                    if (list.size() < 2 || !list.get((int)1).content.startsWith(string2)) continue;
                    substr2 = new Substr(substr.from + ((LexerToken)list.get((int)1)).begin, substr.to, substr.src, substr.weight, substr.doc);
                }
                list = null;
                for (Substr substr3 : set2) {
                    if (list != null && !((Substr)((Object)list)).le(substr3)) continue;
                    list = substr3;
                }
                if (set2.size() >= n && !substr2.le((Substr)((Object)list))) continue;
                Substr.add(set2, substr2);
                if (n >= set2.size()) continue;
                set2.remove(list);
            }
        }
    }

    public static void main(String[] stringArray) {
        Map<Long, Set<Substr>> map = HarvestDoc.getTemplates();
    }
}

