/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.olap.actions.DropMeasureHelper;
import oracle.olap.actions.DropOLAPChildObjectDialog;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cube.model.Cube;
import oracle.olap.db.CubeCalcPersist;
import oracle.olap.db.CubeCalcPersistSQL;

public abstract class AbstractDropMeasureAction
extends AbstractMenuAction {
    private AnalyticWorkspace aw = null;
    private oracle.olap.app.olapmetadata.Cube appCube = null;
    private CubeCalcPersist calcPersist = null;
    private String measureName;
    private String cubeName;
    private DropOLAPChildObjectDialog dropDialog = null;
    protected static final String CALC_MEASURE = "DERIVED";
    protected static final String BASE_MEASURE = "BASE";
    private static final String HELP_ID = "olap_drop_object";

    protected abstract String getCubeName();

    protected abstract String getMeasureName();

    protected abstract String getTitle(String var1);

    protected abstract String getProgressMessage();

    public abstract String getDropMeasureLabel(String var1);

    public abstract String getDropMeasureConfirmation(String var1);

    public abstract String getType();

    public abstract JPanel getDropMeasurePanel(String var1, List<Measure> var2, AnalyticWorkspace var3);

    public void launch() {
        Node node = this.getDBObject().getNode();
        URL uRL = node.getURL();
        final String string = DBURLFormatHelper.getSchema((URL)uRL);
        Connection connection = this.getDBObject().getConnection();
        final DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(connection);
        String string2 = this.getProgressMessage();
        RaptorTask raptorTask = new RaptorTask(string2, true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                AbstractDropMeasureAction.this.measureName = AbstractDropMeasureAction.this.getMeasureName();
                AbstractDropMeasureAction.this.cubeName = AbstractDropMeasureAction.this.getCubeName();
                try {
                    Schema schema = OLAPMetadataCache.getUpdatedSchema(AbstractDropMeasureAction.this.getDBObject().getConnectionName(), string);
                    String string2 = AbstractDropMeasureAction.this.findAwName(databaseImpl, AbstractDropMeasureAction.this.cubeName, schema.getName());
                    AbstractDropMeasureAction.this.aw = new AnalyticWorkspace(string, string2);
                    AbstractDropMeasureAction.this.aw.setCubes(schema.getCubes());
                    AbstractDropMeasureAction.this.appCube = new oracle.olap.app.olapmetadata.Cube(new Schema(string), AbstractDropMeasureAction.this.aw.getName(), AbstractDropMeasureAction.this.cubeName, AbstractDropMeasureAction.this.aw.getCube(AbstractDropMeasureAction.this.cubeName).getDescription(), "", false);
                    AbstractDropMeasureAction.this.calcPersist = new CubeCalcPersistSQL(databaseImpl, AbstractDropMeasureAction.this.appCube, new Cube());
                    DropMeasureHelper dropMeasureHelper = new DropMeasureHelper(AbstractDropMeasureAction.this.getTitle(AbstractDropMeasureAction.this.measureName), AbstractDropMeasureAction.this.aw, AbstractDropMeasureAction.this.measureName, AbstractDropMeasureAction.this.cubeName, string, AbstractDropMeasureAction.this.getDBObject().getConnection(), AbstractDropMeasureAction.this.calcPersist, AbstractDropMeasureAction.this, false, null);
                    JPanel jPanel = AbstractDropMeasureAction.this.getDropMeasurePanel(AbstractDropMeasureAction.this.measureName, (List)dropMeasureHelper.getDependencies(), AbstractDropMeasureAction.this.aw);
                    AbstractDropMeasureAction.this.dropDialog = new DropOLAPChildObjectDialog((Frame)Ide.getMainWindow(), dropMeasureHelper.getTitle(), jPanel, dropMeasureHelper, AbstractDropMeasureAction.HELP_ID);
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                    throw new TaskException((Throwable)exception);
                }
                return bl;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string2);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        Logger.getLogger(this.getClass().getName()).severe(throwable.toString());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        AbstractDropMeasureAction.this.dropDialog.setModal(true);
                        AbstractDropMeasureAction.this.dropDialog.setVisible(true);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
    }

    private String findAwName(Database database, String string, String string2) throws SQLException, IOException {
        String string3 = "";
        String string4 = "select aw_name from all_cubes where owner = ? and cube_name = ?";
        List<List<String>> list = database.executeSQL(string4, new Object[]{string2, string});
        for (List<String> list2 : list) {
            Iterator<String> iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string5;
                string3 = string5 = iterator.next();
            }
        }
        return string3;
    }
}

