/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Dimension;
import java.sql.Connection;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.actions.ViewDataAction;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.data.DimensionDataViewer;
import oracle.olap.hierarchyviewer.DimensionDataViewerDialog;
import oracle.olap.hierarchyviewer.DimensionMetadataContextImpl;
import oracle.olap.syntaxbuilder.qdr.DimensionMemberPanel;

public class DimensionViewDataAction
extends ViewDataAction {
    private DimensionDataViewer dvdlg = null;

    @Override
    public void showData(DBObject dBObject) throws Exception {
        this.showDimensionViewerDialog(dBObject);
    }

    private void showDimensionViewerDialog(DBObject dBObject) throws Exception {
        Connection connection = dBObject.getConnection();
        final String string = dBObject.getConnectionName();
        final String string2 = dBObject.getSchemaName();
        String string3 = dBObject.getObjectName();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        if (oracleDatabaseImpl != null) {
            final Connection connection2 = connection;
            final String string4 = string3;
            String string5 = OLAPArb.get("MODELER.BIBEANS.INITIALIZING.BUZY.BAR.TITLE");
            RaptorTask raptorTask = new RaptorTask(string5, true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    try {
                        this.setMessage(OLAPArb.get("DIMENSION_DATA_VIEWER_READ_METADATA_MSG"));
                        Schema schema = OLAPMetadataCache.getUpdatedSchema(string, string2);
                        DimensionMetadataContextImpl dimensionMetadataContextImpl = new DimensionMetadataContextImpl(schema.findDimension(string4));
                        this.setMessage(OLAPArb.get("DIMENSION_DATA_VIEWER_QUERYING_DATA_MSG"));
                        DimensionViewDataAction.this.dvdlg = new DimensionDataViewerDialog((JFrame)Ide.getMainWindow(), connection2, dimensionMetadataContextImpl, null);
                    }
                    catch (Exception exception) {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    return bl;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            DimensionViewDataAction.this.warn(throwable);
                            DimensionViewDataAction.this.showErrorDialog(throwable);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (DimensionViewDataAction.this.dvdlg != null) {
                                DimensionViewDataAction.this.dvdlg.show();
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        }
    }

    private void showEBMemberDataViewer(DBObject dBObject) throws Exception {
        Connection connection = dBObject.getConnection();
        String string = dBObject.getObjectName();
        DimensionMemberPanel dimensionMemberPanel = new DimensionMemberPanel(dBObject.getSchemaName(), string, connection);
        dimensionMemberPanel.setSize(300, 300);
        dimensionMemberPanel.setPreferredSize(new Dimension(300, 300));
        UIUtils.showPanelAsDialog((JPanel)dimensionMemberPanel, (String)OLAPArb.get("DIMENSION_MEMBER_SELECTOR_TITLE"), null, (int)1);
    }

    private void showBIBeansDataViewer(DBObject dBObject) throws Exception {
    }
}

