/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.olap.actions.AbstractOLAPDDLAction;
import oracle.olap.actions.DropCascadeAction;
import oracle.olap.actions.DropCascadeConfirmDialog;
import oracle.olap.actions.OLAPObjectHelper;
import oracle.olap.actions.model.CascadeDeleteDimensionWrapper;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubePartition;
import oracle.olap.cube.model.DependentTransactionalCubes;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.MetadataXML;
import oracle.olap.cubexml.MultipleObjectDDL;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.util.UIUtilities;

public abstract class DropCascadeChildDimensionAction
extends AbstractOLAPDDLAction
implements DropCascadeAction {
    protected List<Cube> allCubes = new ArrayList<Cube>();
    protected List<String> allCubesWithDimension = new ArrayList<String>();
    protected List<String> primaryPartitionCubeList = new ArrayList<String>();
    protected List<String> secondaryPartitionCubeList = new ArrayList<String>();
    protected String dimensionName;
    protected int deleteOperationChoice = -1;
    protected int cascadeDeleteChoice = -1;
    protected boolean isDimElementReferenced = false;
    private List<SystemObject> originalCubeList;
    private List<SystemObject> updatedCubeList;
    private CascadeDeleteDimensionWrapper cascadeDeleteDimensionWrapper;

    @Override
    public void launch() {
        this.init();
    }

    protected void init() {
        RaptorTask raptorTask = new RaptorTask(this.getCascadeDropWaitMessage(), true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                try {
                    DropCascadeChildDimensionAction.this.loadMetadata();
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                    throw new TaskException((Throwable)exception);
                }
                return bl;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(this.getCascadeDropWaitMessage());
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        DropCascadeChildDimensionAction.this.showErrorDialog(throwable);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        String string = DropCascadeChildDimensionAction.this.getDBObject().getObjectName();
                        String string2 = DropCascadeChildDimensionAction.this.getCascadeDropDialogTitle(string);
                        DropCascadeChildDimensionAction dropCascadeChildDimensionAction = DropCascadeChildDimensionAction.this;
                        String string3 = null;
                        try {
                            string3 = DropCascadeChildDimensionAction.this.getDropDDLStatement();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        DropCascadeConfirmDialog dropCascadeConfirmDialog = new DropCascadeConfirmDialog(dropCascadeChildDimensionAction, DropCascadeChildDimensionAction.this.cascadeDeleteDimensionWrapper, string, string2, true, string3);
                        Rectangle rectangle = UIUtilities.centerWindow((Component)Ide.getMainWindow(), 600, 400);
                        dropCascadeConfirmDialog.setBounds(rectangle);
                        dropCascadeConfirmDialog.setVisible(true);
                        if (DropCascadeChildDimensionAction.this.deleteOperationChoice == 0) {
                            DropCascadeChildDimensionAction.this.doDrop();
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
    }

    protected void doDrop() {
        try {
            String string;
            DBObject dBObject = this.getDBObject();
            final String string2 = string = dBObject.getObjectName();
            String string3 = this.getProgressMessage(string);
            RaptorTask raptorTask = new RaptorTask(string3, true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    try {
                        DropCascadeChildDimensionAction.this.executeOLAPDDLStatements();
                    }
                    catch (Exception exception) {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    return bl;
                }
            };
            ObjectAction objectAction = this.getObjectAction();
            if (null == objectAction) {
                objectAction = new ObjectAction();
                objectAction.setReloadParent(true);
            }
            objectAction.setRemoveFromParent(true);
            ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
            IRaptorTaskListener iRaptorTaskListener = ObjectActionController.getRaptorTaskListener((ObjectActionController.ObjectActionPostProcess)objectActionPostProcess);
            raptorTask.getDescriptor().addListener(iRaptorTaskListener);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            DropCascadeChildDimensionAction.this.showErrorDialog(throwable);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            String string = DropCascadeChildDimensionAction.this.getSuccessMessage(string2);
                            if (string != null) {
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.setMessage(string3);
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
            this.setBlockOACRefresh(true);
        }
        catch (Exception exception) {
            this.showErrorDialog(exception);
        }
    }

    protected void loadMetadata() {
        CubeDimension cubeDimension = OLAPObjectHelper.loadDimension(this.getDBObject());
        this.dimensionName = cubeDimension.getName();
        this.setSchemaObjectWithDescription(cubeDimension);
    }

    @Override
    public void setUserDeleteChoice(int n) {
        this.deleteOperationChoice = n;
    }

    public void setCascadeDeleteChoice(int n) {
        this.cascadeDeleteChoice = n;
    }

    public String getDropDDLStatement() throws Exception {
        DBObject dBObject = this.getDBObject();
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(dBObject.getConnection());
        Schema schema = new Schema(dBObject.getSchemaName());
        List<MultipleObjectDDL> list = this.getMultipleDDLStatements();
        MetadataContext metadataContext = new MetadataContext(this.getDBObject().getDatabase(), list);
        metadataContext.setSchema(schema);
        metadataContext.setDatabase(databaseImpl);
        MetadataXML metadataXML = new MetadataXML(metadataContext);
        ArrayList<String> arrayList = new ArrayList<String>();
        metadataXML.parse(arrayList);
        return metadataXML.getSQLXML();
    }

    private List<MultipleObjectDDL> getMultipleDDLStatements() throws Exception {
        List<MultipleObjectDDL> list;
        DBObject dBObject = this.getDBObject();
        Collection<String> collection = this.getOLAPDDL(dBObject);
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = this.getSchemaObjectWithDescription();
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc2 = this.getSchemaUpdatedObjectWithDescription();
        if (abstractSchemaObjectWithDesc2 == null) {
            abstractSchemaObjectWithDesc2 = abstractSchemaObjectWithDesc;
        }
        ArrayList<MultipleObjectDDL> arrayList = new ArrayList<MultipleObjectDDL>();
        MultipleObjectDDL multipleObjectDDL = new MultipleObjectDDL((SystemObject)abstractSchemaObjectWithDesc, (SystemObject)abstractSchemaObjectWithDesc2, collection);
        arrayList.add(multipleObjectDDL);
        DependentTransactionalCubes dependentTransactionalCubes = DependentTransactionalCubes.getInstance();
        if (this.cascadeDeleteDimensionWrapper == null) {
            this.cascadeDeleteDimensionWrapper = this.handleDimensionChildDelete(dBObject.getObjectName());
        }
        if ((list = dependentTransactionalCubes.getCubeDDLStatements((SystemObject)abstractSchemaObjectWithDesc, (SystemObject)abstractSchemaObjectWithDesc2)).size() > 0) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    protected void executeOLAPDDLStatements() throws Exception {
        Difference difference;
        SystemObject[] systemObjectArray;
        SystemObject[] systemObjectArray2;
        AbstractDatabase abstractDatabase;
        DBObject dBObject = this.getDBObject();
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(dBObject.getConnection());
        Schema schema = new Schema(dBObject.getSchemaName());
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = this.getSchemaObjectWithDescription();
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc2 = this.getSchemaUpdatedObjectWithDescription();
        if (abstractSchemaObjectWithDesc2 == null) {
            abstractSchemaObjectWithDesc2 = abstractSchemaObjectWithDesc;
        }
        List<MultipleObjectDDL> list = this.getMultipleDDLStatements();
        MetadataContext metadataContext = new MetadataContext(this.getDBObject().getDatabase(), list);
        metadataContext.setSchema(schema);
        metadataContext.setDatabase(databaseImpl);
        MetadataXML metadataXML = new MetadataXML(metadataContext);
        ArrayList<String> arrayList = new ArrayList<String>();
        metadataXML.parse(arrayList);
        metadataXML.executeSQL();
        Database database = dBObject.getDatabase();
        if (database instanceof AbstractDatabase) {
            abstractDatabase = (AbstractDatabase)database;
            systemObjectArray2 = new SystemObject[]{abstractSchemaObjectWithDesc};
            systemObjectArray = new SystemObject[]{abstractSchemaObjectWithDesc2};
            difference = abstractDatabase.getDiffEngine().difference((Object)systemObjectArray2, (Object)systemObjectArray);
            abstractDatabase.finishUpdates(difference);
        }
        if (this.allCubes.size() > 0 && database instanceof AbstractDatabase) {
            abstractDatabase = (AbstractDatabase)database;
            systemObjectArray2 = this.originalCubeList.toArray(new SystemObject[0]);
            systemObjectArray = this.updatedCubeList.toArray(new SystemObject[0]);
            difference = abstractDatabase.getDiffEngine().difference((Object)systemObjectArray2, (Object)systemObjectArray);
            abstractDatabase.finishUpdates(difference);
        }
    }

    protected abstract int getChildDimensionObjectType();

    protected abstract CascadeDeleteDimensionWrapper handleDimensionChildDelete(String var1);

    protected abstract String getPartitionMetadataName(CubePartition var1);

    protected abstract void removeDimensionalityMap(Cube var1, String var2);

    protected abstract String getCascadeDropWaitMessage();

    protected abstract String getCascadeDropWarning1Message(String var1, String var2);

    protected abstract String getCascadeDropWarning2Message(String var1, String var2);

    protected abstract String getCascadeDropWarning3Message(String var1);

    protected abstract String getCascadeDropDialogTitle(String var1);

    protected abstract String getCascadeDropConfirmMessage();
}

