/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.olap.OLAPArb;
import oracle.olap.actions.DropOLAPChildObjectHelper;
import oracle.olap.actions.OLAPActionDDLPanel;

public class DropOLAPChildObjectDialog
extends JDialog {
    private OLAPActionDDLPanel sqlPanel;
    private DropOLAPChildObjectHelper helper;
    private JTabbedPane tabs;
    private JComponent confirmPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private int selection;
    public static final int YES_SELECTION = 1;
    public static final int NO_SELECTION = 0;
    private static final int SQL_TAB = 1;
    private String helpId;
    private final String CANCEL_COMMAND = "CANCEL_ID";

    public DropOLAPChildObjectDialog(Frame frame, String string, JComponent jComponent, DropOLAPChildObjectHelper dropOLAPChildObjectHelper, String string2) {
        super(frame, string);
        this.helpId = string2;
        this.confirmPanel = jComponent;
        this.helper = dropOLAPChildObjectHelper;
        HelpSystem.getHelpSystem().registerTopic(this.confirmPanel, string2);
        this.initComponents();
        this.layoutComponents();
        this.setDefaultCloseOperation(2);
        Dimension dimension = new Dimension(600, 400);
        this.setMinimumSize(dimension);
        this.setLocationRelativeTo(frame);
        this.registerKeyboardActions();
    }

    private void initComponents() {
        this.okButton = new JButton(OLAPArb.getString("DROP_CASCADE_YES_CHOICE"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DropOLAPChildObjectDialog.this.selection = 1;
                if (DropOLAPChildObjectDialog.this.helper.commitChanges()) {
                    DropOLAPChildObjectDialog.this.close();
                }
            }
        });
        this.cancelButton = new JButton(OLAPArb.getString("DROP_CASCADE_NO_CHOICE"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DropOLAPChildObjectDialog.this.selection = 0;
                DropOLAPChildObjectDialog.this.close();
            }
        });
        this.helpButton = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpSystem.getHelpSystem().showHelp(DropOLAPChildObjectDialog.this.confirmPanel);
            }
        });
        if (!this.helper.isReadOnly()) {
            this.tabs = new JTabbedPane();
            this.tabs.add((Component)this.confirmPanel, OLAPArb.getString("DROP_DIALOG_CONFIRM_TAB_LABEL"));
            this.sqlPanel = new OLAPActionDDLPanel();
            this.tabs.add((Component)this.sqlPanel, OLAPArb.getString("DROP_DIALOG_DDL_TAB_LABEL"));
            this.tabs.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (DropOLAPChildObjectDialog.this.tabs.getSelectedIndex() == 1) {
                        DropOLAPChildObjectDialog.this.sqlPanel.setDDLText(DropOLAPChildObjectDialog.this.helper.getSQL());
                    }
                }
            });
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        if (!this.helper.isReadOnly()) {
            this.add((Component)this.tabs, new GridBagConstraints(0, n, 1, 1, 0.5, 0.5, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        } else {
            this.add((Component)this.confirmPanel, new GridBagConstraints(0, n, 1, 1, 0.5, 0.5, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        }
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this.add((Component)dialogButtonBar, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 5, 5));
    }

    private void setDialogLocation(Dimension dimension) {
        Point point = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Point point2 = new Point();
        point2.setLocation(point.getX() - dimension.getWidth() / 2.0, point.getY() - dimension.getHeight() / 2.0);
        this.setLocation(point2);
    }

    private void close() {
        this.dispose();
        this.setVisible(false);
    }

    public int getUserSelection() {
        return this.selection;
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DropOLAPChildObjectDialog.this.selection = 0;
                DropOLAPChildObjectDialog.this.close();
            }
        };
        jRootPane.registerKeyboardAction(actionListener, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
    }
}

