/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.Connection;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.dml.DMLObject;
import oracle.olap.eif.ImportFromEIFDialog;

public class ImportFromEIFAction
extends AbstractMenuAction {
    public void launch() {
        DBObject dBObject = this.getDBObject();
        this.launchDialog(dBObject);
    }

    private void launchDialog(DBObject dBObject) {
        Database database = dBObject.getDatabase();
        Connection connection = database.getConnection();
        String string = dBObject.getSchemaName();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        ImportFromEIFDialog importFromEIFDialog = new ImportFromEIFDialog((Frame)Ide.getMainWindow(), (DBObjectProvider)database, string);
        importFromEIFDialog.setMinimumSize(new Dimension(340, 265));
        importFromEIFDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        importFromEIFDialog.setVisible(true);
        if (importFromEIFDialog.isOKSelected()) {
            string2 = importFromEIFDialog.getAWName();
            string3 = importFromEIFDialog.getEIFFileName();
            string4 = importFromEIFDialog.getDirectoryName();
            string5 = importFromEIFDialog.getTableSpaceName();
        }
        if (string4 != null && string3 != null && string2 != null) {
            this.importFromEIFFile(connection, string, string5, string2, string4, string3);
        }
    }

    private void importFromEIFFile(Connection connection, String string, String string2, String string3, String string4, String string5) {
        String string6 = OLAPArb.get("EIF_IMPORT_PROGRESSBAR_TITLE");
        string6 = MessageFormat.format(string6, "");
        final String string7 = string;
        final String string8 = string3;
        final Connection connection2 = connection;
        final String string9 = string4;
        final String string10 = string5;
        final String string11 = string2;
        RaptorTask raptorTask = new RaptorTask(string6, true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                boolean bl2 = true;
                String string = string7 + "." + string8;
                try {
                    this.setMessage(OLAPArb.get("EIF_IMPORT_PROGRESSBAR_WAIT_MSG"));
                    DatabaseUtils.ExecuteSPL(connection2, "cda '" + string9 + "'");
                    if (string11 == null) {
                        DMLObject.runDML(connection2, "CREATE_AW", string);
                    } else {
                        DMLObject.runDML(connection2, "CREATE_AW_IN_TABLESPACE", string);
                    }
                    bl2 = true;
                    DMLObject.runDML(connection2, "IMPORT_AW_FROM_EIF_FILE", string9, string10, string);
                    DMLObject.runDML(connection2, "UPDATE_AW", string);
                    connection2.commit();
                    DMLObject.runDML(connection2, "DETACH_AW", string);
                }
                catch (Exception exception) {
                    if (bl2) {
                        try {
                            DMLObject.runDML(connection2, "DETACH_AW", string);
                            DMLObject.runDML(connection2, "DELETE_AW", string);
                            connection2.commit();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    bl = Boolean.FALSE;
                    throw new TaskException((Throwable)exception);
                }
                return bl;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        ImportFromEIFAction.this.warn(throwable);
                        ImportFromEIFAction.this.showErrorDialog(throwable);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
    }

    private void showErrorDialog(Throwable throwable) {
        String string = OLAPArb.get("EIF_IMPORT_ERROR_TITLE");
        ExceptionHandler.handleException((Throwable)throwable);
    }
}

