/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.actions.ViewDataAction;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.CalcReferences;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.cubeviewer.CubeDataViewerDialog;
import oracle.olap.data.CubeDataViewer;
import oracle.olap.data.CubeMetadataContextImpl;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.util.OLAPHelpProvider;

public class MeasureViewDataAction
extends ViewDataAction {
    private CubeDataViewer cubeDataViewerET;
    private Schema schema;

    @Override
    public void showData(DBObject dBObject) throws Exception {
        this.showMeasureData(dBObject);
    }

    private void showMeasureData(DBObject dBObject) throws Exception {
        Object object;
        Connection connection = dBObject.getConnection();
        String string = dBObject.getConnectionName();
        String string2 = dBObject.getSchemaName();
        String string3 = dBObject.getObjectName();
        String string4 = null;
        if (dBObject.getNode() instanceof ObjectNode) {
            object = (ObjectNode)dBObject.getNode();
            string4 = (String)object.getProperty("CUBE_NAME");
        } else if (dBObject.getNode() instanceof CalculatedMeasureNode) {
            object = (CalculatedMeasureNode)dBObject.getNode();
            string4 = (String)((CalculatedMeasureNode)object).getProperty("CUBE_NAME");
            string3 = (String)((CalculatedMeasureNode)object).getProperty("MEASURE_NAME");
        }
        object = (OracleDatabaseImpl)dBObject.getDatabase();
        if (object != null) {
            this.schema = OLAPMetadataCache.getUpdatedSchema(string, string2);
            String string5 = OLAPArb.get("MODELER.BIBEANS.INITIALIZING.BUZY.BAR.TITLE");
            String string6 = string3;
            String string7 = string4;
            Object object2 = object;
            RaptorTask raptorTask = new RaptorTask(string5, true, IRaptorTaskRunMode.MODAL, (OracleDatabaseImpl)object2, string7, string6){
                final /* synthetic */ OracleDatabaseImpl val$oraDb2;
                final /* synthetic */ String val$cubeName2;
                final /* synthetic */ String val$measureName2;
                {
                    this.val$oraDb2 = oracleDatabaseImpl;
                    this.val$cubeName2 = string2;
                    this.val$measureName2 = string3;
                    super(string, bl, iRaptorTaskRunMode);
                }

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    try {
                        Object object;
                        this.setMessage(OLAPArb.get("CUBE_DATA_VIEWER_READ_METADATA_MSG"));
                        CubeMetadataContextImpl cubeMetadataContextImpl = new CubeMetadataContextImpl(this.val$oraDb2, MeasureViewDataAction.this.schema.findCube(this.val$cubeName2));
                        Cube cube = cubeMetadataContextImpl.getCube();
                        cube.setSelected(false);
                        AnalyticWorkspace analyticWorkspace = new AnalyticWorkspace();
                        analyticWorkspace.addCube(cube);
                        Measure measure = cube.findMeasure(this.val$measureName2);
                        if (measure != null) {
                            measure.setSelected(true);
                            if (measure.isDerived()) {
                                object = new OLAPISyntaxParser(MeasureViewDataAction.this.schema, new Properties());
                                List<Measure> list = CalcReferences.getReferences(measure, (SyntaxParser)object, analyticWorkspace);
                                for (Measure measure2 : list) {
                                    measure2.setSelected(true);
                                }
                            }
                        }
                        object = new OLAPHelpProvider();
                        this.setMessage(OLAPArb.get("CUBE_DATA_VIEWER_QUERYING_DATA_MSG"));
                        MeasureViewDataAction.this.cubeDataViewerET = new CubeDataViewerDialog((JFrame)Ide.getMainWindow(), (HelpProvider)object, cubeMetadataContextImpl, null);
                    }
                    catch (Exception exception) {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    return bl;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            MeasureViewDataAction.this.warn(throwable);
                            MeasureViewDataAction.this.showErrorDialog(throwable);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (MeasureViewDataAction.this.cubeDataViewerET != null) {
                                MeasureViewDataAction.this.cubeDataViewerET.showViewer();
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        }
    }
}

