/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.calcfactory.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.olap.app.UISettings;
import oracle.olap.app.calcfactory.ui.CalcFactoryDialog;
import oracle.olap.app.templates.templatelist.Template;

public class NamingRuleEditorDialog
extends JDialog {
    private JTextArea editTextArea;
    private JTextArea previewTextArea;
    private JLabel editLocationLabel;
    private CalcFactoryDialog calcFactoryDialog;
    private Template calc;
    private boolean cancel;

    public NamingRuleEditorDialog(CalcFactoryDialog calcFactoryDialog, Template template, String string, String string2, boolean bl, String string3) {
        super(calcFactoryDialog, string2, bl);
        this.calcFactoryDialog = calcFactoryDialog;
        this.calc = template;
        this.setLocation(200, 200);
        this.setSize(new Dimension(500, 400));
        try {
            this.jbInit(string, string3);
            this.editTextArea.requestFocusInWindow();
            this.editTextArea.grabFocus();
            this.generatePreview();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setLineCol();
    }

    public boolean isCancel() {
        return this.cancel;
    }

    private void generatePreview() {
        String string = this.editTextArea.getText();
        this.previewTextArea.setToolTipText(null);
        try {
            String string2 = this.calcFactoryDialog.getGeneratedNameFromRuleSyntax(this.calc, string);
            this.previewTextArea.setText(string2);
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            this.previewTextArea.setText(string3);
            string3 = string3.replaceAll("\n", "<br>");
            string3 = "<html>" + string3 + "</html>";
            this.previewTextArea.setToolTipText(string3);
        }
    }

    private void setLineCol() {
        try {
            String string = this.editTextArea.getText();
            String[] stringArray = string.split("\n");
            int n = 0;
            int n2 = this.editTextArea.getCaretPosition();
            int n3 = this.editTextArea.getLineOfOffset(n2) + 1;
            for (int i = 0; i < n3 - 1 && i < stringArray.length - 1; ++i) {
                n += stringArray[i].length();
            }
            String string2 = String.format("Line %d Column %d", n3, n2 - n);
            this.editLocationLabel.setText(string2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private void jbInit(String string, String string2) throws Exception {
        JLabel jLabel = new JLabel(this.calcFactoryDialog.getResourceString("CALCFACTORY.DLG.NAMING.CALC.NAME"));
        JLabel jLabel2 = new JLabel(this.calc.getName());
        JLabel jLabel3 = new JLabel(this.calcFactoryDialog.getResourceString("CALCFACTORY.DLG.NAMING.CALC.RULE.NAME"));
        JLabel jLabel4 = new JLabel(string);
        JLabel jLabel5 = new JLabel(this.calcFactoryDialog.getResourceString("CALCFACTORY.DLG.NAMING.PREVIEW"));
        this.editLocationLabel = new JLabel();
        this.previewTextArea = new JTextArea(2, 40);
        this.previewTextArea.setEditable(false);
        this.previewTextArea.setBackground(jLabel5.getBackground());
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.editTextArea = new JTextArea(string2);
        Font font = this.editTextArea.getFont();
        Font font2 = new Font("Monospaced", font.getStyle(), font.getSize());
        this.editTextArea.setFont(font2);
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.editTextArea);
        JButton jButton = new JButton(this.calcFactoryDialog.getResourceString("CALCFACTORY.DLG.CANCEL"));
        JButton jButton2 = new JButton(this.calcFactoryDialog.getResourceString("CALCFACTORY.DLG.NAMEEDIT.OK"));
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)jButton2, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)jButton, DialogButtonBar.CONSTRAINT_CANCEL);
        final JTextField jTextField = new JTextField();
        Dimension dimension = jTextField.getPreferredSize();
        dimension.setSize(200.0, dimension.getHeight());
        jTextField.setPreferredSize(dimension);
        JButton jButton3 = new JButton(this.calcFactoryDialog.getResourceString("DIALOG_FIND"));
        this.getRootPane().setDefaultButton(jButton3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(jTextField);
        jPanel2.add(jButton3);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = UISettings.getPanelInsets();
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = UISettings.getTextFieldInsets();
        gridBagConstraints.insets = new Insets(0, gridBagConstraints.insets.left, gridBagConstraints.insets.bottom, gridBagConstraints.insets.right);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = UISettings.getPanelInsets();
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = UISettings.getPanelInsets();
        gridBagConstraints.insets = new Insets(0, gridBagConstraints.insets.left, gridBagConstraints.insets.bottom, gridBagConstraints.insets.right);
        jPanel.add((Component)this.editLocationLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = UISettings.getPanelInsets();
        jPanel.add((Component)jLabel5, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = UISettings.getPanelInsets();
        gridBagConstraints.insets = new Insets(0, gridBagConstraints.insets.left, gridBagConstraints.insets.bottom, 10);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().add(this.previewTextArea);
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = UISettings.getPanelInsets();
        jPanel.add((Component)dialogButtonBar, gridBagConstraints);
        this.getContentPane().add(jPanel);
        this.editTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                NamingRuleEditorDialog.this.generatePreview();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                NamingRuleEditorDialog.this.generatePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                NamingRuleEditorDialog.this.generatePreview();
            }
        });
        this.editTextArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                NamingRuleEditorDialog.this.setLineCol();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NamingRuleEditorDialog.this.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NamingRuleEditorDialog.this.cancel = true;
                NamingRuleEditorDialog.this.dispose();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                String string = NamingRuleEditorDialog.this.editTextArea.getText();
                String string2 = jTextField.getText();
                if (string2.length() == 0) {
                    return;
                }
                int n2 = NamingRuleEditorDialog.this.editTextArea.getSelectionStart();
                if (n2 > 0) {
                    n2 += string2.length();
                }
                if ((n = string.toLowerCase().indexOf(string2.toLowerCase(), n2)) == -1) {
                    n2 = 0;
                    n = string.toLowerCase().indexOf(string2.toLowerCase(), n2);
                }
                if (n >= 0) {
                    NamingRuleEditorDialog.this.editTextArea.setSelectionStart(n);
                    NamingRuleEditorDialog.this.editTextArea.setSelectionEnd(n + string2.length());
                    NamingRuleEditorDialog.this.editTextArea.requestFocusInWindow();
                }
            }
        });
    }

    public String getText() {
        String string = this.editTextArea.getText();
        return string;
    }
}

