/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.cubeddl.wrapper;

import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;
import oracle.olap.ddl.Identifier;
import oracle.olap.xmlbind.Description;

public abstract class BaseWrapper {
    private MetadataContext metadataContext;
    static final String ADD = "ADD";
    static final String REMOVE = "REMOVE";
    static final String CLEAR = "CLEAR";
    static final String FALSE = "False";
    static final String TRUE = "True";
    private static final String DOUBLE_QUOTE = "\"";

    public BaseWrapper() {
    }

    public BaseWrapper(MetadataContext metadataContext) {
        this.metadataContext = metadataContext;
    }

    public abstract String getName();

    protected String getName(String string) {
        return this.get(string, 1);
    }

    protected String getOwner(String string) {
        return this.get(string, 0);
    }

    protected String processName(String string) {
        return string;
    }

    public abstract void setName(String var1);

    private String get(String string, int n) {
        if (string.startsWith(DOUBLE_QUOTE)) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith(DOUBLE_QUOTE)) {
            string = string.substring(0, string.length() - 1);
        }
        String[] stringArray = string.split("\\.");
        if (n == 1 && stringArray.length == 2) {
            return stringArray[1];
        }
        if (n == 0 && stringArray.length == 2) {
            return stringArray[0];
        }
        if (n == 0 && stringArray.length == 1) {
            return null;
        }
        if (n == 0 && stringArray.length == 0) {
            return null;
        }
        return string;
    }

    public MetadataContext getMetadataContext() {
        return this.metadataContext;
    }

    public SystemObject getOriginalObject() {
        return this.metadataContext.getOriginalObject();
    }

    public SystemObject getUpdatedSystemObject() {
        return this.metadataContext.getUpdatedObject();
    }

    public SystemObject getOriginalSystemObject() {
        return this.metadataContext.getOriginalObject();
    }

    public SystemObject getSystemObject() {
        return this.metadataContext.getUpdatedObject();
    }

    public abstract void drop();

    public String processExpression(String object) {
        Object object2;
        String string = null;
        if (this.metadataContext.getUpdatedObject() instanceof SchemaObject) {
            object2 = (SchemaObject)this.metadataContext.getUpdatedObject();
            string = object2.getSchema().getName();
        }
        if (((String)object).startsWith(DOUBLE_QUOTE) && ((String)object).endsWith(DOUBLE_QUOTE) && ((String)(object2 = BaseWrapper.stripQuotes((String)object))).indexOf(DOUBLE_QUOTE) == -1) {
            object = object2;
        }
        return object;
    }

    public final String processSource(String string) {
        boolean bl;
        Identifier identifier;
        String string2;
        SchemaObject schemaObject = (SchemaObject)this.metadataContext.getUpdatedObject();
        if (schemaObject != null && ReservedWordsSyntaxHandler.IsOLAPIReservedWord(string2 = schemaObject.getSchema().getName(), string = (identifier = new Identifier(string)).toString(bl = false))) {
            string = String.format("\"%s\"", string);
        }
        return string;
    }

    public static final String stripQuotes(String string) {
        if ((string = string.replaceAll("''", "'")).startsWith("'")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith(DOUBLE_QUOTE)) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith(DOUBLE_QUOTE)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected Description createDescriptionObject(String string, String string2) {
        String string3 = "AMERICAN";
        String[] stringArray = (string = BaseWrapper.stripQuotes(string)).split(":");
        if (stringArray.length == 2) {
            string = stringArray[0];
            string3 = stringArray[1];
        }
        string2 = BaseWrapper.stripQuotes(string2);
        String string4 = ADD;
        string4 = null;
        if (string2.isEmpty()) {
            string4 = null;
        }
        Description description = new Description();
        if (string4 != null) {
            description.setAction(string4);
        }
        description.setType(string);
        description.setValueToFixError1(string2);
        if (string3 != null) {
            description.setLanguage(string3);
        }
        return description;
    }
}

