/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.cubeddl.wrapper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import oracle.javatools.db.SystemObject;
import oracle.olap.app.cubeddl.BuildSpecProperties;
import oracle.olap.app.cubeddl.CubeColumnProperties;
import oracle.olap.app.cubeddl.CubeDimensionalityMapProperties;
import oracle.olap.app.cubeddl.CubeDimensionalityProperties;
import oracle.olap.app.cubeddl.CubeMeasureMapProperties;
import oracle.olap.app.cubeddl.CubeMeasureProperties;
import oracle.olap.app.cubeddl.CubePartitionProperties;
import oracle.olap.app.cubeddl.DescriptionProperties;
import oracle.olap.app.cubeddl.wrapper.AbstractClassificationSetter;
import oracle.olap.app.cubeddl.wrapper.BaseWrapper;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeBuildSpecification;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.model.CubePartition;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.syntax.BuildSyntax;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.syntax.SolveSyntax;
import oracle.olap.xmlbind.AWCubeOrganization;
import oracle.olap.xmlbind.BaseMeasure;
import oracle.olap.xmlbind.BuildSpecifications;
import oracle.olap.xmlbind.Classification;
import oracle.olap.xmlbind.CubeDimensionalityMap;
import oracle.olap.xmlbind.CubeMap;
import oracle.olap.xmlbind.DerivedMeasure;
import oracle.olap.xmlbind.Description;
import oracle.olap.xmlbind.Dimensionality;
import oracle.olap.xmlbind.Measure;
import oracle.olap.xmlbind.MeasureMap;
import oracle.olap.xmlbind.Organization;
import oracle.olap.xmlbind.SecondaryPartitionLevel;
import oracle.olap.xmlbind.SparseDimension;

public class CubeWrapper
extends BaseWrapper {
    private static final String PrecomputeConditionTag = "PrecomputeCondition";
    private static final String DefaultBuildSpecTag = "DefaultBuild";
    private static final String COMPRESSED_SPARSE_TYPE = "COMPRESSED";
    private static final String DENSE_SPARSE_TYPE = "DENSE";
    private static final String MV_READY = "MV_READY";
    private static final String ConsistentSolve = "ConsistentSolve";
    private oracle.olap.xmlbind.Cube xmlcube;

    public CubeWrapper() {
        this.xmlcube = new oracle.olap.xmlbind.Cube();
    }

    public CubeWrapper(MetadataContext metadataContext) {
        super(metadataContext);
        this.xmlcube = new oracle.olap.xmlbind.Cube();
    }

    public CubeWrapper(oracle.olap.xmlbind.Cube cube) {
        this.xmlcube = cube;
    }

    @Override
    public String getName() {
        return this.xmlcube.getName();
    }

    @Override
    public void setName(String string) {
        this.xmlcube.setName(this.getName(string));
        String string2 = this.getOwner(string);
        if (string2 != null) {
            this.xmlcube.setOwner(string2);
        }
    }

    public oracle.olap.xmlbind.Cube getCube() {
        return this.xmlcube;
    }

    public void setAW(String string) {
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        aWCubeOrganization.setAW(this.processName(string));
    }

    private AWCubeOrganization getAWCubeOrganization() {
        Organization organization = this.xmlcube.getOrganization();
        AWCubeOrganization aWCubeOrganization = null;
        if (organization == null) {
            organization = new Organization();
            aWCubeOrganization = new AWCubeOrganization();
            organization.setAWCubeOrganization(aWCubeOrganization);
            this.xmlcube.setOrganization(organization);
        } else {
            aWCubeOrganization = organization.getAWCubeOrganization();
        }
        return aWCubeOrganization;
    }

    public void setDescriptions(List<DescriptionProperties> list) {
        if (list != null) {
            for (DescriptionProperties descriptionProperties : list) {
                Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                this.xmlcube.getDescription().add(description);
            }
        }
    }

    public void addClassifications(Map<String, String> map) {
        CubeClassificationSetter cubeClassificationSetter = new CubeClassificationSetter();
        cubeClassificationSetter.addClassifications(this.xmlcube, map);
    }

    public void setClassifications(Map<String, String> map) {
        CubeClassificationSetter cubeClassificationSetter = new CubeClassificationSetter();
        cubeClassificationSetter.setClassifications(this.xmlcube, map);
    }

    public void addMeasure(CubeMeasureProperties cubeMeasureProperties, Map<String, List<String>> map) {
        if (cubeMeasureProperties.isDefault) {
            this.xmlcube.setDefaultMeasure(cubeMeasureProperties.name);
        }
        if (cubeMeasureProperties.measureExpr == null) {
            BaseMeasure baseMeasure = new BaseMeasure();
            baseMeasure.setName(this.processName(cubeMeasureProperties.name));
            baseMeasure.setAllowAutoDataTypeChange(cubeMeasureProperties.allowAutoDataTypeChange);
            baseMeasure.setSQLDataType(cubeMeasureProperties.dataType);
            List<Measure> list = this.xmlcube.getMeasure();
            Measure measure = new Measure();
            measure.setAction("ADD");
            list.add(measure);
            if (cubeMeasureProperties.solveExpr != null) {
                JAXBElement jAXBElement = new JAXBElement(new QName(ConsistentSolve), String.class, (Object)"");
                cubeMeasureProperties.solveExpr = CubeWrapper.stripQuotes(cubeMeasureProperties.solveExpr);
                jAXBElement.setValue((Object)cubeMeasureProperties.solveExpr);
                baseMeasure.getContent().add(jAXBElement);
            }
            measure.getContent().add(baseMeasure);
            if (cubeMeasureProperties.descProps != null) {
                for (DescriptionProperties descriptionProperties : cubeMeasureProperties.descProps) {
                    Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                    baseMeasure.getContent().add(description);
                }
            }
            if (cubeMeasureProperties.cubeMeasureMapProps != null) {
                this.saveMeasureMapping(cubeMeasureProperties.name, cubeMeasureProperties.cubeMeasureMapProps, map);
            }
        } else {
            DerivedMeasure derivedMeasure = new DerivedMeasure();
            derivedMeasure.setName(this.processName(cubeMeasureProperties.name));
            derivedMeasure.setMeasureExpression(cubeMeasureProperties.measureExpr);
            List<Measure> list = this.xmlcube.getMeasure();
            Measure measure = new Measure();
            measure.setAction("ADD");
            list.add(measure);
            measure.getContent().add(derivedMeasure);
            Classification classification = new Classification();
            classification.setValueToFixError2("AwmDescriptionType=" + CubeWrapper.stripQuotes(cubeMeasureProperties.calcType));
            derivedMeasure.getClassification().add(classification);
            CubeClassificationSetter cubeClassificationSetter = new CubeClassificationSetter();
            cubeClassificationSetter.addClassifications(derivedMeasure, cubeMeasureProperties.classificationMap);
            if (cubeMeasureProperties.descProps != null) {
                for (DescriptionProperties descriptionProperties : cubeMeasureProperties.descProps) {
                    Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                    derivedMeasure.getDescription().add(description);
                }
            }
        }
    }

    private void saveMeasureMapping(String string, CubeMeasureMapProperties cubeMeasureMapProperties, Map<String, List<String>> map) {
        if (cubeMeasureMapProperties == null) {
            return;
        }
        this.createCubeMaps(map);
        List<CubeMap> list = this.xmlcube.getCubeMap();
        for (CubeMap cubeMap : list) {
            this.saveMeasureMapping(cubeMap, string, cubeMeasureMapProperties);
        }
    }

    private void saveMeasureMapping(CubeMap cubeMap, String string, CubeMeasureMapProperties cubeMeasureMapProperties) {
        if (cubeMeasureMapProperties == null) {
            return;
        }
        cubeMap.setQuery(this.processSource(cubeMeasureMapProperties.query));
        cubeMap.setAggregationMethod(CubeWrapper.stripQuotes(cubeMeasureMapProperties.aggregationMethod));
        if (cubeMeasureMapProperties.whereClause != null) {
            cubeMap.setWhereClause(CubeWrapper.stripQuotes(cubeMeasureMapProperties.whereClause));
        }
        MeasureMap measureMap = new MeasureMap();
        measureMap.setName(string);
        measureMap.setMeasure(string);
        measureMap.setExpression(this.processExpression(cubeMeasureMapProperties.expression));
        boolean bl = true;
        if (measureMap.getExpression() == null || measureMap.getExpression().isEmpty()) {
            measureMap.setAction("REMOVE");
            boolean bl2 = true;
            block0: for (CubeMeasure object3 : ((Cube)this.getUpdatedSystemObject()).getMeasures()) {
                if (object3.getName().equals(string)) continue;
                for (Object object : cubeMap.getContent()) {
                    MeasureMap measureMap2;
                    if (!(object instanceof MeasureMap) || (measureMap2 = (MeasureMap)object).getAction() != null && measureMap2.getAction().equals("REMOVE")) continue;
                    bl2 = false;
                    continue block0;
                }
            }
            boolean bl3 = true;
            for (Object object : cubeMap.getContent()) {
                CubeDimensionalityMap cubeDimensionalityMap;
                if (!(object instanceof CubeDimensionalityMap) || (cubeDimensionalityMap = (CubeDimensionalityMap)object).getAction() != null && cubeDimensionalityMap.getAction().equals("REMOVE")) continue;
                bl3 = false;
                break;
            }
            if (bl3 && bl2) {
                cubeMap.setAction("REMOVE");
                cubeMap.getContent().clear();
                bl = false;
            }
        }
        if (bl) {
            cubeMap.getContent().add(measureMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void saveDimensionMapping(String string, CubeDimensionalityMapProperties cubeDimensionalityMapProperties, Map<String, List<String>> map) {
        String string2 = this.processExpression(cubeDimensionalityMapProperties.expression);
        if (string2 != null && string2.length() > 0) {
            this.createCubeMaps(map);
        }
        List<String> list = null;
        for (String object2 : map.keySet()) {
            if (!string.equals(object2)) continue;
            list = map.get(object2);
        }
        List<CubeMap> list2 = this.xmlcube.getCubeMap();
        Object var7_8 = null;
        String string3 = null;
        if (list != null) {
            Iterator iterator = list.iterator();
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            void var7_10;
            CubeMap cubeMap = (CubeMap)iterator.next();
            if (var7_10 != null && var7_10.hasNext()) {
                string3 = (String)var7_10.next();
            }
            this.saveDimensionMapping(cubeMap, string, cubeDimensionalityMapProperties, string3);
        }
    }

    private void createCubeMaps(Map<String, List<String>> map) {
        List<CubeMap> list = this.xmlcube.getCubeMap();
        if (list.size() == 0) {
            Object object;
            Object object2;
            Iterator<String> iterator;
            int n = 1;
            if (map != null && (iterator = map.keySet().iterator()).hasNext()) {
                object2 = iterator.next();
                object = map.get(object2);
                n = object.size();
            }
            for (int i = 0; i < n; ++i) {
                object2 = new CubeMap();
                object = (Cube)this.getUpdatedSystemObject();
                String string = ((Cube)object).getMapName();
                if (string == null || string.length() == 0) {
                    string = "MAP1";
                }
                if (i == 0) {
                    ((CubeMap)object2).setName(string);
                } else {
                    ((CubeMap)object2).setName(String.format("MAP%d", i + 1));
                }
                list.add((CubeMap)object2);
            }
        }
    }

    private void saveDimensionMapping(CubeMap cubeMap, String string, CubeDimensionalityMapProperties cubeDimensionalityMapProperties, String string2) {
        cubeMap.setQuery(this.processSource(cubeDimensionalityMapProperties.query));
        cubeMap.setAggregationMethod(CubeWrapper.stripQuotes(cubeDimensionalityMapProperties.aggregationMethod));
        if (cubeDimensionalityMapProperties.whereClause != null) {
            cubeMap.setWhereClause(CubeWrapper.stripQuotes(cubeDimensionalityMapProperties.whereClause));
        }
        String string3 = string;
        CubeDimensionalityMap cubeDimensionalityMap = new CubeDimensionalityMap();
        cubeDimensionalityMap.setName(string3);
        cubeDimensionalityMap.setDimensionality(string3);
        cubeDimensionalityMap.setExpression(this.processExpression(cubeDimensionalityMapProperties.expression));
        if (cubeDimensionalityMapProperties.mappedDimension != null) {
            if (cubeDimensionalityMapProperties.mappedDimension.equals(string)) {
                cubeDimensionalityMap.setMappedDimension("");
                if (string2 != null) {
                    cubeDimensionalityMap.setMappedDimension(string2);
                }
            } else {
                cubeDimensionalityMap.setMappedDimension(cubeDimensionalityMapProperties.mappedDimension);
            }
        }
        if (cubeDimensionalityMapProperties.joinCondition != null) {
            cubeDimensionalityMap.setJoinCondition(CubeWrapper.stripQuotes(cubeDimensionalityMapProperties.joinCondition));
        }
        if (cubeDimensionalityMap.getExpression() == null || cubeDimensionalityMap.getExpression().isEmpty()) {
            if (this.getOriginalObject() != null) {
                cubeDimensionalityMap.setAction("REMOVE");
            } else {
                return;
            }
        }
        cubeMap.getContent().add(cubeDimensionalityMap);
    }

    public void setColumnProperties(List<CubeColumnProperties> list) {
        Map<String, CubeDimension> map;
        Cube cube = (Cube)this.getUpdatedSystemObject();
        List<Dimensionality> list2 = this.xmlcube.getDimensionality();
        boolean bl = false;
        if (this.getOriginalObject() != null) {
            int n = 0;
            int n2 = 0;
            map = (Cube)this.getOriginalObject();
            bl = true;
            if (((Cube)((Object)map)).getDimensions().length != cube.getDimensions().length) {
                bl = false;
            } else {
                for (CubeDimensionality cubeDimensionality : ((Cube)((Object)map)).getDimensions()) {
                    n2 = 0;
                    for (CubeDimensionality cubeDimensionality2 : cube.getDimensions()) {
                        String string = cubeDimensionality.getName();
                        String string2 = cubeDimensionality2.getName();
                        if (!(n != n2 || string.equals(string2) && cubeDimensionality.isSparse() == cubeDimensionality2.isSparse())) {
                            bl = false;
                            break;
                        }
                        if (!bl) break;
                        ++n2;
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.clearDimensions();
            }
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        List list3 = (List)this.getMetadataContext().get("dimensions");
        if (cube != null && list3 != null) {
            map = cube.getDimensionMap(list3);
            String string = cube.getConsistentSolveSpec();
            List<CubeAggregationDimension> list4 = SolveSyntax.getInstance().fromSyntax(cube, string);
            for (CubeColumnProperties cubeColumnProperties : list) {
                String string3;
                if (!(cubeColumnProperties instanceof CubeDimensionalityProperties)) continue;
                CubeDimensionalityProperties cubeDimensionalityProperties = (CubeDimensionalityProperties)cubeColumnProperties;
                String string4 = cubeDimensionalityProperties.name;
                if (cubeDimensionalityProperties.cubeDimMapProps == null || (string3 = cubeDimensionalityProperties.cubeDimMapProps.mappedDimension) == null || !string3.equals(string4)) continue;
                for (CubePartition cubePartition : cube.getPartitions()) {
                    String string5 = cubePartition.getPartitionDimension();
                    if (!string5.equals(string4)) continue;
                    for (CubeAggregationDimension cubeAggregationDimension : list4) {
                        String string6;
                        String string7 = cubeAggregationDimension.getName();
                        if (!string7.equals(string4) || (string6 = cubeAggregationDimension.getAggregationFromLevel()) == null || string6.length() <= 0) continue;
                        CubeDimension cubeDimension = map.get(string4);
                        List<String> list5 = cubeDimension.getChildLevels(string6);
                        hashMap.put(string4, list5);
                    }
                }
            }
        }
        for (CubeColumnProperties cubeColumnProperties : list) {
            if (cubeColumnProperties instanceof CubeDimensionalityProperties) {
                CubeDimensionalityProperties cubeDimensionalityProperties = (CubeDimensionalityProperties)cubeColumnProperties;
                Dimensionality dimensionality = null;
                if (cubeDimensionalityProperties.cubeDimMapProps != null) {
                    this.saveDimensionMapping(cubeDimensionalityProperties.name, cubeDimensionalityProperties.cubeDimMapProps, hashMap);
                }
                this.addSparsity(cubeDimensionalityProperties);
                dimensionality = this.addDimension(cubeDimensionalityProperties);
                if (!bl) {
                    list2.add(dimensionality);
                }
            }
            if (!(cubeColumnProperties instanceof CubeMeasureProperties)) continue;
            CubeMeasureProperties cubeMeasureProperties = (CubeMeasureProperties)cubeColumnProperties;
            this.addMeasure(cubeMeasureProperties, hashMap);
        }
    }

    public void addColumnProperties(List<CubeColumnProperties> list) {
        for (CubeColumnProperties cubeColumnProperties : list) {
            CubeColumnProperties cubeColumnProperties2;
            if (cubeColumnProperties instanceof CubeMeasureProperties) {
                cubeColumnProperties2 = (CubeMeasureProperties)cubeColumnProperties;
                this.addMeasure((CubeMeasureProperties)cubeColumnProperties2, null);
            }
            if (!(cubeColumnProperties instanceof CubeDimensionalityProperties)) continue;
            cubeColumnProperties2 = (CubeDimensionalityProperties)cubeColumnProperties;
            Dimensionality dimensionality = null;
            if (((CubeDimensionalityProperties)cubeColumnProperties2).cubeDimMapProps != null) {
                this.saveDimensionMapping(((CubeDimensionalityProperties)cubeColumnProperties2).name, ((CubeDimensionalityProperties)cubeColumnProperties2).cubeDimMapProps, null);
            }
            this.addSparsity((CubeDimensionalityProperties)cubeColumnProperties2);
            dimensionality = this.addDimension((CubeDimensionalityProperties)cubeColumnProperties2);
            List<Dimensionality> list2 = this.xmlcube.getDimensionality();
            list2.add(dimensionality);
        }
    }

    public void setDimension(String string, CubeDimensionalityMapProperties cubeDimensionalityMapProperties) {
        this.saveDimensionMapping(string, cubeDimensionalityMapProperties, null);
    }

    public void setMeasure(String string, String string2, boolean bl, String string3, String string4, String string5, CubeMeasureMapProperties cubeMeasureMapProperties, List<DescriptionProperties> list, Map<String, String> map, boolean bl2) {
        Object object;
        boolean bl3 = false;
        if (this.getOriginalSystemObject() instanceof Cube && ((Cube)(object = (Cube)this.getOriginalSystemObject())).findMeasure(string) != null) {
            bl3 = true;
        }
        if (bl) {
            this.setDefaultMeasure(string);
        }
        if (bl3) {
            object = new BaseMeasure();
            ((BaseMeasure)object).setName(this.processName(string));
            if (bl2) {
                ((BaseMeasure)object).setAllowAutoDataTypeChange("True");
            } else {
                ((BaseMeasure)object).setAllowAutoDataTypeChange("False");
            }
            ((BaseMeasure)object).setSQLDataType(string2);
            List<Measure> list2 = this.xmlcube.getMeasure();
            Measure measure = new Measure();
            list2.add(measure);
            measure.getContent().add(object);
            if (string5 != null) {
                JAXBElement jAXBElement = new JAXBElement(new QName(ConsistentSolve), String.class, (Object)"");
                string5 = CubeWrapper.stripQuotes(string5);
                jAXBElement.setValue((Object)string5);
                ((BaseMeasure)object).getContent().add(jAXBElement);
            }
            if (list != null) {
                for (DescriptionProperties descriptionProperties : list) {
                    Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                    ((BaseMeasure)object).getContent().add(description);
                }
            }
            this.saveMeasureMapping(string, cubeMeasureMapProperties, null);
        } else {
            Object object2;
            object = new DerivedMeasure();
            ((DerivedMeasure)object).setName(this.processName(string));
            ((DerivedMeasure)object).setMeasureExpression(string3);
            List<Measure> list3 = this.xmlcube.getMeasure();
            Measure measure = new Measure();
            list3.add(measure);
            measure.getContent().add(object);
            boolean bl4 = false;
            if (string4 != null) {
                object2 = new Classification();
                ((Classification)object2).setAction("CLEAR");
                ((DerivedMeasure)object).getClassification().add((Classification)object2);
                bl4 = true;
                object2 = new Classification();
                ((Classification)object2).setValueToFixError2("AwmDescriptionType=" + CubeWrapper.stripQuotes(string4));
                ((DerivedMeasure)object).getClassification().add((Classification)object2);
            }
            if (map != null) {
                if (!bl4) {
                    object2 = new Classification();
                    ((Classification)object2).setAction("CLEAR");
                    ((DerivedMeasure)object).getClassification().add((Classification)object2);
                }
                object2 = new CubeClassificationSetter();
                ((AbstractClassificationSetter)object2).addClassifications(object, map);
            }
            if (list != null) {
                for (DescriptionProperties descriptionProperties : list) {
                    Description description = this.createDescriptionObject(descriptionProperties.type, descriptionProperties.value);
                    ((DerivedMeasure)object).getDescription().add(description);
                }
            }
        }
    }

    public void removeMeasure(String string) {
        BaseMeasure baseMeasure = new BaseMeasure();
        baseMeasure.setName(this.processName(string));
        List<Measure> list = this.xmlcube.getMeasure();
        Measure measure = new Measure();
        measure.setAction("REMOVE");
        list.add(measure);
        measure.getContent().add(baseMeasure);
    }

    public void clearDimensions() {
        Cube cube = (Cube)this.getOriginalSystemObject();
        List<Dimensionality> list = this.xmlcube.getDimensionality();
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        for (CubeDimensionality cubeDimensionality : cube.getDimensions()) {
            String string = cubeDimensionality.getName();
            Dimensionality dimensionality = new Dimensionality();
            dimensionality.setAction("REMOVE");
            dimensionality.setName(string);
            dimensionality.setDimension(string);
            list.add(dimensionality);
            if (!cubeDimensionality.isSparse()) continue;
            SparseDimension sparseDimension = new SparseDimension();
            sparseDimension.setAction("REMOVE");
            sparseDimension.setName(string);
            aWCubeOrganization.getContent().add(sparseDimension);
        }
    }

    public boolean addSparsity(CubeDimensionalityProperties cubeDimensionalityProperties) {
        boolean bl = true;
        if (cubeDimensionalityProperties.isSparse) {
            AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
            SparseDimension sparseDimension = new SparseDimension();
            sparseDimension.setName(this.processName(cubeDimensionalityProperties.name));
            aWCubeOrganization.getContent().add(sparseDimension);
        }
        return bl;
    }

    public Dimensionality addDimension(CubeDimensionalityProperties cubeDimensionalityProperties) {
        Dimensionality dimensionality = new Dimensionality();
        dimensionality.setAction("ADD");
        dimensionality.setName(this.processName(cubeDimensionalityProperties.name));
        dimensionality.setDimension(this.processName(cubeDimensionalityProperties.name));
        return dimensionality;
    }

    public void removeDimension(String string) {
        List<Dimensionality> list = this.xmlcube.getDimensionality();
        Dimensionality dimensionality = new Dimensionality();
        dimensionality.setAction("REMOVE");
        dimensionality.setName(this.processName(string));
        dimensionality.setDimension(this.processName(string));
        list.add(dimensionality);
    }

    public void setSparseType(String string) {
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        aWCubeOrganization.setSparseType(string);
        if (string.equalsIgnoreCase(COMPRESSED_SPARSE_TYPE)) {
            aWCubeOrganization.setNullStorage(MV_READY);
        }
    }

    public void setMeasureStorage(String string) {
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        aWCubeOrganization.setMeasureStorage(string);
    }

    public void setSQLCubeStorageType(String string) {
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        aWCubeOrganization.setSQLCubeStorageType(string);
    }

    public void setCompressed(boolean bl) {
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        if (bl) {
            aWCubeOrganization.setSparseType(COMPRESSED_SPARSE_TYPE);
        } else {
            aWCubeOrganization.setSparseType(DENSE_SPARSE_TYPE);
        }
    }

    public void setPrecomputePercent(String string, String string2) {
        Byte by;
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        if (string2 != null) {
            by = Byte.valueOf(string2);
            aWCubeOrganization.setPrecomputePercent(by);
        }
        if (string != null) {
            by = Byte.valueOf(string);
            aWCubeOrganization.setPrecomputePercentTop(by);
        }
    }

    public void setPartition(String string, String string2) {
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        aWCubeOrganization.setPartitionLevel(string);
        Byte by = Byte.valueOf(string2);
        aWCubeOrganization.setPrecomputePercent(by);
    }

    public void clearPartitions() {
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        aWCubeOrganization.setPartitionLevel("");
        this.clearSecondaryPartitions();
    }

    public void clearSecondaryPartitions() {
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        SecondaryPartitionLevel secondaryPartitionLevel = new SecondaryPartitionLevel();
        secondaryPartitionLevel.setAction("CLEAR");
        aWCubeOrganization.getContent().add(secondaryPartitionLevel);
    }

    public void addPartition(String string, String string2) {
        byte by = Byte.valueOf(string2);
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        if (aWCubeOrganization.getPartitionLevel() == null || aWCubeOrganization.getPartitionLevel().isEmpty()) {
            aWCubeOrganization.setPartitionLevel(this.processName(string));
            aWCubeOrganization.setPrecomputePercent(by);
            return;
        }
        SecondaryPartitionLevel secondaryPartitionLevel = new SecondaryPartitionLevel();
        secondaryPartitionLevel.setAction("ADD");
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 3) {
            String string3 = stringArray[1] + "_" + stringArray[2];
            secondaryPartitionLevel.setName(this.processName(string3));
        }
        secondaryPartitionLevel.setLevel(this.processName(string));
        secondaryPartitionLevel.setPrecomputePercent(by);
        aWCubeOrganization.getContent().add(secondaryPartitionLevel);
    }

    public void setPartitions(List<CubePartitionProperties> list) {
        this.clearPartitions();
        for (CubePartitionProperties cubePartitionProperties : list) {
            this.addPartition(cubePartitionProperties.partitionLevel, cubePartitionProperties.precompute);
        }
    }

    public void setConsistentSolve(String string) {
        String string2 = CubeWrapper.stripQuotes(string);
        this.xmlcube.setConsistentSolve(string2);
    }

    public void setAggregationMethod(String string) {
        String string2 = CubeWrapper.stripQuotes(string);
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        List<CubeMap> list = this.findOrCreateCubeMaps();
        for (CubeMap cubeMap : list) {
            cubeMap.setAggregationMethod(string2);
        }
    }

    private List<CubeMap> findOrCreateCubeMaps() {
        List<CubeMap> list = this.xmlcube.getCubeMap();
        if (list.size() == 0) {
            CubeMap cubeMap = new CubeMap();
            Cube cube = (Cube)this.getUpdatedSystemObject();
            String string = cube.getMapName();
            if (string == null || string.length() == 0) {
                string = "MAP1";
            }
            cubeMap.setName(string);
            list.add(cubeMap);
        }
        return list;
    }

    public void setWhereClause(String string) {
        String string2 = CubeWrapper.stripQuotes(string);
        List<CubeMap> list = this.findOrCreateCubeMaps();
        for (CubeMap cubeMap : list) {
            cubeMap.setWhereClause(string2);
        }
    }

    public void setDefaultMeasure(String string) {
        this.xmlcube.setDefaultMeasure(string);
    }

    public void setPrecomputeCondition(String string) {
        this.setCubeOrgTag(PrecomputeConditionTag, string);
    }

    public void setBuildSpecs(List<BuildSpecProperties> list) {
        if (list != null) {
            AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
            BuildSyntax buildSyntax = BuildSyntax.getInstance();
            Map<String, Object> map = null;
            boolean bl = false;
            String string = null;
            this.setDefaultBuildSpec("");
            SystemObject systemObject = this.getOriginalSystemObject();
            if (systemObject != null && systemObject instanceof Cube) {
                CubeBuildSpecification[] cubeBuildSpecificationArray;
                Cube cube = (Cube)systemObject;
                string = cube.getSchema().getName();
                for (CubeBuildSpecification cubeBuildSpecification : cubeBuildSpecificationArray = cube.getBuildSpecifications()) {
                    String string2 = cubeBuildSpecification.getSyntax();
                    BuildSpecifications buildSpecifications = new BuildSpecifications();
                    buildSpecifications.setAction("REMOVE");
                    buildSpecifications.setValue(CubeWrapper.stripQuotes(string2));
                    aWCubeOrganization.getContent().add(buildSpecifications);
                }
            }
            for (BuildSpecProperties buildSpecProperties : list) {
                CubeBuildSpecification[] cubeBuildSpecificationArray = buildSpecProperties.buildSpecSyntax;
                int n = buildSpecProperties.isDefault;
                bl = false;
                try {
                    map = buildSyntax.fromSyntax(string, CubeWrapper.stripQuotes((String)cubeBuildSpecificationArray));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (map != null) {
                    String string3 = (String)map.get("CUBE_BUILD_SPECIFICATION_NAME_KEY");
                    if (string3 != null && string3.equalsIgnoreCase("SYS_DEFAULT")) {
                        bl = true;
                    }
                }
                if (bl) continue;
                this.addBuildSpecification((String)cubeBuildSpecificationArray, n != 0);
            }
        }
    }

    private void addBuildSpecification(String string, boolean bl) {
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        if (bl) {
            this.setDefaultBuildSpec(string);
        } else {
            aWCubeOrganization = this.getAWCubeOrganization();
            BuildSpecifications buildSpecifications = new BuildSpecifications();
            buildSpecifications.setValue(CubeWrapper.stripQuotes(string));
            aWCubeOrganization.getContent().add(buildSpecifications);
        }
    }

    public void setDefaultBuildSpec(String string) {
        this.setCubeOrgTag(DefaultBuildSpecTag, string);
    }

    private void setCubeOrgTag(String string, String string2) {
        AWCubeOrganization aWCubeOrganization = this.getAWCubeOrganization();
        JAXBElement jAXBElement = null;
        for (Object object : aWCubeOrganization.getContent()) {
            JAXBElement jAXBElement2;
            String string3;
            if (!(object instanceof JAXBElement) || !(string3 = (jAXBElement2 = (JAXBElement)object).getName().getLocalPart()).equals(string)) continue;
            jAXBElement = jAXBElement2;
        }
        if (string2 != null) {
            if (jAXBElement == null) {
                jAXBElement = new JAXBElement(new QName(string), String.class, (Object)"");
                aWCubeOrganization.getContent().add(jAXBElement);
            }
            string2 = CubeWrapper.stripQuotes(string2);
            jAXBElement.setValue((Object)string2);
        }
    }

    @Override
    public void drop() {
        this.xmlcube.setAction("REMOVE");
    }

    public void rename(String string) {
        this.xmlcube.setNewName(this.processName(string));
        this.xmlcube.setETViewName("");
    }

    public void renameMeasure(String string, String string2) {
        CubeMeasure cubeMeasure = this.findMeasure(this.processName(string));
        Measure measure = new Measure();
        if (cubeMeasure != null) {
            BaseMeasure baseMeasure = new BaseMeasure();
            baseMeasure.setName(this.processName(string));
            baseMeasure.setNewName(this.processName(string2));
            baseMeasure.setETMeasureColumnName("");
            measure.getContent().add(baseMeasure);
        } else {
            CubeCalculatedMeasure cubeCalculatedMeasure = this.findCalculatedMeasure(string);
            if (cubeCalculatedMeasure != null) {
                DerivedMeasure derivedMeasure = new DerivedMeasure();
                derivedMeasure.setName(this.processName(string));
                derivedMeasure.setNewName(this.processName(string2));
                derivedMeasure.setETMeasureColumnName("");
                measure.getContent().add(derivedMeasure);
            }
        }
        if (measure.getContent().size() > 0) {
            this.xmlcube.getMeasure().add(measure);
        }
    }

    private CubeMeasure findMeasure(String string) {
        SystemObject systemObject = this.getOriginalSystemObject();
        if (systemObject != null && systemObject instanceof Cube) {
            Cube cube = (Cube)systemObject;
            return cube.findMeasure(string);
        }
        return null;
    }

    private CubeCalculatedMeasure findCalculatedMeasure(String string) {
        SystemObject systemObject = this.getOriginalSystemObject();
        if (systemObject != null && systemObject instanceof Cube) {
            Cube cube = (Cube)systemObject;
            return cube.findCalculatedMeasure(string);
        }
        return null;
    }

    class CubeClassificationSetter
    extends AbstractClassificationSetter {
        CubeClassificationSetter() {
        }

        @Override
        public void addClassification(Object object, Classification classification) {
            if (object instanceof oracle.olap.xmlbind.Cube) {
                oracle.olap.xmlbind.Cube cube = (oracle.olap.xmlbind.Cube)object;
                cube.getClassification().add(classification);
            } else if (object instanceof DerivedMeasure) {
                DerivedMeasure derivedMeasure = (DerivedMeasure)object;
                derivedMeasure.getClassification().add(classification);
            }
        }
    }
}

