/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapmetadata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.olap.cubedimension.model.CubeDimension;

public class CubeLifeCycleInfo {
    private List<String> cubesWithDimensionList = new ArrayList<String>();
    private List<String> primaryPartitionCubeList = new ArrayList<String>();
    private List<String> secondaryPartitionCubeList = new ArrayList<String>();
    private CubeDimension dim;
    private DBObject dbObject;
    private int objectType;
    public static final int LIFECYCLE_TYPE_LEVEL = 1;
    public static final int LIFECYCLE_TYPE_HIERARCHY = 2;

    public CubeLifeCycleInfo(CubeDimension cubeDimension, DBObject dBObject, int n) {
        this.dim = cubeDimension;
        this.dbObject = dBObject;
        this.objectType = n;
    }

    public List<String> gatherCubeLifeCycleDetails() {
        this.cubesWithDimensionList = this.getCubesWithDimension();
        List<String> list = this.getAllCubesWithPartitionDimension();
        if (list.size() > 0) {
            if (this.objectType == 2) {
                this.getAllCubesWithHierarchyPartition(list);
            } else {
                this.getAllCubesWithLevelPartition(list);
            }
        }
        return this.cubesWithDimensionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCubesWithDimension() {
        String string = this.dim.getName();
        String string2 = this.dbObject.getSchemaName();
        Connection connection = this.dbObject.getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", string2);
        hashMap.put("dimension_name", string);
        this.cubesWithDimensionList.clear();
        String string3 = "SELECT CDY.CUBE_NAME CUBE_NAME FROM ALL_CUBE_DIMENSIONALITY CDY where CDY.OWNER = :owner  AND CDY.DIMENSION_NAME = :dimension_name ORDER BY CDY.CUBE_NAME";
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        try {
            Connections.getInstance().lock(connection);
            resultSetWrapper = dBUtil.executeQuery(string3, hashMap);
            if (resultSetWrapper != null) {
                resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    this.cubesWithDimensionList.add(resultSet.getString("CUBE_NAME"));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
            Connections.getInstance().unlock(connection);
        }
        return this.cubesWithDimensionList;
    }

    public void getAllCubesWithHierarchyPartition(List<String> list) {
        for (String string : list) {
            if (this.isHierarchyInPrimaryCubePartition(string)) {
                this.primaryPartitionCubeList.add(string);
                continue;
            }
            if (!this.isHierarchyInSecondaryCubePartition(string)) continue;
            this.secondaryPartitionCubeList.add(string);
        }
    }

    public void getAllCubesWithLevelPartition(List<String> list) {
        for (String string : list) {
            if (this.isLevelInPrimaryCubePartition(string)) {
                this.primaryPartitionCubeList.add(string);
                continue;
            }
            if (!this.isLevelInSecondaryCubePartition(string)) continue;
            this.secondaryPartitionCubeList.add(string);
        }
    }

    public List<String> getPrimaryPartitionCubeList() {
        return this.primaryPartitionCubeList;
    }

    public List<String> getSecondaryPartitionCubeList() {
        return this.secondaryPartitionCubeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllCubesWithPartitionDimension() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.dim.getName();
        String string2 = this.dbObject.getSchemaName();
        Connection connection = this.dbObject.getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("dimension_name", string);
        hashMap.put("owner", string2);
        String string3 = "SELECT CDY.CUBE_NAME FROM ALL_CUBE_DIMENSIONALITY CDY, ALL_CUBES C WHERE CDY.DIMENSION_NAME = :dimension_name  AND CDY.OWNER = :owner AND CDY.CUBE_NAME = C.CUBE_NAME AND  C.OWNER = :owner AND C.PARTITION_DIMENSION_NAME = :dimension_name";
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        try {
            Connections.getInstance().lock(connection);
            resultSetWrapper = dBUtil.executeQuery(string3, hashMap);
            if (resultSetWrapper != null) {
                resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    String string4 = resultSet.getString(1);
                    arrayList.add(string4);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
            Connections.getInstance().unlock(connection);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHierarchyInPrimaryCubePartition(String string) {
        boolean bl = false;
        String string2 = this.dim.getName();
        String string3 = this.dbObject.getSchemaName();
        String string4 = this.dbObject.getObjectName();
        Connection connection = this.dbObject.getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("cube_name", string);
        hashMap.put("dimension_name", string2);
        hashMap.put("partition_hierarchy_name", string4);
        hashMap.put("owner", string3);
        String string5 = "SELECT COUNT(*) FROM ALL_CUBES C where C.OWNER = :owner AND C.CUBE_NAME = :cube_name  AND C.PARTITION_DIMENSION_NAME = :dimension_name AND C.PARTITION_HIERARCHY_NAME = :partition_hierarchy_name";
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            Connections.getInstance().lock(connection);
            resultSetWrapper = dBUtil.executeQuery(string5, hashMap);
            if (resultSetWrapper != null) {
                resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    n = resultSet.getInt(1);
                    if (n <= 0) continue;
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
            Connections.getInstance().unlock(connection);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHierarchyInSecondaryCubePartition(String string) {
        boolean bl = false;
        String string2 = this.dim.getName();
        String string3 = this.dbObject.getSchemaName();
        String string4 = this.dbObject.getObjectName();
        Connection connection = this.dbObject.getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("cube_name", string);
        hashMap.put("dimension_name", string2);
        hashMap.put("partition_hierarchy_name", string4);
        hashMap.put("owner", string3);
        String string5 = "SELECT COUNT(*) FROM ALL_CUBE_SUB_PARTITION_LEVELS CPL where CPL.OWNER = :owner AND CPL.CUBE_NAME = :cube_name  AND CPL.PARTITION_DIMENSION_NAME = :dimension_name AND CPL.PARTITION_HIERARCHY_NAME = :partition_hierarchy_name";
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            Connections.getInstance().lock(connection);
            resultSetWrapper = dBUtil.executeQuery(string5, hashMap);
            if (resultSetWrapper != null) {
                resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    n = resultSet.getInt(1);
                    if (n <= 0) continue;
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
            Connections.getInstance().unlock(connection);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLevelInPrimaryCubePartition(String string) {
        boolean bl = false;
        String string2 = this.dim.getName();
        String string3 = this.dbObject.getSchemaName();
        String string4 = this.dbObject.getObjectName();
        Connection connection = this.dbObject.getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("cube_name", string);
        hashMap.put("dimension_name", string2);
        hashMap.put("partition_level_name", string4);
        hashMap.put("owner", string3);
        String string5 = "SELECT COUNT(*) FROM ALL_CUBES C where C.OWNER = :owner AND C.CUBE_NAME = :cube_name  AND C.PARTITION_DIMENSION_NAME = :dimension_name AND C.PARTITION_LEVEL_NAME = :partition_level_name";
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            Connections.getInstance().lock(connection);
            resultSetWrapper = dBUtil.executeQuery(string5, hashMap);
            if (resultSetWrapper != null) {
                resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    n = resultSet.getInt(1);
                    if (n <= 0) continue;
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
            Connections.getInstance().unlock(connection);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLevelInSecondaryCubePartition(String string) {
        boolean bl = false;
        String string2 = this.dim.getName();
        String string3 = this.dbObject.getSchemaName();
        String string4 = this.dbObject.getObjectName();
        Connection connection = this.dbObject.getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("cube_name", string);
        hashMap.put("dimension_name", string2);
        hashMap.put("partition_level_name", string4);
        hashMap.put("owner", string3);
        String string5 = "SELECT COUNT(*) FROM ALL_CUBE_SUB_PARTITION_LEVELS CPL where CPL.OWNER = :owner AND CPL.CUBE_NAME = :cube_name  AND CPL.PARTITION_DIMENSION_NAME = :dimension_name AND CPL.PARTITION_LEVEL_NAME = :partition_level_name";
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            Connections.getInstance().lock(connection);
            resultSetWrapper = dBUtil.executeQuery(string5, hashMap);
            if (resultSetWrapper != null) {
                resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    n = resultSet.getInt(1);
                    if (n <= 0) continue;
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
            Connections.getInstance().unlock(connection);
        }
        return bl;
    }
}

