/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapmetadata;

import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;

public class Measure
extends NamedObjectWithDesc {
    public static final String BASE = "BASE";
    public static final String DERIVED = "DERIVED";
    public static final String NUMERIC = "NUMBER";
    private Cube cube;
    private String measureType;
    private String expression;
    private String dataType;
    private int dataLength;
    private int dataPrecision;
    private int dataScale;
    private String columnName;

    public Measure(Cube cube, String string, String string2, String string3, String string4) {
        super(string, string2);
        this.cube = cube;
        this.measureType = string3;
        this.expression = string4;
    }

    public Measure(Cube cube, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        super(string, string2);
        this.cube = cube;
        this.measureType = string4;
        this.expression = string5;
        this.columnName = string3;
        this.setDataType(string6, string7, string8, string9);
    }

    public Cube getCube() {
        return this.cube;
    }

    public boolean isDerived() {
        if (this.measureType != null) {
            return this.measureType.equals(DERIVED);
        }
        return false;
    }

    public String getType() {
        return this.measureType;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setDataType(String string, String string2, String string3, String string4) {
        this.dataType = string;
        if (string2 != null && string2.matches("[\\d]+")) {
            this.dataLength = Integer.parseInt(string2);
        }
        if (string3 != null && string3.matches("[\\d]+")) {
            this.dataPrecision = Integer.parseInt(string3);
        }
        if (string4 != null && string4.matches("[\\d]+")) {
            this.dataScale = Integer.parseInt(string4);
        }
    }

    public void setDataType(String string, int n, int n2, int n3) {
        this.dataType = string;
        this.dataLength = n;
        this.dataPrecision = n2;
        this.dataScale = n3;
    }

    public boolean isNumeric() {
        return NUMERIC.equalsIgnoreCase(this.dataType);
    }

    public String getID() {
        return this.cube.getName() + "." + this.getName();
    }

    public String getDisplayLabel() {
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            return this.getDescription();
        }
        if (this.getLongDescription() != null && this.getLongDescription().length() > 0) {
            return this.getLongDescription();
        }
        if (this.getShortDescription() != null && this.getShortDescription().length() > 0) {
            return this.getShortDescription();
        }
        return this.getName();
    }
}

