/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapmetadata;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.MetadataChange;
import oracle.olap.app.olapmetadata.MetadataUpdateListener;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.olapmetadata.OLAPMetadataReader;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public final class OLAPMetadataCache {
    private static final Map<String, Status> schemas = Collections.synchronizedMap(new HashMap());
    private static final String KEY = "%s/%s";
    private static final Logger LOG = Logger.getLogger(OLAPMetadataCache.class.getName());

    private OLAPMetadataCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Schema getSchema(String string, String string2) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            Status status = OLAPMetadataCache.getStatus(OLAPMetadataCache.key(string, string2));
            if (!(status == null || status.updating || status.changes != null && status.changes.size() != 0)) {
                return status.schema;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Schema getUpdatedSchema(String string, String string2) throws DBException, SQLException, IOException {
        boolean bl = false;
        boolean bl2 = false;
        Status status = null;
        try {
            Object object = schemas;
            synchronized (object) {
                status = OLAPMetadataCache.getStatus(OLAPMetadataCache.key(string, string2));
                if (status == null || status.schema == null && !status.updating) {
                    bl = true;
                    OLAPMetadataCache.startUpdating(string, string2);
                    status = OLAPMetadataCache.getStatus(OLAPMetadataCache.key(string, string2));
                } else {
                    while (status.updating) {
                        try {
                            schemas.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (status.changes != null && status.changes.size() > 0) {
                        bl2 = true;
                        OLAPMetadataCache.startUpdating(string, string2);
                    }
                }
            }
            if (bl) {
                object = Connections.getInstance().getConnection(string);
                status.schema = new Schema(string2);
                OLAPMetadataReader oLAPMetadataReader = new OLAPMetadataReader(new DatabaseImpl((Connection)object), status.schema);
                oLAPMetadataReader.loadMetadata();
                OLAPMetadataCache.putSchema(string, status.schema);
                bl = false;
            } else if (bl2) {
                OLAPMetadataCache.doProcessChanges(status.schema, status.changes, string);
                bl2 = false;
            }
        }
        finally {
            if ((bl || bl2) && status != null) {
                status.updating = false;
            }
        }
        return status.schema;
    }

    /*
     * WARNING - void declaration
     */
    private static void doProcessChanges(Schema schema, HashSet<MetadataChange> hashSet, String string) throws SQLException, IOException, DBException {
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        Connection connection = Connections.getInstance().getConnection(string);
        HashMap hashMap = new HashMap();
        for (MetadataChange object : hashSet) {
            switch (object.getObjectType()) {
                case MEASURE: {
                    void var9_10;
                    List list = (List)hashMap.get(object.getParentName());
                    if (list == null) {
                        LinkedList linkedList3 = new LinkedList();
                        hashMap.put(object.getParentName(), linkedList3);
                    }
                    var9_10.add(object.getObjectName());
                    break;
                }
                case DIMENSION: {
                    linkedList2.add(object.getObjectName());
                    break;
                }
                case CUBE: {
                    linkedList.add(object.getObjectName());
                    break;
                }
            }
        }
        schema.setLoaded(false);
        OLAPMetadataReader oLAPMetadataReader = new OLAPMetadataReader(new DatabaseImpl(connection), schema);
        for (Map.Entry entry : hashMap.entrySet()) {
            Cube cube = schema.findCube((String)entry.getKey());
            if (cube == null) continue;
            oLAPMetadataReader.reloadMeasures(cube, (List)entry.getValue());
        }
        if (!linkedList.isEmpty()) {
            oLAPMetadataReader.reloadCubes(linkedList);
        }
        if (!linkedList2.isEmpty()) {
            oLAPMetadataReader.reloadDimensions(linkedList2);
        }
        OLAPMetadataCache.putSchema(string, schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Schema getSchemaCopy(String string, String string2) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            Schema schema = OLAPMetadataCache.getSchema(string, string2);
            if (schema != null) {
                Schema schema2 = OLAPMetadataCache.copy(schema);
                return schema2;
            }
            return null;
        }
    }

    private static Schema copy(Schema schema) {
        Schema schema2;
        block4: {
            block5: {
                block3: {
                    schema2 = new Schema(schema.getName());
                    schema2.setLoaded(true);
                    if (schema.getAWs().size() <= 0) break block3;
                    for (AnalyticWorkspace analyticWorkspace : schema.getAWs()) {
                        AnalyticWorkspace analyticWorkspace2 = new AnalyticWorkspace(schema2.getName(), analyticWorkspace.getName());
                        List<Cube> list = OLAPMetadataCache.addDupeCubesAndDims(schema2, analyticWorkspace.getCubes());
                        for (Cube cube : list) {
                            analyticWorkspace2.addCube(cube);
                        }
                    }
                    break block4;
                }
                if (schema.getCubes().size() <= 0 || schema.getDimensions().size() <= 0) break block5;
                OLAPMetadataCache.addDupeCubesAndDims(schema2, schema.getCubes());
                break block4;
            }
            if (schema.getDimensions().size() <= 0) break block4;
            for (Dimension dimension : schema.getDimensions()) {
                schema2.addDimension(dimension.clone());
            }
        }
        return schema2;
    }

    private static List<Cube> addDupeCubesAndDims(Schema schema, List<Cube> list) {
        HashMap<String, NamedObjectWithDesc> hashMap = new HashMap<String, NamedObjectWithDesc>();
        ArrayList<Cube> arrayList = new ArrayList<Cube>(list);
        for (Cube cube : list) {
            Object object;
            NamedObjectWithDesc namedObjectWithDesc;
            Cube cube2 = new Cube(cube.getSchema(), cube.getAWName(), cube.getName(), cube.getDescription(), cube.getViewName(), cube.isSQLExpressionsEnabled());
            schema.addCube(cube2);
            arrayList.add(cube2);
            for (Measure measure : cube.getMeasures()) {
                namedObjectWithDesc = cube2.addMeasure(measure.getName(), measure.getDescription(), measure.getType(), measure.getExpression());
                ((Measure)namedObjectWithDesc).setColumnName(measure.getColumnName());
                ((Measure)namedObjectWithDesc).setDataType(measure.isNumeric() ? "NUMBER" : "", 0, 0, 0);
            }
            for (Dimension dimension : cube.getDimensions()) {
                namedObjectWithDesc = (Dimension)hashMap.get(dimension.getID());
                if (namedObjectWithDesc == null) {
                    namedObjectWithDesc = dimension.clone();
                    schema.addDimension((Dimension)namedObjectWithDesc);
                    hashMap.put(((Dimension)namedObjectWithDesc).getID(), namedObjectWithDesc);
                }
                if ((object = cube.getDimensionColumn(dimension.getName())) != null) {
                    cube2.setDimensionColumn(dimension.getName(), (String)object);
                }
                cube2.addDimension((Dimension)namedObjectWithDesc);
            }
            if (cube.getHierarchyLevel() == null) continue;
            DimensionHierarchyLevel dimensionHierarchyLevel = cube.getHierarchyLevel();
            Dimension dimension = (Dimension)hashMap.get(dimensionHierarchyLevel.getDimension().getID());
            namedObjectWithDesc = dimension.findHierarchy(dimensionHierarchyLevel.getHierarchy().getName());
            object = ((DimensionHierarchy)namedObjectWithDesc).findHierarchyLevel(dimensionHierarchyLevel.getLevelName());
            cube2.setPartition((DimensionHierarchyLevel)object);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void putSchema(String string, Schema schema) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            String string2 = OLAPMetadataCache.key(string, schema.getName());
            Status status = OLAPMetadataCache.getStatus(string2);
            if (status == null) {
                status = new Status();
                schemas.put(string2, status);
            }
            schemas.put(string2, status);
            status.schema = schema;
            status.changes = null;
            status.updating = false;
            schemas.notifyAll();
        }
        OLAPMetadataCache.fireMetadataEvent(string, schema.getName(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Schema removeSchema(String string, String string2) {
        Schema schema = null;
        Map<String, Status> map = schemas;
        synchronized (map) {
            Status status = OLAPMetadataCache.getStatus(OLAPMetadataCache.key(string, string2));
            if (status != null) {
                schema = status.schema;
                status.schema = null;
                status.updating = false;
            }
        }
        OLAPMetadataCache.fireMetadataEvent(string, string2, true);
        return schema;
    }

    public static final boolean hasForConnection(String string, String string2) {
        return OLAPMetadataCache.getSchema(string, string2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean startUpdating(String string, String string2) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            String string3 = OLAPMetadataCache.key(string, string2);
            Status status = OLAPMetadataCache.getStatus(string3);
            if (status == null) {
                status = new Status();
                schemas.put(string3, status);
            }
            if (status.updating) {
                return false;
            }
            status.updating = true;
            OLAPMetadataCache.fireMetadataEvent(string, string2, true);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean recordMetadataChange(String string, String string2, MetadataChange metadataChange) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            Status status = OLAPMetadataCache.getStatus(OLAPMetadataCache.key(string, string2));
            if (status != null) {
                if (status.changes == null) {
                    status.changes = new HashSet();
                }
                if (metadataChange.getObjectType() == Type.MEASURE) {
                    for (MetadataChange metadataChange2 : status.changes) {
                        if (metadataChange2.getObjectType() != Type.CUBE || !metadataChange2.getObjectName().equals(metadataChange.getParentName())) continue;
                        return true;
                    }
                } else if (metadataChange.getObjectType() == Type.CUBE) {
                    LinkedList<MetadataChange> linkedList = new LinkedList<MetadataChange>();
                    if (status.changes.add(metadataChange)) {
                        for (MetadataChange metadataChange3 : status.changes) {
                            if (metadataChange3.getObjectType() != Type.MEASURE || !metadataChange3.getParentName().equals(metadataChange.getObjectName())) continue;
                            linkedList.add(metadataChange3);
                        }
                        status.changes.removeAll(linkedList);
                    }
                    return true;
                }
                status.changes.add(metadataChange);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUpdateListener(String string, String string2, MetadataUpdateListener metadataUpdateListener) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            String string3 = OLAPMetadataCache.key(string, string2);
            Status status = OLAPMetadataCache.getStatus(string3);
            if (status == null) {
                status = new Status();
                schemas.put(string3, status);
            }
            if (status.listeners == null) {
                status.listeners = new EventListenerList();
            }
            status.listeners.add(MetadataUpdateListener.class, metadataUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUpdateListener(String string, String string2, MetadataUpdateListener metadataUpdateListener) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            Status status = OLAPMetadataCache.getStatus(OLAPMetadataCache.key(string, string2));
            if (status != null && status.listeners != null) {
                status.listeners.remove(MetadataUpdateListener.class, metadataUpdateListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireMetadataEvent(String string, String string2, boolean bl) {
        Object[] objectArray;
        Schema schema = null;
        Map<String, Status> map = schemas;
        synchronized (map) {
            Status status = OLAPMetadataCache.getStatus(OLAPMetadataCache.key(string, string2));
            if (status == null || status.listeners == null) {
                return;
            }
            schema = status.schema;
            objectArray = status.listeners.getListenerList();
        }
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MetadataUpdateListener.class) continue;
            if (bl) {
                ((MetadataUpdateListener)objectArray[i + 1]).metadataCleared();
                continue;
            }
            ((MetadataUpdateListener)objectArray[i + 1]).metadataUpdated(schema);
        }
    }

    private static String key(String string, String string2) {
        return String.format(KEY, string, string2);
    }

    private static final Status getStatus(String string) {
        return schemas.get(string);
    }

    static class Status {
        Schema schema;
        EventListenerList listeners;
        boolean updating;
        HashSet<MetadataChange> changes;

        Status() {
        }
    }
}

