/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapmetadata;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionAttribute;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.DimensionView;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.olapmetadata.SubDimension;
import oracle.olap.app.table.Queries;

public class OLAPMetadataReader {
    private Database database;
    private Schema schema;
    private static Queries queries;
    private static final String XMLFILE = "olapmetadata.xml";
    private boolean loadAttributeVisibility;
    private boolean skipCubeViewColumns;
    private boolean skipDimensionality;
    private static final String DIMENSION = "DIMENSION";
    private static final String HIERARCHY = "HIERARCHY";
    private static final String DIM_LEVEL = "DIM_LEVEL";
    private static final String HIER_LEVEL = "HIER_LEVEL";
    private static final String DIMENSION_NAME = "dimension_name";
    private static final String CUBE_NAME = "cube_name";
    private static final Logger LOG;

    public OLAPMetadataReader(Database database, Schema schema) {
        this.database = database;
        this.schema = schema;
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        OLAPMetadataReader.queries = queries;
    }

    public void setLoadAttributeVisibility(boolean bl) {
        this.loadAttributeVisibility = bl;
    }

    public void setSkipDimensionality(boolean bl) {
        this.skipDimensionality = bl;
    }

    public void setSkipCubeViewColumns(boolean bl) {
        this.skipCubeViewColumns = bl;
    }

    public boolean isSkipCubeViewColumns() {
        return this.skipCubeViewColumns;
    }

    public void loadMetadata() throws SQLException, IOException {
        if (!this.schema.isLoaded()) {
            long l = System.currentTimeMillis();
            this.loadDimensions();
            LOG.finest(String.format("top dimension load: %s%n", System.currentTimeMillis() - l));
            l = System.currentTimeMillis();
            this.loadCubes(null, false);
            LOG.finest(String.format("top cube load with skipCubeViews %s: %s%n", this.skipCubeViewColumns, System.currentTimeMillis() - l));
            this.schema.setLoaded(true);
        }
    }

    public void loadAW(String string, boolean bl) throws SQLException, IOException {
        AnalyticWorkspace analyticWorkspace = new AnalyticWorkspace(this.schema.getName(), string);
        String string2 = "select all_cubes.cube_name, all_cube_views.view_name from all_cubes, all_cube_views where all_cubes.owner = ? and all_cubes.aw_name = ? and all_cubes.owner = all_cube_views.owner and all_cubes.cube_name = all_cube_views.cube_name";
        List<List<String>> list = this.database.executeSQL(string2, new Object[]{this.schema.getName(), string});
        ArrayList<String> arrayList = new ArrayList<String>();
        for (List<String> list2 : list) {
            String string3 = list2.get(0);
            String string4 = list2.get(1);
            Cube cube = new Cube(this.schema, string, string3, "", string4, false);
            analyticWorkspace.addCube(cube);
            this.schema.addCube(cube);
            arrayList.add(string3);
        }
        this.loadCubes(arrayList, bl);
        this.schema.addAW(analyticWorkspace);
    }

    public void loadDimensions() throws SQLException, IOException {
        this.loadDimensions(null);
    }

    /*
     * WARNING - void declaration
     */
    public void loadDimensions(List<String> list) throws SQLException, IOException {
        NamedObject namedObject;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        String string2;
        List<String> list22;
        Iterator<List<String>> iterator;
        String string3 = this.getNameCondition(DIMENSION_NAME, list);
        List<List<String>> list3 = this.database.executeSQL(String.format(this.getQuery("dimensions"), string3), new Object[]{this.schema.getName()});
        for (List<String> object72 : list3) {
            String string4 = object72.get(0);
            String string5 = object72.get(1);
            iterator = object72.get(2);
            list22 = object72.get(3);
            string2 = object72.get(4);
            this.schema.addDimension(new Dimension(this.database, this.schema, string2, string4, string5, (String)((Object)iterator), (String)((Object)list22)));
        }
        Object object8 = String.format(this.getQuery("attributes"), string3);
        list3 = this.database.executeSQL((String)object8, new Object[]{this.schema.getName()});
        for (List<String> list4 : list3) {
            String string6 = list4.get(0);
            iterator = list4.get(1);
            list22 = list4.get(2);
            string2 = list4.get(3);
            string = list4.get(4);
            object4 = list4.get(5);
            object3 = list4.get(6);
            object2 = list4.get(7);
            object = this.schema.findDimension(string6);
            namedObject = ((Dimension)object).addDimensionAttribute((String)((Object)iterator), (String)((Object)list22), string2);
            ((DimensionAttribute)namedObject).setDataType(string, (String)object4, (String)object3, (String)object2);
        }
        String string7 = this.getNameCondition(DIMENSION_NAME, "all_cube_hierarchies", list);
        object8 = String.format(this.getQuery("hierarchies"), string7);
        list3 = this.database.executeSQL((String)object8, new Object[]{this.schema.getName()});
        for (List<String> list5 : list3) {
            iterator = list5.get(0);
            list22 = list5.get(1);
            string2 = list5.get(2);
            string = list5.get(3);
            object4 = list5.get(4);
            object3 = this.schema.findDimension((String)((Object)iterator));
            object2 = ((Dimension)object3).addDimensionHierarchy(this.database, (String)((Object)list22), string2, string);
            ((DimensionHierarchy)object2).setETViewName((String)object4);
        }
        String string8 = this.getNameCondition(DIMENSION_NAME, "all_cube_dim_levels", list);
        object8 = String.format(this.getQuery("levels"), string8);
        list3 = this.database.executeSQL((String)object8, new Object[]{this.schema.getName()});
        for (List<String> list6 : list3) {
            iterator = list6.get(0);
            list22 = list6.get(1);
            string2 = list6.get(2);
            string = list6.get(3);
            object4 = this.schema.findDimension((String)((Object)iterator));
            object3 = ((Dimension)object4).findLevel(string2);
            if (object3 == null) {
                object3 = ((Dimension)object4).addDimensionLevel(string2, string);
            }
            object2 = null;
            if (list22 == null) continue;
            object2 = ((Dimension)object4).findHierarchy((String)((Object)list22));
            ((DimensionHierarchy)object2).addHierarchyLevel((DimensionLevel)object3, null);
        }
        object8 = String.format(this.getQuery("dimension_view_columns"), string3);
        list3 = this.database.executeSQL((String)object8, new Object[]{this.schema.getName(), this.schema.getName()});
        Object var6_14 = null;
        Object var7_24 = null;
        for (List<String> list22 : list3) {
            void var7_25;
            void var6_15;
            string2 = (String)list22.get(0);
            string = (String)list22.get(1);
            object4 = (String)list22.get(2);
            object3 = (String)list22.get(3);
            object2 = (String)list22.get(4);
            object = (String)list22.get(5);
            if (var6_15 == null || !var6_15.getName().equals(string2)) {
                Dimension dimension = this.schema.findDimension(string2);
                Object var7_26 = null;
            }
            namedObject = var6_15.getView();
            if (var6_15.getView() == null) {
                var6_15.setViewName((String)object4);
                namedObject = var6_15.getView();
            }
            if (string == null) {
                ((DimensionView)namedObject).addColumn((String)object3, (String)object2, (String)object);
                continue;
            }
            if (var7_25 == null || !var7_25.getName().equals(string)) {
                DimensionHierarchy dimensionHierarchy = var6_15.findHierarchy(string);
            }
            if (var7_25.getView() == null) continue;
            var7_25.getView().addColumn((String)object3, (String)object2, (String)object);
        }
        if (this.loadAttributeVisibility) {
            object8 = String.format(this.getQuery("attribute_visibility"), string3);
            list3 = this.database.executeSQL((String)object8, new Object[]{this.schema.getName()});
            for (List<String> list22 : list3) {
                DimensionHierarchyLevel dimensionHierarchyLevel;
                SubDimension subDimension;
                string2 = list22.get(0);
                string = list22.get(1);
                object4 = list22.get(2);
                object3 = list22.get(3);
                object2 = list22.get(4);
                object = list22.get(5);
                namedObject = this.schema.findDimension(string2);
                DimensionAttribute dimensionAttribute = ((Dimension)namedObject).findAttribute(string);
                if (((String)object2).equals(DIMENSION) && ((String)object).equals(DIMENSION)) {
                    dimensionAttribute.setIsVisibleForAll(true);
                }
                if (((String)object2).equals(DIMENSION) && ((String)object).equals(HIERARCHY) && object4 != null && (subDimension = ((Dimension)namedObject).findHierarchy((String)object4)) != null) {
                    subDimension.addVisibleAttribute(dimensionAttribute);
                }
                if (((String)object2).equals(DIMENSION) && ((String)object).equals(DIM_LEVEL) && object3 != null && (subDimension = ((Dimension)namedObject).findLevel((String)object3)) != null) {
                    subDimension.addVisibleAttribute(dimensionAttribute);
                }
                if (!((String)object2).equals(DIMENSION) || !((String)object).equals(HIER_LEVEL) || object4 == null || (subDimension = ((Dimension)namedObject).findHierarchy((String)object4)) == null || object3 == null || (dimensionHierarchyLevel = ((DimensionHierarchy)subDimension).findHierarchyLevel((String)object3)) == null) continue;
                dimensionHierarchyLevel.addVisibleAttribute(dimensionAttribute);
            }
        }
    }

    public void loadCubes() throws SQLException, IOException {
        this.loadCubes(null, true);
    }

    public void loadCube(String string) throws SQLException, IOException {
        if (!this.schema.isLoaded()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.loadCubes(arrayList, true);
        }
    }

    private void fetchCubes(List<String> list) throws SQLException, IOException {
        String string = this.getNameCondition(CUBE_NAME, "all_cubes", list);
        String string2 = String.format(this.getQuery("cubes"), string);
        List<List<String>> list2 = this.database.executeSQL(string2, new Object[]{this.schema.getName()});
        for (List<String> list3 : list2) {
            DimensionHierarchyLevel dimensionHierarchyLevel;
            DimensionHierarchy dimensionHierarchy;
            String string3 = list3.get(0);
            String string4 = list3.get(1);
            String string5 = list3.get(2);
            String string6 = list3.get(3);
            String string7 = list3.get(4);
            String string8 = list3.get(5);
            String string9 = list3.get(6);
            String string10 = list3.get(7);
            Cube cube = new Cube(this.database, this.schema, string10, string3, string5, string4, false);
            this.schema.addCube(cube);
            Dimension dimension = this.schema.findDimension(string7);
            if (dimension == null || (dimensionHierarchy = dimension.findHierarchy(string8)) == null || (dimensionHierarchyLevel = dimensionHierarchy.findHierarchyLevel(string9)) == null) continue;
            cube.setPartition(dimensionHierarchyLevel);
        }
    }

    private void loadCubesWithoutViewCols(List<String> list, boolean bl) throws SQLException, IOException {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        List<List<String>> list2;
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        String string2 = this.getNameCondition(CUBE_NAME, "ct", list);
        if (!this.skipDimensionality) {
            string = String.format(this.getQuery("cube_dimensionality_no_view"), string2);
            list2 = this.database.executeSQL(string, new Object[]{this.schema.getName()});
            for (List object5 : list2) {
                object4 = (String)object5.get(0);
                object3 = (String)object5.get(1);
                object22 = (List)hashMap.get(object4);
                if (object22 == null) {
                    object22 = new ArrayList<Object>();
                    hashMap.put(object4, object22);
                }
                object22.add(object3);
                arrayList.add((String)object3);
            }
            if (bl) {
                this.loadDimensions(arrayList);
            }
        }
        this.fetchCubes(list);
        if (!this.skipDimensionality) {
            for (Map.Entry entry : hashMap.entrySet()) {
                object4 = this.schema.findCube((String)entry.getKey());
                for (Object object22 : (List)entry.getValue()) {
                    object = this.schema.findDimension((String)object22);
                    ((Cube)object4).addDimension((Dimension)object);
                }
            }
        }
        string = String.format(this.getQuery("cube_measures_no_view"), string2);
        list2 = this.database.executeSQL(string, new Object[]{this.schema.getName()});
        for (List list3 : list2) {
            object4 = (String)list3.get(0);
            object3 = (String)list3.get(1);
            object22 = (String)list3.get(2);
            object = (String)list3.get(3);
            String string3 = (String)list3.get(4);
            String string4 = (String)list3.get(5);
            String string5 = (String)list3.get(6);
            String string6 = (String)list3.get(7);
            String string7 = (String)list3.get(8);
            Cube cube = this.schema.findCube((String)object4);
            Measure measure = cube.addMeasure((String)object3, (String)object22, (String)object, string3);
            measure.setDataType(string4, string5, string6, string7);
        }
    }

    private void loadCubesWithViewCols(List<String> list, boolean bl) throws SQLException, IOException {
        ArrayList<String> arrayList;
        Object object;
        HashMap<Object, ArrayList<String>> hashMap = null;
        String string = this.getNameCondition(CUBE_NAME, "ct", list);
        HashMap<String, Object> hashMap2 = null;
        if (!this.skipDimensionality && hashMap == null) {
            ArrayList arrayList2 = new ArrayList();
            hashMap = new HashMap<Object, ArrayList<String>>();
            hashMap2 = new HashMap<String, Object>();
            string = this.getNameCondition(CUBE_NAME, "all_cube_dimensionality", list);
            String string2 = String.format(this.getQuery("cube_dimensionality"), string);
            List<List<String>> list2 = this.database.executeSQL(string2, new Object[]{this.schema.getName()});
            for (List<String> list3 : list2) {
                String string3 = list3.get(0);
                String string4 = list3.get(1);
                object = list3.get(2);
                hashMap2.put(string4, object);
                arrayList = (List)hashMap.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(string3, arrayList);
                }
                arrayList.add(string4);
                arrayList2.add(string4);
            }
            if (bl) {
                this.loadDimensions(arrayList2);
            }
        }
        this.fetchCubes(list);
        if (!this.skipDimensionality) {
            for (Map.Entry entry : hashMap.entrySet()) {
                Cube cube = this.schema.findCube((String)entry.getKey());
                for (String string4 : (List)entry.getValue()) {
                    object = this.schema.findDimension(string4);
                    cube.addDimension((Dimension)object);
                    arrayList = (String)hashMap2.get(string4);
                    cube.setDimensionColumn(string4, (String)((Object)arrayList));
                }
            }
        }
        this.addMeasures("cube_measures_noclob", list);
        this.addMeasures("cube_measures_clob", list);
    }

    private void addMeasures(String string, List<String> list) throws SQLException, IOException {
        String string2 = this.getNameCondition(CUBE_NAME, "cm", list);
        String string3 = String.format(this.getQuery(string), string2);
        List<List<String>> list2 = this.database.executeSQL(string3, new Object[]{this.schema.getName()});
        for (List<String> list3 : list2) {
            String string4 = list3.get(0);
            String string5 = list3.get(1);
            String string6 = list3.get(2);
            String string7 = list3.get(3);
            String string8 = list3.get(4);
            String string9 = list3.get(5);
            String string10 = list3.get(6);
            String string11 = list3.get(7);
            String string12 = list3.get(8);
            String string13 = list3.get(9);
            Cube cube = this.schema.findCube(string4);
            Measure measure = cube.addMeasure(string5, string7, string8, string9);
            measure.setDataType(string10, string11, string12, string13);
            measure.setColumnName(string6);
        }
    }

    public void reloadMeasures(Cube cube, List<String> list) throws SQLException, IOException {
        Object object;
        long l = System.currentTimeMillis();
        String string = this.getQuery("only_cube_measures");
        String string2 = this.getNameCondition("MEASURE_NAME", "cm", list);
        string = String.format(string, string2);
        for (String object22 : list) {
            object = cube.findMeasure(object22);
            if (object == null) continue;
            cube.getMeasures().remove(object);
        }
        List<List<String>> list2 = this.database.executeSQL(string, new Object[]{this.schema.getName(), cube.getName()});
        Iterator l2 = list2.iterator();
        while (l2.hasNext()) {
            object = (List)l2.next();
            String string3 = (String)object.get(0);
            String string4 = (String)object.get(1);
            String string5 = (String)object.get(2);
            String string6 = (String)object.get(3);
            String string7 = (String)object.get(4);
            String string8 = (String)object.get(5);
            String string9 = (String)object.get(6);
            String string10 = (String)object.get(7);
            String string11 = (String)object.get(8);
            Measure measure = cube.addMeasure(string3, string5, string6, string7);
            measure.setDataType(string8, string9, string10, string11);
            measure.setColumnName(string4);
        }
        long l3 = System.currentTimeMillis() - l;
        LOG.finest(String.format("measures for %s loaded: %s%n", string2, l3));
    }

    public void reloadCubes(List<String> list) throws SQLException, IOException {
        this.schema.setLoaded(false);
        for (String string : list) {
            Cube cube = this.schema.findCube(string);
            if (cube == null) continue;
            this.schema.getCubes().remove(cube);
        }
        this.loadCubes(list, false);
        this.schema.setLoaded(true);
    }

    public void reloadDimensions(List<String> list) throws SQLException, IOException {
        this.schema.setLoaded(false);
        for (String string : list) {
            Dimension dimension = this.schema.findDimension(string);
            if (dimension == null) continue;
            this.schema.getDimensions().remove(dimension);
        }
        this.loadDimensions(list);
        this.schema.setLoaded(true);
    }

    public void loadCubes(List<String> list, boolean bl) throws SQLException, IOException {
        long l = System.currentTimeMillis();
        if (this.skipCubeViewColumns) {
            this.loadCubesWithoutViewCols(list, bl);
        } else {
            this.loadCubesWithViewCols(list, bl);
        }
        long l2 = System.currentTimeMillis() - l;
        LOG.finest(String.format("cubes loaded: %s%n", l2));
    }

    public static boolean isTimeDimension(DBUtil dBUtil, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", string);
        hashMap.put("name", string2);
        String string3 = "select dimension_type from all_cube_dimensions where owner = :owner and dimension_name = :name";
        String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
        return string4 != null && string4.equalsIgnoreCase("TIME");
    }

    public static List<String> getFullyMappedDimensions(DBUtil dBUtil, String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer("select distinct dimension_name from all_cube_dim_mappings ");
        String string2 = "where owner = :owner and dimension_name in (";
        int n = 1;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", string);
        for (String object : list) {
            string2 = n == list.size() ? string2 + ":dimname" + n + ")" : string2 + ":dimname" + n + ",";
            hashMap.put("dimname" + n, object);
            ++n;
        }
        if (list.size() > 0) {
            stringBuffer = stringBuffer.append(string2);
            stringBuffer = stringBuffer.append(" order by dimension_name");
            List list2 = dBUtil.executeReturnList(stringBuffer.toString(), hashMap);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                String string3 = (String)map.get("DIMENSION_NAME");
                string3 = string3.toUpperCase();
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public static List<String> getCubesWithMeasuresMapped(DBUtil dBUtil, String string, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer("select distinct cube_name from all_cube_meas_mappings ");
        int n = 1;
        String string2 = "where cube_name in (";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : list) {
            string2 = n == list.size() ? string2 + ":cubename" + n + ")" : string2 + ":cubename" + n + ",";
            hashMap.put("cubename" + n, object);
            ++n;
        }
        if (list.size() > 0) {
            stringBuffer.append(string2);
            stringBuffer = stringBuffer.append(" order by cube_name");
            List list2 = dBUtil.executeReturnList(stringBuffer.toString(), hashMap);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                String string3 = (String)map.get("CUBE_NAME");
                if (arrayList.contains(string3 = string3.toUpperCase())) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public static List<String> getCubesWithDimensionalityMapped(DBUtil dBUtil, String string, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer("select distinct cube_name, mapped_dimension_name from all_cube_dimnl_mappings ");
        int n = 1;
        String string2 = "where cube_name in (";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : list) {
            string2 = n == list.size() ? string2 + ":cubename" + n + ")" : string2 + ":cubename" + n + ",";
            hashMap.put("cubename" + n, object);
            ++n;
        }
        if (list.size() > 0) {
            stringBuffer.append(string2);
            stringBuffer = stringBuffer.append(" order by cube_name");
            List list2 = dBUtil.executeReturnList(stringBuffer.toString(), hashMap);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                String string3 = (String)map.get("CUBE_NAME");
                string3 = string3.toUpperCase();
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    private String getNameCondition(String string, List<String> list) {
        return this.getNameCondition(string, null, list);
    }

    private String getNameCondition(String string, String string2, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "";
        if (list != null) {
            for (String string4 : list) {
                stringBuffer.append(String.format("'%s',", string4));
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                string3 = string2 == null ? String.format(" and %s in (%s)", string, stringBuffer) : String.format(" and %s.%s in (%s)", string2, string, stringBuffer);
            }
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        DatabaseImpl databaseImpl = new DatabaseImpl();
        try {
            databaseImpl.getConnection("global", "global", "adc6141176:1521:omain3");
            Schema schema = new Schema("GLOBAL");
            OLAPMetadataReader oLAPMetadataReader = new OLAPMetadataReader(databaseImpl, schema);
            boolean bl = false;
            if (bl) {
                oLAPMetadataReader.loadMetadata();
            } else {
                oLAPMetadataReader.loadCube("UNITS_CUBE94");
            }
            List<Dimension> list = schema.getDimensions();
            System.out.println("Dimension size=" + list.size());
            for (Dimension object2 : list) {
                if (!object2.getName().equals("CHANNEL94")) continue;
                System.out.println(object2.toString());
            }
            List<Cube> list2 = schema.getCubes();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Cube cube = (Cube)iterator.next();
                if (!cube.getName().equals("UNITS_CUBE94")) continue;
                System.out.println(cube.toString());
            }
            System.out.println("Cube size=" + list2.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        LOG = Logger.getLogger(OLAPMetadataReader.class.getName());
    }
}

