/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.searchbar;

import java.util.HashMap;
import java.util.Map;
import oracle.olap.app.Resources;

public class SearchOptions {
    private Map<String, Boolean> searchOptionsMap;
    private Map<String, String> searchTextMap;
    private Resources resources;

    public SearchOptions(Resources resources) {
        this.resources = resources;
        this.searchTextMap = new HashMap<String, String>();
        if (resources != null) {
            this.searchTextMap.put(resources.getString("SEARCHOPTIONS.MATCH_CASE"), "MATCH_CASE");
            this.searchTextMap.put(resources.getString("SEARCHOPTIONS.MATCH_WHOLE_WORD"), "MATCH_WHOLE_WORD");
            this.searchTextMap.put(resources.getString("SEARCHOPTIONS.HIGHLIGHT_OCCURRENCES"), "HIGHLIGHT_OCCURRENCES");
        }
        this.init();
    }

    public SearchOptions(String string, String string2) {
        this.searchTextMap = new HashMap<String, String>();
        this.searchTextMap.put(string, "MATCH_WHOLE_WORD");
        this.searchTextMap.put(string2, "MATCH_CASE");
        this.init();
    }

    private void init() {
        this.searchOptionsMap = new HashMap<String, Boolean>();
        this.searchOptionsMap.put("MATCH_WHOLE_WORD", false);
        this.searchOptionsMap.put("MATCH_CASE", false);
        this.searchOptionsMap.put("HIGHLIGHT_OCCURRENCES", false);
    }

    public void set(String string, boolean bl) {
        String string2 = this.searchTextMap.get(string);
        this.searchOptionsMap.put(string2, bl);
    }

    public boolean isMatchWholeWord() {
        boolean bl = this.searchOptionsMap.get("MATCH_WHOLE_WORD");
        return bl;
    }

    public boolean isMatchCase() {
        boolean bl = this.searchOptionsMap.get("MATCH_CASE");
        return bl;
    }

    public boolean isHighlightAll() {
        boolean bl = this.searchOptionsMap.get("HIGHLIGHT_OCCURRENCES");
        return bl;
    }

    public Map<String, Boolean> getMap() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (String string : this.searchTextMap.keySet()) {
            String string2 = this.searchTextMap.get(string);
            boolean bl = this.searchOptionsMap.get(string2);
            hashMap.put(string, bl);
        }
        return hashMap;
    }

    public boolean match(String string, String string2) {
        boolean bl = string.equals(string2);
        if (!this.isMatchWholeWord() && this.isMatchCase()) {
            boolean bl2 = bl = string.indexOf(string2) >= 0;
        }
        if (this.isMatchWholeWord() && !this.isMatchCase()) {
            bl = string.equalsIgnoreCase(string2);
        }
        if (!this.isMatchWholeWord() && !this.isMatchCase()) {
            bl = string.toUpperCase().indexOf(string2.toUpperCase()) >= 0;
        }
        return bl;
    }
}

