/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.syntaxparser;

import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class ParseNode
extends DefaultMutableTreeNode {
    private final String type;
    private PatternType patternType;
    private boolean checkName;
    private String paramName;
    private String fullValue;
    private int offset;
    private int end;
    private int replaceEnd;
    private int replaceOffset;

    public ParseNode() {
        this(null, null, false, 0, 0);
    }

    public ParseNode(String string, String string2) {
        this(string, string2, false);
    }

    public ParseNode(String string, String string2, boolean bl) {
        this(string, string2, bl, -1, -1);
    }

    public ParseNode(String string, String string2, boolean bl, int n, int n2) {
        this(string, string2, bl, n, n2, PatternType.NONE);
    }

    public ParseNode(String string, String string2, int n, int n2) {
        this(string, string2, true, n, n2);
    }

    public ParseNode(String string, String string2, PatternType patternType) {
        this(null, string2, false, -1, -1, patternType);
        this.setParamName(string);
    }

    private ParseNode(String string, String string2, boolean bl, int n, int n2, PatternType patternType) {
        super(string);
        this.fullValue = string;
        this.type = string2;
        this.checkName = bl;
        this.offset = n;
        this.end = n2;
        this.replaceEnd = n2;
        this.replaceOffset = n;
        this.patternType = patternType;
    }

    public String getType() {
        return this.type;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public int getEnd() {
        return this.end;
    }

    public void setReplaceEnd(int n, String string) {
        this.setReplaceBounds(this.replaceOffset, n, string);
    }

    public void setReplaceBounds(int n, int n2, String string) {
        this.replaceEnd = n2;
        this.replaceOffset = n;
        this.fullValue = (this.replaceEnd != this.end || this.replaceOffset != this.offset) && this.replaceEnd >= 0 && this.replaceEnd <= string.length() && this.replaceOffset >= 0 && this.replaceOffset < string.length() && this.replaceEnd > this.replaceOffset ? string.substring(this.replaceOffset, this.replaceEnd) : (String)this.userObject;
    }

    public int getReplaceOffset() {
        return this.replaceOffset;
    }

    public int getReplaceEnd() {
        return this.replaceEnd;
    }

    public void setParamName(String string) {
        this.paramName = string;
    }

    public boolean isCheckName() {
        return this.checkName;
    }

    public void setCheckName(boolean bl) {
        this.checkName = bl;
    }

    public String getParamName() {
        return this.paramName;
    }

    public PatternType getPatternType() {
        return this.patternType;
    }

    public void setPatternType(PatternType patternType) {
        this.patternType = patternType;
    }

    public String getFullValue() {
        return this.fullValue;
    }

    public String getValue() {
        return (String)this.userObject;
    }

    public List<ParseNode> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public static enum PatternType {
        LOOP,
        CHOICE,
        OPTION,
        NONE,
        SKIP_CHILDREN;

    }
}

