/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.syntaxparser;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class ParsePatternMatcher {
    protected ParseNode parseMatch;
    private static final Logger LOG = Logger.getLogger(ParsePatternMatcher.class.getName());
    private SyntaxParser parser;
    private static final HashSet<String> MEASURE_ALTS = new HashSet(6);

    public ParsePatternMatcher(SyntaxParser syntaxParser) {
        this.parser = syntaxParser;
    }

    public void setupParsePattern(String string, HashMap<String, ParseNode> hashMap, HashMap<String, List<String>> hashMap2) {
        try {
            this.parseMatch = new ParseNode();
            boolean bl = this.parser.parseSyntax(string, this.parseMatch);
            LOG.finest(String.format("Expression [%s] valid? %s", string.toString(), bl));
            if (bl) {
                this.parseMatch = (ParseNode)this.parseMatch.getFirstChild();
                if (Type.valueFrom(this.parseMatch.getType()) == Type.BUILDSPEC && this.parseMatch.getChildCount() == 1) {
                    this.parseMatch = (ParseNode)this.parseMatch.getFirstChild();
                }
                for (String string2 : hashMap.keySet()) {
                    List<String> list = hashMap2.get(string2);
                    if (list == null) continue;
                    for (String string3 : list) {
                        if (string3 == null || string3.length() == 0) continue;
                        int n = string.indexOf(string3);
                        while (n != -1) {
                            int n2 = n + string3.length();
                            Enumeration<TreeNode> enumeration = this.parseMatch.breadthFirstEnumeration();
                            while (enumeration.hasMoreElements()) {
                                ParseNode parseNode = (ParseNode)enumeration.nextElement();
                                if (parseNode.getOffset() < n || parseNode.getEnd() > n2) continue;
                                parseNode.setParamName(string2);
                            }
                            n = string.indexOf(string3, n2);
                        }
                    }
                }
                this.setupParseNode(this.parseMatch, 0, hashMap);
            } else {
                this.parseMatch = null;
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, String.format("Template [%s] parse pattern not generated", string), throwable);
        }
    }

    private void setupParseNode(ParseNode parseNode, int n, Map<String, ParseNode> map) {
        ParseNode parseNode2 = (ParseNode)parseNode.getParent();
        if (parseNode.getParamName() != null) {
            ParseNode parseNode3 = map.get(parseNode.getParamName());
            if (parseNode3.getPatternType() == ParseNode.PatternType.CHOICE) {
                if (parseNode.getType().equals(Type.RANK.toString()) || parseNode.getType().equals(Type.AGGREGATE.toString())) {
                    parseNode.setCheckName(false);
                    ++n;
                } else if (parseNode2 != null) {
                    parseNode2.remove(n);
                }
            } else if (parseNode3.getPatternType() == ParseNode.PatternType.LOOP) {
                ParseNode parseNode4;
                boolean bl = true;
                if (n > 0 && (parseNode4 = (ParseNode)parseNode2.getChildAt(n - 1)).getParamName() != null && parseNode4.getParamName().equals(parseNode3.getParamName())) {
                    parseNode2.remove(n);
                    bl = false;
                }
                if (bl) {
                    parseNode2.remove(n);
                    parseNode2.insert(parseNode3, n);
                    ++n;
                    parseNode = null;
                }
            } else if (parseNode3.getPatternType() == ParseNode.PatternType.SKIP_CHILDREN) {
                parseNode.getChildren().clear();
                parseNode.setPatternType(ParseNode.PatternType.SKIP_CHILDREN);
                ++n;
            } else {
                ++n;
            }
        } else {
            ++n;
        }
        if (parseNode != null && parseNode.getChildCount() > 0) {
            this.setupParseNode((ParseNode)parseNode.getChildAt(0), 0, map);
        }
        if (parseNode2 != null && parseNode2.getChildCount() > n) {
            this.setupParseNode((ParseNode)parseNode2.getChildAt(n), n, map);
        }
    }

    public int matchesPattern(ParseNode parseNode) {
        if (this.parseMatch == null) {
            return 0;
        }
        return this.doMatch(this.parseMatch, parseNode, null);
    }

    public void loadParseNodes(ParseNode parseNode, List<TemplateHyperParam> list) {
        if (this.parseMatch != null) {
            this.doMatch(this.parseMatch, parseNode, new ParamLoader(list));
        }
    }

    private int doMatch(ParseNode parseNode, ParseNode parseNode2, ParamLoader paramLoader) {
        ParseNode parseNode3;
        boolean bl = paramLoader != null;
        LinkedList<ParseNode> linkedList = new LinkedList<ParseNode>();
        linkedList.push(parseNode2);
        LinkedList<ParseNode> linkedList2 = new LinkedList<ParseNode>();
        linkedList2.push(parseNode);
        int n = 0;
        while (!linkedList2.isEmpty() && !linkedList.isEmpty()) {
            parseNode3 = (ParseNode)linkedList2.pop();
            ParseNode parseNode4 = (ParseNode)linkedList.pop();
            if (ParseNode.PatternType.LOOP == parseNode3.getPatternType()) {
                linkedList2.push(parseNode3);
                linkedList.push(parseNode4);
                this.pushChildrenToStack(linkedList2, parseNode3);
                continue;
            }
            int n2 = this.compareNode(parseNode3, parseNode4, bl);
            if (n2 == 1) {
                ++n;
                boolean bl2 = false;
                if (bl) {
                    bl2 = paramLoader.tryLoad(parseNode4);
                }
                if (bl2 && Type.valueFrom(parseNode3.getType()) == Type.MEASURE || parseNode3.getPatternType() == ParseNode.PatternType.SKIP_CHILDREN) continue;
                this.pushChildrenToStack(linkedList, parseNode4);
                this.pushChildrenToStack(linkedList2, parseNode3);
                continue;
            }
            ParseNode parseNode5 = (ParseNode)parseNode3.getParent();
            if (parseNode5 != null && ParseNode.PatternType.LOOP == parseNode5.getPatternType()) {
                ParseNode parseNode6;
                linkedList.push(parseNode4);
                while (!linkedList2.isEmpty() && ParseNode.PatternType.LOOP != (parseNode6 = linkedList2.pop()).getPatternType()) {
                }
                continue;
            }
            linkedList2.push(parseNode3);
            if (!bl) continue;
            paramLoader.tryLoad(parseNode4);
            this.pushChildrenToStack(linkedList, parseNode4);
        }
        if (paramLoader != null && !linkedList.isEmpty()) {
            do {
                parseNode3 = (ParseNode)linkedList.pop();
                paramLoader.tryLoad(parseNode3);
                this.pushChildrenToStack(linkedList, parseNode3);
            } while (!linkedList.isEmpty());
            paramLoader.finish();
        }
        if (linkedList2.isEmpty()) {
            return n;
        }
        return 0;
    }

    private void pushChildrenToStack(LinkedList<ParseNode> linkedList, ParseNode parseNode) {
        for (int i = parseNode.getChildCount() - 1; i >= 0; --i) {
            linkedList.push((ParseNode)parseNode.getChildAt(i));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int compareNode(ParseNode parseNode, ParseNode parseNode2, boolean bl) {
        int n = 0;
        if (!parseNode.isCheckName()) {
            if (Type.MEASURE.toString().equals(parseNode.getType()) && this.isMeasureAlternative(parseNode2.getType())) {
                ++n;
                if (!bl) return n;
                if (parseNode.getParamName() != null) {
                    parseNode2.setParamName(parseNode.getParamName());
                    return n;
                } else {
                    parseNode2.setParamName(Type.MEASURE.toString());
                }
                return n;
            } else {
                if (!parseNode.getType().equals(parseNode2.getType())) return 0;
                ++n;
                if (!bl) return n;
                parseNode2.setParamName(parseNode.getParamName());
            }
            return n;
        } else {
            if (!((String)parseNode.getUserObject()).equalsIgnoreCase((String)parseNode2.getUserObject()) || !parseNode.getType().equals(parseNode2.getType())) return 0;
            ++n;
            if (!bl) return n;
            parseNode2.setParamName(parseNode.getParamName());
        }
        return n;
    }

    private boolean isMeasureAlternative(String string) {
        return MEASURE_ALTS.contains(string);
    }

    static {
        MEASURE_ALTS.add(Type.FUNCTION.toString());
        MEASURE_ALTS.add(Type.OPERATOR.toString());
        MEASURE_ALTS.add(Type.MEASURE.toString());
        MEASURE_ALTS.add(Type.RANK.toString());
        MEASURE_ALTS.add(Type.AGGREGATE.toString());
        MEASURE_ALTS.add(Type.QDR.toString());
    }

    class ParamLoader {
        private List<TemplateHyperParam> pendingParams;
        private LinkedList<ParseNode> value = new LinkedList();
        private TemplateHyperParam longParam;
        private Object longParamVal;
        private Object tmpVal;

        public ParamLoader(List<TemplateHyperParam> list) {
            this.pendingParams = list;
        }

        public boolean tryLoad(ParseNode parseNode) {
            TemplateHyperParam templateHyperParam = this.findParam(parseNode);
            if (templateHyperParam == null || this.isLongParam(templateHyperParam)) {
                if (templateHyperParam == null) {
                    this.value.add(parseNode);
                    templateHyperParam = this.findByValue(this.value);
                } else {
                    if (this.longParam == null) {
                        this.value.clear();
                    }
                    this.tmpVal = this.value;
                    this.value.add(parseNode);
                }
                if (templateHyperParam != null) {
                    if (this.longParam == null || templateHyperParam.getName().equals(this.longParam.getName())) {
                        this.storeLongParam(templateHyperParam, this.tmpVal);
                    }
                } else {
                    if (this.longParam != null) {
                        this.value.removeLast();
                        this.loadLongParam();
                        return this.tryLoad(parseNode);
                    }
                    this.value.removeLast();
                }
            } else {
                this.loadLongParam();
                this.setValue(templateHyperParam, parseNode);
                return true;
            }
            return false;
        }

        public void finish() {
            if (this.longParam != null) {
                this.loadLongParam();
            }
        }

        private void setValue(TemplateHyperParam templateHyperParam, Object object) {
            if (templateHyperParam == null || object == null) {
                return;
            }
            templateHyperParam.setValue(object);
            for (TemplateHyperParam templateHyperParam2 : templateHyperParam.getOptionalHyperParams()) {
                if (templateHyperParam2.isVisible()) continue;
                this.pendingParams.remove(templateHyperParam2);
            }
            this.pendingParams.remove(templateHyperParam);
        }

        private void loadLongParam() {
            if (this.longParam != null) {
                this.setValue(this.longParam, this.longParamVal);
                this.longParam = null;
                this.longParamVal = null;
            }
            this.value.clear();
        }

        private void storeLongParam(TemplateHyperParam templateHyperParam, Object object) {
            this.longParam = templateHyperParam;
            this.longParamVal = object;
        }

        private TemplateHyperParam findParam(ParseNode parseNode) {
            TemplateHyperParam templateHyperParam = null;
            templateHyperParam = (parseNode.getParamName() == null || parseNode.getParamName().equals(Type.MEASURE.toString())) && parseNode.getType().equals(Type.MEASURE.toString()) ? this.findByType(this.pendingParams, Type.MEASURE.toString()) : this.findByName(this.pendingParams, parseNode.getParamName());
            if (templateHyperParam == null) {
                templateHyperParam = this.findByType(this.pendingParams, parseNode.getType());
            }
            return templateHyperParam;
        }

        private TemplateHyperParam findByName(List<TemplateHyperParam> list, String string) {
            for (TemplateHyperParam templateHyperParam : list) {
                if (!templateHyperParam.getName().equals(string)) continue;
                return templateHyperParam;
            }
            return null;
        }

        private TemplateHyperParam findByType(List<TemplateHyperParam> list, String string) {
            for (TemplateHyperParam templateHyperParam : list) {
                if (!templateHyperParam.getType().equals(string)) continue;
                return templateHyperParam;
            }
            return null;
        }

        private TemplateHyperParam findByValue(LinkedList<ParseNode> linkedList) {
            block0: for (TemplateHyperParam templateHyperParam : this.pendingParams) {
                ParseNode parseNode = templateHyperParam.getPattern();
                if (parseNode != null && parseNode.getPatternType() == ParseNode.PatternType.CHOICE) {
                    block1: for (ParseNode parseNode2 : parseNode.getChildren()) {
                        Object object = parseNode2.getValue();
                        int n = 0;
                        for (ParseNode parseNode3 : linkedList) {
                            n = ((String)object).indexOf(parseNode3.getValue());
                            if (n != -1) continue;
                            continue block1;
                        }
                        this.tmpVal = parseNode2;
                        return templateHyperParam;
                    }
                    continue;
                }
                if (parseNode == null || parseNode.getPatternType() != ParseNode.PatternType.LOOP || parseNode.getChildCount() <= 0) continue;
                Iterator<ParseNode> iterator = parseNode.getChildren().iterator();
                for (Object object : linkedList) {
                    if (!iterator.hasNext()) {
                        iterator = parseNode.getChildren().iterator();
                    }
                    if (ParsePatternMatcher.this.compareNode(iterator.next(), (ParseNode)object, true) == 1) continue;
                    continue block0;
                }
                this.tmpVal = this.value;
                return templateHyperParam;
            }
            return null;
        }

        private boolean isLongParam(TemplateHyperParam templateHyperParam) {
            ParseNode parseNode = templateHyperParam.getPattern();
            return ParseNode.PatternType.LOOP == parseNode.getPatternType() || ParseNode.PatternType.CHOICE == parseNode.getPatternType();
        }
    }
}

