/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.olap.app.db.RowSetCallBack;
import oracle.olap.app.db.RowSetMetadataCallback;
import oracle.olap.app.table.Column;
import oracle.olap.app.table.Query;
import oracle.olap.app.table.QueryResultStatistics;
import oracle.olap.app.table.View;

public class QueryTableModel
extends DefaultTableModel {
    private boolean m_changed;
    private String[] m_columnNames;
    private int totalRows;
    private int m_columnCount;
    private Connection m_conn;
    private Query m_query;
    private Map<String, Object> m_queryParams = new HashMap<String, Object>();
    private QueryResultStatistics queryResultStatistics;

    public QueryTableModel(Connection connection, Query query, Map<String, Object> map) {
        this.m_conn = connection;
        this.m_query = query;
        this.m_queryParams = map;
        this.queryResultStatistics = new QueryResultStatistics();
        this.initColumnCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateQueryTableDataModel() throws SQLException {
        boolean bl = false;
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_conn);
        dBUtil.setRaiseError(true);
        ResultSetWrapper resultSetWrapper = null;
        if (Connections.getInstance().lock(this.m_conn)) {
            try {
                if (this.m_columnCount == 0) {
                    RowSetMetadataCallback rowSetMetadataCallback = new RowSetMetadataCallback(){

                        @Override
                        public void processRowSetMetadata(ResultSetMetaData resultSetMetaData) throws SQLException {
                            QueryTableModel.this.m_columnCount = resultSetMetaData.getColumnCount();
                            QueryTableModel.access$102(QueryTableModel.this, new String[QueryTableModel.this.m_columnCount]);
                            for (int i = 1; i <= QueryTableModel.this.m_columnCount; ++i) {
                                ((QueryTableModel)QueryTableModel.this).m_columnNames[i - 1] = resultSetMetaData.getColumnName(i);
                                QueryTableModel.this.addColumn(resultSetMetaData.getColumnName(i));
                            }
                        }
                    };
                    RowSetCallBack rowSetCallBack = new RowSetCallBack(){
                        int row = 0;

                        @Override
                        public void processRowSet(ResultSet resultSet) throws SQLException {
                            Vector<String> vector = new Vector<String>();
                            for (int i = 0; i < QueryTableModel.this.m_columnCount; ++i) {
                                vector.add(resultSet.getString(i + 1));
                            }
                            ++this.row;
                            QueryTableModel.this.addRow(vector);
                            QueryTableModel.this.m_changed = true;
                            QueryTableModel.this.totalRows = this.row;
                        }
                    };
                    ResultSet resultSet = null;
                    this.queryResultStatistics.setStartDate(new Date());
                    resultSetWrapper = dBUtil.executeQuery(this.m_query.getText(), this.m_queryParams);
                    this.queryResultStatistics.setEndDate(new Date());
                    if (resultSetWrapper != null && (resultSet = resultSetWrapper.getResultSet()) != null) {
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        if (rowSetMetadataCallback != null) {
                            rowSetMetadataCallback.processRowSetMetadata(resultSetMetaData);
                        }
                        if (resultSetMetaData != null) {
                            while (resultSet.next()) {
                                rowSetCallBack.processRowSet(resultSet);
                            }
                        }
                    }
                } else {
                    ArrayList arrayList = new ArrayList();
                    Vector<String> vector = new Vector<String>();
                    this.m_changed = false;
                    ResultSet resultSet = null;
                    String string = this.m_query.getText();
                    this.queryResultStatistics.setStartDate(new Date());
                    resultSetWrapper = dBUtil.executeQuery(string, this.m_queryParams);
                    this.queryResultStatistics.setEndDate(new Date());
                    if (resultSetWrapper != null) {
                        int n = 0;
                        resultSet = resultSetWrapper.getResultSet();
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                vector = new Vector();
                                for (int i = 0; i < this.m_columnCount; ++i) {
                                    vector.add(resultSet.getString(i + 1));
                                }
                                ++n;
                                arrayList.add(vector);
                            }
                        }
                        if (n > this.totalRows) {
                            this.setRowCount(0);
                            for (Vector vector2 : arrayList) {
                                this.addRow(vector2);
                                this.m_changed = true;
                            }
                            this.totalRows = arrayList.size();
                        }
                    }
                }
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(this.m_conn);
            }
        }
        bl = this.m_changed;
        return bl;
    }

    public QueryResultStatistics getQueryResultStatistics() {
        this.queryResultStatistics.setRowCount(this.totalRows);
        return this.queryResultStatistics;
    }

    public void resetColumnCount() {
        this.m_columnCount = 0;
    }

    public int getNumOfRows() {
        return this.totalRows;
    }

    public Query getQuery() {
        return this.m_query;
    }

    private void initColumnCount() {
        View view = this.m_query.getView();
        if (view != null && this.m_columnCount == 0) {
            List<Column> list = view.getColumnList();
            for (Column column : list) {
                this.addColumn(column.getName());
                ++this.m_columnCount;
            }
        }
    }

    static /* synthetic */ String[] access$102(QueryTableModel queryTableModel, String[] stringArray) {
        queryTableModel.m_columnNames = stringArray;
        return stringArray;
    }
}

