/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templatedialogimpl;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olap.app.Resources;
import oracle.olap.app.db.Database;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.syntaxparser.SyntaxParserStateListener;
import oracle.olap.app.templates.templatedialog.TemplateHelper;
import oracle.olap.app.templates.templatedialog.TemplateHelperFactory;
import oracle.olap.app.templates.templatedialogimpl.TemplateHelperImpl;
import oracle.olap.app.templates.templatelist.BaseTemplate;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateExpression;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateMetadata;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.app.templates.view.TemplateHyperContextImpl;
import oracle.olap.app.util.FetchIcon;

public class TemplateHelperFactoryImpl
implements TemplateHelperFactory {
    private TemplateContext context;
    private Resources resources;
    private TemplateHyperContext hyperContext;
    private Logger LOG = Logger.getLogger(TemplateHelperFactoryImpl.class.getName());
    private Schema schema;
    private Database database;
    private Properties props;
    private FetchIcon fi;
    private SyntaxParser parser;
    private boolean initialized;
    private String connectionName;
    private String schemaName;
    private SyntaxParserStateListener parserStateListener = new SyntaxParserStateListener(){

        @Override
        public void stateChanged(boolean bl) {
            if (bl) {
                TemplateHelperFactoryImpl.this.reinitialize();
            }
        }
    };

    public TemplateHelperFactoryImpl(Properties properties, Resources resources, FetchIcon fetchIcon) {
        this(properties, null, null, null, resources, fetchIcon);
    }

    public TemplateHelperFactoryImpl(Properties properties, Database database, Schema schema, SyntaxParser syntaxParser, Resources resources, FetchIcon fetchIcon) {
        this.resources = resources;
        this.database = database;
        this.schema = schema;
        this.setParser(syntaxParser);
        this.props = properties;
        this.fi = fetchIcon;
    }

    public TemplateHelperFactoryImpl(Properties properties, Database database, String string, String string2, SyntaxParser syntaxParser, Resources resources, FetchIcon fetchIcon) {
        this(properties, database, null, syntaxParser, resources, fetchIcon);
        this.connectionName = string;
        this.schemaName = string2;
    }

    @Override
    public TemplateHelper getInstance(Object ... objectArray) {
        if (!this.initialized) {
            this.initialize();
        }
        TemplateGroup templateGroup = null;
        TemplateExpression templateExpression = null;
        for (Object object : objectArray) {
            if (object instanceof TemplateGroup) {
                templateGroup = (TemplateGroup)object;
            }
            if (!(object instanceof Template)) continue;
            templateExpression = (Template)object;
        }
        if (templateExpression == null && templateGroup != null && !templateGroup.isContainer()) {
            return new TemplateHelperImpl(templateGroup, this.context, this.hyperContext, this.parser);
        }
        if (templateExpression != null && templateExpression.getExpression() != null && ((BaseTemplate)templateExpression).getUi() != null) {
            return new TemplateHelperImpl((Template)templateExpression, templateGroup, this.context, this.hyperContext, this.parser);
        }
        return null;
    }

    public void initialize() {
        this.initialized = true;
        try {
            if (this.connectionName != null) {
                this.schema = OLAPMetadataCache.getSchema(this.connectionName, this.schemaName);
            }
            this.hyperContext = new TemplateHyperContextImpl(this.database.getConnection(), this.resources, this.fi, true);
            if (this.schema == null) {
                this.context = new TemplateContext();
            } else {
                Cube cube = this.schema.findCube(this.props.getProperty("CUBE"));
                this.context = new TemplateContext(this.database, new TemplateMetadata(cube));
                this.hyperContext = new TemplateHyperContextImpl(this.database.getConnection(), this.resources, this.fi, true);
            }
        }
        catch (Exception exception) {
            this.LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    public void reinitialize() {
        if (this.initialized) {
            try {
                if (this.connectionName != null) {
                    this.schema = OLAPMetadataCache.getSchema(this.connectionName, this.schemaName);
                }
                Cube cube = this.schema.findCube(this.props.getProperty("CUBE"));
                this.context.reinitialize(new TemplateMetadata(cube));
            }
            catch (Exception exception) {
                this.LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        } else {
            this.initialize();
        }
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setProperty(String string, String string2) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.setProperty(string, string2);
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setParser(SyntaxParser syntaxParser) {
        this.parser = syntaxParser;
        if (syntaxParser != null) {
            syntaxParser.addSyntaxParserStateListener(this.parserStateListener);
        }
    }

    public SyntaxParser getParser() {
        return this.parser;
    }
}

