/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templatedialogimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.ParsePatternMatcher;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.syntaxparser.SyntaxParserStateListener;
import oracle.olap.app.templates.templatedialog.TemplateData;
import oracle.olap.app.templates.templatedialog.TemplateGUI;
import oracle.olap.app.templates.templatedialog.TemplateHelper;
import oracle.olap.app.templates.templatedialog.TemplateHelperListener;
import oracle.olap.app.templates.templatedialogimpl.TemplateGUIImpl;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templateview.BaseTemplateHyperView;
import oracle.olap.app.templates.templateview.TemplateGroupHyperView;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateHyperView;
import oracle.olap.app.templates.view.TemplateContext;

public class TemplateHelperImpl
implements TemplateHelper {
    private static final Logger LOG = Logger.getLogger(TemplateHelperImpl.class.getName());
    private final EventListenerList listeners = new EventListenerList();
    private final TemplateContext context;
    private final TemplateHyperContext hyperContext;
    private final Template template;
    private final TemplateGroup group;
    private final SyntaxParser parser;
    private TemplateGUIImpl gui;
    private BaseTemplateHyperView templateView;
    private ParsePatternMatcher patternMatcher;
    private SyntaxParserStateListener parserStateListener = new SyntaxParserStateListener(){

        @Override
        public void stateChanged(final boolean bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        TemplateHelperImpl.this.reinitalize();
                    } else {
                        TemplateHelperImpl.this.patternMatcher = null;
                        TemplateHelperImpl.this.fireReinitialize();
                    }
                }
            });
        }
    };

    public TemplateHelperImpl(TemplateGroup templateGroup, TemplateContext templateContext, TemplateHyperContext templateHyperContext, SyntaxParser syntaxParser) {
        this.template = null;
        this.context = templateContext;
        this.hyperContext = templateHyperContext;
        this.parser = syntaxParser;
        this.parser.addSyntaxParserStateListener(this.parserStateListener);
        this.group = templateGroup;
        this.reinitalize();
    }

    public TemplateHelperImpl(Template template, TemplateGroup templateGroup, TemplateContext templateContext, TemplateHyperContext templateHyperContext, SyntaxParser syntaxParser) {
        this.context = templateContext;
        this.hyperContext = templateHyperContext;
        this.template = template;
        this.parser = syntaxParser;
        this.parser.addSyntaxParserStateListener(this.parserStateListener);
        this.group = this.fixGroup(template, templateGroup);
        this.reinitalize();
    }

    @Override
    public void reinitalize() {
        this.templateView = this.createView(this.template, this.group, this.context, this.hyperContext);
        this.gui = new TemplateGUIImpl(this, this.templateView);
        this.patternMatcher = null;
        this.getParsePatternMatcher();
        this.fireReinitialize();
    }

    private boolean validParameters() {
        boolean bl = this.group.isTimeTemplate() || this.template != null && this.template.isTime();
        boolean bl2 = this.context == null || this.context.getTimeDimension() == null;
        return !bl || bl && !bl2;
    }

    public ParsePatternMatcher getParsePatternMatcher() {
        if (this.patternMatcher == null && this.templateView != null) {
            try {
                this.gui.getComponent();
                String string = this.templateView.getExpression();
                HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                HashMap<String, ParseNode> hashMap2 = new HashMap<String, ParseNode>();
                this.patternMatcher = new ParsePatternMatcher(this.parser);
                this.getParamValues(this.templateView, hashMap, hashMap2);
                this.patternMatcher.setupParsePattern(string, hashMap2, hashMap);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, String.format("Error generating the ParsePatternMatched for %s", this.getTitle()), exception);
            }
        }
        return this.patternMatcher;
    }

    private void getParamValues(BaseTemplateHyperView baseTemplateHyperView, HashMap<String, List<String>> hashMap, HashMap<String, ParseNode> hashMap2) {
        block3: {
            block2: {
                this.addEntry(hashMap, baseTemplateHyperView.getCurrentParameterValues());
                if (!(baseTemplateHyperView instanceof TemplateGroupHyperView)) break block2;
                TemplateGroupHyperView templateGroupHyperView = (TemplateGroupHyperView)baseTemplateHyperView;
                for (BaseTemplateHyperView baseTemplateHyperView2 : templateGroupHyperView.getAllTemplateViews()) {
                    this.getParamValues(baseTemplateHyperView2, hashMap, hashMap2);
                }
                break block3;
            }
            if (!(baseTemplateHyperView instanceof TemplateHyperView)) break block3;
            for (TemplateHyperParam templateHyperParam : baseTemplateHyperView.getHyperParams()) {
                hashMap2.put(templateHyperParam.getName(), templateHyperParam.getPattern());
            }
        }
    }

    private void addEntry(HashMap<String, List<String>> hashMap, HashMap<String, String> hashMap2) {
        for (Map.Entry<String, String> entry : hashMap2.entrySet()) {
            List<String> list = hashMap.get(entry.getKey());
            if (list == null) {
                list = new LinkedList<String>();
                hashMap.put(entry.getKey(), list);
            }
            list.add(entry.getValue());
        }
    }

    @Override
    public int matchesPattern(ParseNode parseNode) {
        this.patternMatcher = this.getParsePatternMatcher();
        if (this.patternMatcher != null) {
            int n = this.patternMatcher.matchesPattern(parseNode);
            return n;
        }
        return 0;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public String getTitle() {
        if (this.template == null) {
            return this.group.getName();
        }
        return this.template.getName();
    }

    public TemplateGroup getTemplateGroup() {
        return this.group;
    }

    @Override
    public TemplateGUI getGUI(boolean bl) {
        if (bl) {
            return this.gui;
        }
        return new TemplateGUIImpl(this, this.createView(this.template, this.group, this.context, this.hyperContext));
    }

    private BaseTemplateHyperView createView(Template template, TemplateGroup templateGroup, TemplateContext templateContext, TemplateHyperContext templateHyperContext) {
        try {
            if (template != null) {
                return new TemplateHyperView(null, templateContext, templateHyperContext, templateGroup, template);
            }
            return new TemplateGroupHyperView(templateContext, templateHyperContext, templateGroup);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, template.getName(), exception);
            return null;
        }
    }

    private TemplateGroup fixGroup(Template template, TemplateGroup templateGroup) {
        TemplateGroup templateGroup2 = new TemplateGroup();
        if (template.getName() != null) {
            templateGroup2.setName(template.getName());
        }
        if (templateGroup != null) {
            templateGroup2.setTemplateList(templateGroup.getTemplateList());
            templateGroup2.setTimeTemplates(templateGroup.isTimeTemplate());
            for (Param param : templateGroup.getParams()) {
                templateGroup2.addParam(param);
            }
            if (template.getName() == null) {
                templateGroup2.setName(templateGroup.getName());
            }
        }
        if (template.getParams() != null) {
            for (Param param : template.getParams()) {
                templateGroup2.addParam(param);
            }
        }
        templateGroup2.addTemplate(template);
        for (Param param : templateGroup2.getParams()) {
            template.addParam(param);
        }
        return templateGroup2;
    }

    @Override
    public void addTemplateHelperListener(TemplateHelperListener templateHelperListener) {
        this.listeners.add(TemplateHelperListener.class, templateHelperListener);
    }

    @Override
    public void removeTemplateHelperListener(TemplateHelperListener templateHelperListener) {
        this.listeners.remove(TemplateHelperListener.class, templateHelperListener);
    }

    private void fireReinitialize() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            ((TemplateHelperListener)objectArray[i + 1]).helperReinitialized();
        }
    }

    @Override
    public TemplateData.Mode[] availableModes(TemplateData.Mode[] modeArray) {
        if (this.gui != null) {
            ArrayList<TemplateData.Mode> arrayList = new ArrayList<TemplateData.Mode>(modeArray.length);
            for (TemplateData.Mode mode : modeArray) {
                if (mode == TemplateData.Mode.WRAP) {
                    LinkedList<TemplateHyperParam> linkedList = new LinkedList<TemplateHyperParam>();
                    TemplateGUIImpl.getAllHyperParams(this.templateView, linkedList);
                    for (TemplateHyperParam templateHyperParam : linkedList) {
                        if (!templateHyperParam.isCanWrap()) continue;
                        arrayList.add(mode);
                    }
                    continue;
                }
                arrayList.add(mode);
            }
            return arrayList.toArray(new TemplateData.Mode[arrayList.size()]);
        }
        return modeArray;
    }
}

