/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templatelist;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.app.templates.templatelist.Item;

public class Param
implements Cloneable {
    private List<Item> items = new ArrayList<Item>();
    private String type;
    private String name;
    private boolean editable = true;
    private String initialDefaultValue;
    private String defaultValue;
    private String expressionProperty;

    public List<Item> getItems() {
        return this.items;
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDefault(String string) {
        this.initialDefaultValue = string;
        this.defaultValue = string;
    }

    public void updateDefault(String string) {
        this.defaultValue = string;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public String getInitialDefault() {
        return this.initialDefaultValue;
    }

    public void setEditable(String string) {
        if (string != null && string.equalsIgnoreCase("YES") && string.equalsIgnoreCase("TRUE")) {
            this.editable = true;
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setDefault(Item item) {
        for (Item item2 : this.items) {
            item2.setDefault(false);
            if (item2 != item) continue;
            item2.setDefault(true);
        }
    }

    public void setExpressionProperty(String string) {
        this.expressionProperty = string;
    }

    public String getExpressionProperty() {
        return this.expressionProperty;
    }

    protected Object clone() throws CloneNotSupportedException {
        Param param = (Param)super.clone();
        param.items = new ArrayList<Item>();
        for (Item item : this.items) {
            param.items.add((Item)item.clone());
        }
        param.type = this.type;
        param.name = this.name;
        param.editable = this.editable;
        param.initialDefaultValue = this.initialDefaultValue;
        param.defaultValue = this.defaultValue;
        param.expressionProperty = this.expressionProperty;
        return param;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  <Param type=\"" + this.type + "\" name=\"" + this.name + "\"");
        if (this.defaultValue != null) {
            stringBuffer.append(" default=\"" + this.defaultValue + "\"");
        }
        stringBuffer.append(">\n");
        if (this.items != null) {
            for (Item item : this.items) {
                stringBuffer.append("    " + item.toXML() + "\n");
            }
        }
        stringBuffer.append("  </Param>\n");
        return stringBuffer.toString();
    }
}

