/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templatelist;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.app.templates.templatelist.BaseTemplate;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templatelist.Template;

public class TemplateGroup
extends BaseTemplate
implements Cloneable {
    private List<BaseTemplate> templates = new ArrayList<BaseTemplate>();
    private List<Param> params = new ArrayList<Param>();
    private boolean isContainer = true;
    private boolean isTimeTemplates;
    static final String YES = "YES";
    static final String TRUE = "TRUE";

    public List<Param> getParams() {
        return this.params;
    }

    public void addParam(Param param) {
        this.params.add(param);
    }

    public void setTimeTemplates(String string) {
        if (string.equalsIgnoreCase(YES) || string.equalsIgnoreCase(TRUE)) {
            this.isTimeTemplates = true;
        }
    }

    public void setTimeTemplates(boolean bl) {
        this.isTimeTemplates = bl;
    }

    public boolean isTimeTemplate() {
        return this.isTimeTemplates;
    }

    public List<BaseTemplate> getTemplates() {
        return this.templates;
    }

    public void addTemplate(Template template) {
        this.templates.add(template);
        template.setTemplateList(this.getTemplateList());
    }

    public void addTemplateGroup(TemplateGroup templateGroup) {
        this.templates.add(templateGroup);
        templateGroup.setTemplateList(this.getTemplateList());
    }

    public List<TemplateGroup> getTemplateGroups() {
        ArrayList<TemplateGroup> arrayList = new ArrayList<TemplateGroup>();
        for (BaseTemplate baseTemplate : this.templates) {
            if (!(baseTemplate instanceof TemplateGroup)) continue;
            arrayList.add((TemplateGroup)baseTemplate);
        }
        return arrayList;
    }

    public List<Template> getTemplatesOnly() {
        ArrayList<Template> arrayList = new ArrayList<Template>();
        for (BaseTemplate baseTemplate : this.templates) {
            if (!(baseTemplate instanceof Template)) continue;
            arrayList.add((Template)baseTemplate);
        }
        return arrayList;
    }

    public TemplateGroup getClone() {
        try {
            return (TemplateGroup)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        TemplateGroup templateGroup = (TemplateGroup)super.clone();
        templateGroup.params = new ArrayList<Param>();
        for (Param param : this.params) {
            templateGroup.params.add((Param)param.clone());
        }
        templateGroup.templates = this.templates;
        templateGroup.isTimeTemplates = this.isTimeTemplates;
        return templateGroup;
    }

    @Override
    public String toXML() {
        return this.toXML(this.templates);
    }

    public String toXML(List<BaseTemplate> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  <TemplateGroup name=\"" + this.getName() + "\"\n");
        stringBuffer.append("        ui=\"" + this.getUi() + "\">\n");
        for (Param object : this.params) {
            stringBuffer.append(object.toXML());
        }
        for (BaseTemplate baseTemplate : list) {
            stringBuffer.append(baseTemplate.toXML());
        }
        stringBuffer.append("  </TemplateGroup>\n");
        return stringBuffer.toString();
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public void setIsContainer(String string) {
        this.isContainer = string.equalsIgnoreCase(YES) || string.equalsIgnoreCase(TRUE);
    }
}

