/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templatelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.olap.app.templates.templatelist.BaseTemplate;
import oracle.olap.app.templates.templatelist.Measure;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateExpression;
import oracle.olap.app.templates.templatelist.TemplateGroup;

public class TemplateList {
    private List<BaseTemplate> templates = new ArrayList<BaseTemplate>();
    private List<Param> templateParams = new ArrayList<Param>();
    private List<Measure> measures = new ArrayList<Measure>();
    private String comment;
    private List<TemplateExpression> expressions = new ArrayList<TemplateExpression>();

    public void addMeasure(String string, boolean bl) {
        this.measures.add(new Measure(string, bl));
    }

    public void addMeasure(Measure measure) {
        this.measures.add(measure);
    }

    public List<Measure> getMeasures() {
        return this.measures;
    }

    public void removeAllMeasures() {
        this.measures.clear();
    }

    public boolean isMeasureSelected(String string) {
        for (Measure measure : this.measures) {
            if (!measure.getName().equals(string) || !measure.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void addTemplate(Template template) {
        this.templates.add(template);
        template.setTemplateList(this);
    }

    public List<BaseTemplate> getTemplates() {
        return this.templates;
    }

    public void addTemplateGroup(TemplateGroup templateGroup) {
        this.templates.add(templateGroup);
        templateGroup.setTemplateList(this);
    }

    public List<TemplateGroup> getTemplateGroups() {
        ArrayList<TemplateGroup> arrayList = new ArrayList<TemplateGroup>();
        for (BaseTemplate baseTemplate : this.templates) {
            if (!(baseTemplate instanceof TemplateGroup)) continue;
            arrayList.add((TemplateGroup)baseTemplate);
        }
        return arrayList;
    }

    public List<Template> getTemplatesOnly() {
        ArrayList<Template> arrayList = new ArrayList<Template>();
        for (BaseTemplate baseTemplate : this.templates) {
            if (!(baseTemplate instanceof Template)) continue;
            arrayList.add((Template)baseTemplate);
        }
        return arrayList;
    }

    public void removeAllTemplates() {
        this.templates.clear();
    }

    public void addParam(Param param) {
        this.templateParams.add(param);
    }

    public List<Param> getParams() {
        if (this.templateParams == null) {
            return Collections.emptyList();
        }
        return this.templateParams;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void addTemplateExpression(TemplateExpression templateExpression) {
        this.expressions.add(templateExpression);
    }

    public List<TemplateExpression> getTemplateExpressions() {
        return this.expressions;
    }

    public void setTemplateExpressions(List<TemplateExpression> list) {
        this.expressions = list;
    }

    public String toXML() {
        return this.toXML(true, true);
    }

    public String toXML(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TemplateList>\n");
        if (this.comment != null) {
            stringBuffer.append("  <!--");
            stringBuffer.append(this.comment);
            stringBuffer.append("  -->\n");
        }
        if (bl) {
            for (BaseTemplate object : this.getTemplatesOnly()) {
                stringBuffer.append(object.toXML());
            }
        }
        if (bl2) {
            for (TemplateGroup templateGroup : this.getTemplateGroups()) {
                stringBuffer.append(templateGroup.toXML());
            }
            for (Param param : this.templateParams) {
                stringBuffer.append(param.toXML());
            }
        }
        stringBuffer.append("</TemplateList>\n");
        return stringBuffer.toString();
    }

    public String getMeasureXML() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Measure measure : this.measures) {
            stringBuffer.append(measure.toXML());
        }
        return stringBuffer.toString();
    }

    public TemplateExpression findTemplateExpression(String string) {
        for (TemplateExpression templateExpression : this.expressions) {
            if (!templateExpression.getName().equalsIgnoreCase(string)) continue;
            return templateExpression;
        }
        return null;
    }
}

