/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import oracle.olap.app.Resources;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templatelist.TemplateList;
import oracle.olap.app.templates.templateview.ParamFinder;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateHyperParamFactory;
import oracle.olap.app.templates.templateview.TemplateHyperParamFinder;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.stringexpr.ParamValue;
import oracle.olap.stringexpr.ParseException;
import oracle.olap.stringexpr.StringExprParser;

public abstract class BaseTemplateHyperView
implements TemplateHyperParamFinder,
ParamFinder,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(BaseTemplateHyperView.class.getName());
    private static final int VERTICAL_SPACING = 3;
    private static final int PARAM_SPACING = 2;
    private final TemplateGroup templateGroup;
    private final Map<String, String> paramDefaults;
    private final List<TemplateHyperParam> hyperParams;
    private final TemplateContext templateContext;
    private final EventListenerList propertyChangeListeners;
    private final TemplateHyperContext hyperContext;
    private final Map<String, Object> allParams;
    private int ROW_HEIGHT = 12;
    private boolean panelInitialized;
    protected JPanel panel;
    private LinkedList<GuiComponent> components = new LinkedList();
    protected HashMap<String, String> currentParameterValues = new HashMap();
    private static final Pattern tokenizer = Pattern.compile("((?:\\s*[^{}\\s]+\\s*)|(?:\\s+))|(\\{([^{}]+)\\})");

    public BaseTemplateHyperView(TemplateContext templateContext, TemplateHyperContext templateHyperContext, TemplateGroup templateGroup, Map<String, String> map) {
        this.templateGroup = templateGroup;
        this.templateContext = templateContext;
        this.hyperContext = templateHyperContext;
        templateHyperContext.setTemplateHyperParamFinder(this);
        this.propertyChangeListeners = new EventListenerList();
        this.hyperParams = new ArrayList<TemplateHyperParam>();
        this.allParams = new HashMap<String, Object>();
        this.panel = new JPanel(new FlowLayout(0, 0, 0));
        this.paramDefaults = map;
    }

    public BaseTemplateHyperView(TemplateContext templateContext, TemplateHyperContext templateHyperContext, TemplateGroup templateGroup) {
        this(templateContext, templateHyperContext, templateGroup, null);
    }

    protected void clearAllParamValues() {
        this.allParams.clear();
    }

    protected Object getAllParamValue(String string) {
        Object object = this.allParams.get(string);
        if (object == null) {
            object = this.currentParameterValues.get(string);
        }
        return object;
    }

    protected void putAllParamValueOld(String string, Object object) {
        this.allParams.put(string, object);
    }

    protected void putAllParamValue(String string, String string2) {
        Object object = this.allParams.get(string);
        if (object == null) {
            this.allParams.put(string, string2);
        } else {
            ArrayList<String> arrayList = null;
            if (object instanceof String) {
                arrayList = new ArrayList<String>();
                arrayList.add(object.toString());
                this.allParams.put(string, arrayList);
            } else {
                arrayList = (ArrayList<String>)object;
            }
            arrayList.add(string2);
        }
    }

    public abstract TemplateList getTemplateList();

    public abstract String getName();

    public TemplateGroup getTemplateGroup() {
        return this.templateGroup;
    }

    public TemplateContext getTemplateContext() {
        return this.templateContext;
    }

    public TemplateHyperContext getTemplateHyperContext() {
        return this.hyperContext;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.propertyChangeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    public Object getProperty(String string) throws SQLException, IOException {
        TemplateHyperParam templateHyperParam = this.getHyperParamForName(string);
        if (templateHyperParam == null) {
            templateHyperParam = this.getHyperParamForType(string);
        }
        if (templateHyperParam != null) {
            Object object = templateHyperParam.getValue(string);
            return object;
        }
        return null;
    }

    protected abstract String getUi();

    public abstract String getExpression() throws SQLException, IOException;

    private String evaluateStringExpr(String string) throws SQLException, IOException {
        String string2 = string = string.substring("$sexpr[".length(), string.length() - 2);
        try {
            string2 = StringExprParser.getParseTree(string, new ParamValue(){

                @Override
                public Object getValue(String string) throws SQLException, IOException {
                    Object object = BaseTemplateHyperView.this.getProperty(string);
                    if (object == null) {
                        object = BaseTemplateHyperView.this.getAllParamValue(string);
                    }
                    if (object == null) {
                        object = BaseTemplateHyperView.this.getMetadataProperty(string);
                    }
                    return object;
                }
            });
        }
        catch (ParseException parseException) {
            LOG.log(Level.SEVERE, String.format("Expression %s failed with %s", string, parseException.getMessage()), parseException);
            string2 = String.format(" \"%s\"->%s\n", string, parseException.getMessage());
        }
        return string2;
    }

    private String evaluateStringExprs(String string) throws SQLException, IOException {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = -1;
        while ((n2 = string.indexOf("$sexpr[")) != -1 && (n = string.indexOf("]$")) >= 0) {
            String string2 = string.substring(n2, n + 2);
            String string3 = "";
            string3 = this.evaluateStringExpr(string2);
            String string4 = string;
            string = string4.substring(0, n2);
            string = string + string3;
            string = string + string4.substring(n + 2, string4.length());
        }
        return string;
    }

    private Object getMetadataProperty(String string, String string2) {
        Cube cube;
        if (string != null && string.equalsIgnoreCase("cube") && (cube = this.getTemplateContext().getCube()) != null) {
            return this.getMetadataProperty(cube, string2);
        }
        return this.getMetadataProperty(string2);
    }

    private Object getMetadataProperty(String string) {
        Object object = string;
        NamedObjectWithDesc namedObjectWithDesc = null;
        namedObjectWithDesc = !this.getTemplateContext().isCube() ? this.getTemplateContext().getBaseDimension() : this.getTemplateContext().getCube();
        if (namedObjectWithDesc != null) {
            object = this.getMetadataProperty(namedObjectWithDesc, string);
        }
        return object;
    }

    private Object getMetadataProperty(NamedObject namedObject, String string) {
        Object object = null;
        if (string != null && string.length() > 0) {
            object = namedObject.getValue(string);
        }
        return object;
    }

    public String getExpression(String string, Measure measure) throws SQLException, IOException {
        string = this.evaluateStringExprs(string);
        while (string.indexOf("{") >= 0) {
            Object object;
            Object object2;
            Object object3;
            int n = string.indexOf("{");
            int n2 = string.indexOf("}");
            if (n2 < 0) continue;
            String string2 = string.substring(n + 1, n2);
            String[] stringArray = TemplateHyperParamFactory.splitDefinition(string2);
            String string3 = stringArray[3];
            String string4 = stringArray[2];
            TemplateHyperParam templateHyperParam = this.getHyperParamForName(string3);
            if (templateHyperParam == null) {
                templateHyperParam = this.getHyperParamForType(string3);
            }
            String string5 = "{" + string3 + "}";
            string5 = string3;
            if (templateHyperParam != null) {
                object3 = templateHyperParam.getValue();
                if (string4 != null && object3 != null && object3 instanceof NamedObject) {
                    object2 = (NamedObject)object3;
                    object = this.getMetadataProperty((NamedObject)object2, string4);
                    if (object != null) {
                        string5 = object.toString();
                    }
                } else {
                    string5 = templateHyperParam.getExpression(string4);
                    string5 = this.getExpression(string5, measure);
                }
            } else if (string3.equalsIgnoreCase("measure")) {
                if (measure != null) {
                    string5 = measure.getID();
                }
            } else {
                object3 = string4;
                object2 = null;
                if (object3 == null) {
                    object3 = string3;
                }
                if (string3 != null) {
                    object2 = string3;
                }
                if ((object = this.getAllParamValue((String)object3)) != null) {
                    string5 = object.toString();
                } else {
                    Object object4 = this.getMetadataProperty((String)object2, (String)object3);
                    if (object4 != null) {
                        string5 = object4.toString();
                    }
                }
            }
            object3 = string;
            string = ((String)object3).substring(0, n);
            string = string + string5;
            if (templateHyperParam != null) {
                this.currentParameterValues.put(string3, string5);
            }
            string = string + ((String)object3).substring(n2 + 1, ((String)object3).length());
        }
        return string;
    }

    public JPanel getPanel() throws SQLException, IOException {
        if (!this.panelInitialized) {
            Object object;
            this.panelInitialized = true;
            String string = this.getUi();
            int n = 0;
            if (string == null) {
                return null;
            }
            Resources resources = this.hyperContext.getResources();
            this.panel.removeAll();
            if (resources != null) {
                string = resources.getXLIFFResource(string);
            }
            JLabel jLabel = new JLabel();
            this.ROW_HEIGHT = jLabel.getFontMetrics(jLabel.getFont()).getMaxAscent() + 3;
            Matcher matcher = tokenizer.matcher(string);
            while (matcher.find()) {
                object = matcher.group(1);
                if (object != null) {
                    JLabel jLabel2 = new JLabel((String)object);
                    n += ((String)object).length();
                    this.panel.add(jLabel2);
                    this.components.add(new GuiComponent(jLabel2));
                    continue;
                }
                object = matcher.group(3);
                n += 40;
                Object var7_9 = null;
                TemplateHyperParam templateHyperParam = TemplateHyperParamFactory.getInstance().getHyperParam(this.templateContext, this, (String)object, this.hyperContext);
                if (templateHyperParam != null) {
                    templateHyperParam.addPropertyChangeListener(this);
                    this.hyperParams.add(templateHyperParam);
                    this.panel.add(templateHyperParam.getComponent());
                    this.components.add(new GuiComponent(templateHyperParam));
                    for (TemplateHyperParam templateHyperParam2 : templateHyperParam.getOptionalHyperParams()) {
                        templateHyperParam2.addPropertyChangeListener(this);
                        this.hyperParams.add(templateHyperParam2);
                        this.panel.add(templateHyperParam2.getComponent());
                        this.components.add(new GuiComponent(templateHyperParam2));
                    }
                    continue;
                }
                this.panel.add(new JLabel("PARAM:" + (String)object));
            }
            for (TemplateHyperParam templateHyperParam : this.hyperParams) {
                templateHyperParam.setUpDependencies(this.hyperParams);
            }
            for (TemplateHyperParam templateHyperParam : this.hyperParams) {
                templateHyperParam.init();
            }
            object = new Resizer();
            for (TemplateHyperParam templateHyperParam : this.hyperParams) {
                String string2;
                if (this.paramDefaults != null && (string2 = this.paramDefaults.get(templateHyperParam.getType())) != null) {
                    templateHyperParam.setDefault(string2);
                }
                if (!this.hyperContext.isDynamicallyResizeable()) continue;
                templateHyperParam.addPropertyChangeListener((PropertyChangeListener)object);
            }
            if (this.hyperContext.isDynamicallyResizeable()) {
                this.panel.addHierarchyListener((HierarchyListener)object);
                this.panel.addAncestorListener((AncestorListener)object);
                this.panel.addComponentListener((ComponentListener)object);
            } else if (n > 300) {
                this.panel.setPreferredSize(new Dimension(400, 80));
            } else if (n > 260) {
                this.panel.setPreferredSize(new Dimension(400, 70));
            } else {
                this.panel.setPreferredSize(new Dimension(400, 40));
            }
        }
        return this.panel;
    }

    public List<String> getVisibleParamNames() throws SQLException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TemplateHyperParam templateHyperParam : this.getHyperParams()) {
            if (!templateHyperParam.getComponent().isVisible()) continue;
            if (templateHyperParam.getName() != null) {
                arrayList.add(templateHyperParam.getName());
                continue;
            }
            arrayList.add(templateHyperParam.getType().toString());
        }
        return arrayList;
    }

    @Override
    public TemplateHyperParam getHyperParamForName(String string) {
        for (TemplateHyperParam templateHyperParam : this.getHyperParams()) {
            String string2 = templateHyperParam.getName();
            if (string2 == null) continue;
            if (string2.equalsIgnoreCase(string)) {
                return templateHyperParam;
            }
            if ((string2 + "_name").equalsIgnoreCase(string)) {
                return templateHyperParam;
            }
            if (!(string2 + "_description").equalsIgnoreCase(string)) continue;
            return templateHyperParam;
        }
        return null;
    }

    @Override
    public TemplateHyperParam getHyperParamForType(String string) {
        for (TemplateHyperParam templateHyperParam : this.getHyperParams()) {
            if (!templateHyperParam.getType().toString().equalsIgnoreCase(string)) continue;
            return templateHyperParam;
        }
        return null;
    }

    @Override
    public Param getParam(String string) {
        for (Param param : this.templateGroup.getParams()) {
            if (param.getName() == null || !param.getName().equals(string)) continue;
            return param;
        }
        if (this.getTemplateList() != null) {
            for (Param param : this.getTemplateList().getParams()) {
                if (param.getName() == null || !param.getName().equals(string)) continue;
                return param;
            }
        }
        return null;
    }

    public List<TemplateHyperParam> getHyperParams() {
        return this.hyperParams;
    }

    public List<String> getParamNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TemplateHyperParam templateHyperParam : this.hyperParams) {
            if (templateHyperParam.getName() != null) {
                arrayList.add(templateHyperParam.getName());
                continue;
            }
            arrayList.add(templateHyperParam.getType().toString());
        }
        return arrayList;
    }

    protected Map<String, String> getParamDefaults() {
        return this.paramDefaults;
    }

    public HashMap<String, String> getCurrentParameterValues() {
        return this.currentParameterValues;
    }

    private class Resizer
    extends ComponentAdapter
    implements PropertyChangeListener,
    HierarchyListener,
    AncestorListener {
        private Resizer() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.calculateSize();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.calculateSize();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            this.calculateSize();
        }

        private void calculateSize() {
            try {
                int n = BaseTemplateHyperView.this.panel.getWidth();
                if (n > 0) {
                    int n2 = 0;
                    int n3 = BaseTemplateHyperView.this.ROW_HEIGHT;
                    boolean bl = true;
                    for (GuiComponent guiComponent : BaseTemplateHyperView.this.components) {
                        int n4 = guiComponent.getWidth(n);
                        bl &= n4 == 0;
                        if ((n2 += n4) < n) continue;
                        n3 += BaseTemplateHyperView.this.ROW_HEIGHT;
                        n2 = n4;
                    }
                    if (bl) {
                        n3 = 0;
                    } else {
                        while (n2 > n) {
                            n3 += BaseTemplateHyperView.this.ROW_HEIGHT;
                            n2 -= n;
                        }
                    }
                    BaseTemplateHyperView.this.panel.setPreferredSize(new Dimension(n, n3));
                    BaseTemplateHyperView.this.panel.setMinimumSize(BaseTemplateHyperView.this.panel.getPreferredSize());
                    if (BaseTemplateHyperView.this.panel.getParent() != null) {
                        BaseTemplateHyperView.this.panel.getParent().invalidate();
                    }
                }
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, "Error calculating template size", throwable);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            this.calculateSize();
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }

    private static class GuiComponent {
        private TemplateHyperParam param;
        private int width;

        GuiComponent(TemplateHyperParam templateHyperParam) {
            this.param = templateHyperParam;
        }

        GuiComponent(JLabel jLabel) {
            this.width = jLabel.getFontMetrics(jLabel.getFont()).stringWidth(jLabel.getText());
        }

        int getWidth(int n) {
            if (this.param == null) {
                return this.width;
            }
            if (this.param.isVisible()) {
                this.width = this.param.getPixelSize(n);
                return this.width == 0 ? this.width : this.width + 2;
            }
            return 0;
        }
    }
}

