/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatelist.Item;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templateview.ParamFinder;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateHyperParamFactory;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.stringexpr.ParamValue;
import oracle.olap.stringexpr.ParseException;
import oracle.olap.stringexpr.StringExprParser;

class ItemElement {
    private Param param;
    private Item item;
    private TemplateHyperParam optionalHyperParam;
    private ParamFinder getParam;
    private TemplateContext context;
    private TemplateHyperContext hyperContext;
    private static Logger LOG = Logger.getLogger(ItemElement.class.getName());
    private String text;

    public ItemElement(TemplateContext templateContext, ParamFinder paramFinder, Param param, TemplateHyperContext templateHyperContext, Item item) {
        this.param = param;
        this.item = item;
        this.getParam = paramFinder;
        this.context = templateContext;
        this.hyperContext = templateHyperContext;
        this.initOptional();
        if (item.getStringExpr() == null) {
            int n;
            String string = item.getText();
            int n2 = string.indexOf("{");
            if (n2 != -1 && (n = string.indexOf("}")) != -1 && n2 + 1 < string.length()) {
                string = string.substring(0, n2) + string.substring(n + 1, string.length());
            }
            this.text = string;
        }
    }

    public void setValueMap(final Map<String, String> map) throws SQLException, IOException {
        if (this.item.getStringExpr() == null) {
            return;
        }
        try {
            ParamValue paramValue = new ParamValue(){

                @Override
                public String getValue(String string) {
                    return (String)map.get(string);
                }
            };
            this.text = StringExprParser.getParseTree(this.item.getStringExpr(), paramValue);
        }
        catch (ParseException parseException) {
            this.text = this.item.getStringExpr();
            LOG.log(Level.INFO, parseException.getMessage(), parseException);
        }
    }

    public String getProperty(String string) {
        String string2;
        String string3 = this.toString();
        if (string.toLowerCase().endsWith("description") && (string2 = this.item.getDescription()) != null) {
            string3 = string2;
        }
        if (string.toLowerCase().endsWith("name") && (string2 = this.item.getName()) != null) {
            string3 = string2;
        }
        return string3;
    }

    public TemplateHyperParam getOptional() {
        return this.optionalHyperParam;
    }

    public String toString() {
        return this.text;
    }

    private void initOptional() {
        String string = this.item.getText();
        int n = string.indexOf(123);
        int n2 = string.indexOf(125);
        if (n != -1 && n2 != -1 && n + 1 < string.length()) {
            String string2 = string.substring(n + 1, n2);
            this.optionalHyperParam = TemplateHyperParamFactory.getInstance().getHyperParam(this.context, this.getParam, string2, this.hyperContext);
        }
    }

    public String getExpression() {
        return this.item.getExpression();
    }

    public void setDefault() {
        this.param.setDefault(this.item);
    }

    public boolean equals(Object object) {
        if (object instanceof Item && this.item.equals(object)) {
            return true;
        }
        if (object instanceof ParseNode) {
            object = ((ParseNode)object).getValue();
        }
        if (object instanceof ItemElement && this.toString().equals(object.toString())) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (this.toString().equals(string) || this.getExpression().equals(string)) {
                return true;
            }
        }
        return false;
    }
}

