/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.olap.app.Resources;
import oracle.olap.app.templates.templateview.MeasureTreeNode;

public class MeasureSelector
extends JPanel
implements SearchListener {
    private static final String TITLE = "MEASURE_PICKER_TITLE";
    private final String title;
    private final Component parentComponent;
    private JTree tree;
    private SearchField searchField;
    private JLabel filterLabel;
    private JDialog dialog;
    boolean dblClick = false;

    public MeasureSelector(MeasureTreeNode measureTreeNode, Resources resources, Component component) {
        super(new BorderLayout());
        this.parentComponent = component;
        this.setMinimumSize(new Dimension(380, 350));
        this.setPreferredSize(this.getMinimumSize());
        this.tree = new JTree(measureTreeNode);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (component instanceof JLabel && object instanceof MeasureTreeNode) {
                    MeasureTreeNode measureTreeNode = (MeasureTreeNode)object;
                    ((JLabel)component).setIcon(measureTreeNode.getIcon());
                }
                return component;
            }
        });
        this.tree.setRootVisible(false);
        this.title = resources.getString(TITLE);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MeasureSelector.this.dblClick = true;
                    MeasureSelector.this.dialog.setVisible(false);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add((Component)jScrollPane, "Center");
        this.filterLabel = new JLabel();
        this.filterLabel.setName("filterLabel");
        this.searchField = new SearchField(SearchField.Style.FIND);
        this.searchField.setName("searchField");
        this.searchField.setAllowEmptySearch(true);
        this.searchField.addSearchListener((SearchListener)this);
        this.searchField.setMinimumSize(new Dimension(50, 120));
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.searchField, (String)resources.getString("SOURCE_SELECTION_DIALOG_FILTER_LABEL"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.filterLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 19, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.searchField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 19, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)jPanel, "South");
    }

    public MeasureTreeNode getValue() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            return (MeasureTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    public MeasureTreeNode setValue(Object object) {
        if (this.tree != null) {
            MeasureTreeNode measureTreeNode = (MeasureTreeNode)this.tree.getModel().getRoot();
            MeasureTreeNode measureTreeNode2 = object instanceof MeasureTreeNode ? measureTreeNode.find(((MeasureTreeNode)object).getID()) : measureTreeNode.find(object.toString());
            if (measureTreeNode2 == null) {
                return null;
            }
            LinkedList<MeasureTreeNode> linkedList = new LinkedList<MeasureTreeNode>();
            for (TreeNode treeNode = measureTreeNode2; treeNode != null; treeNode = treeNode.getParent()) {
                linkedList.addFirst((MeasureTreeNode)treeNode);
            }
            boolean bl = false;
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.collapseRow(i);
            }
            this.tree.setSelectionPath(new TreePath(linkedList.toArray()));
            this.tree.getExpandsSelectedPaths();
            return measureTreeNode2;
        }
        return null;
    }

    public boolean showPickerDialog() {
        JOptionPane jOptionPane = new JOptionPane(this, -1, 2, null);
        this.dialog = jOptionPane.createDialog(this.parentComponent, this.title);
        this.dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.setVisible(true);
        Object object = jOptionPane.getValue();
        this.dialog = null;
        if (this.dblClick || object instanceof Integer && (Integer)object == 0) {
            this.dblClick = false;
            MeasureTreeNode measureTreeNode = this.getValue();
            if (measureTreeNode.getID() != null) {
                return true;
            }
        }
        return false;
    }

    public void searchPerformed(SearchEvent searchEvent) {
        String string = searchEvent.getSearchText();
        MeasureTreeNode measureTreeNode = (MeasureTreeNode)this.tree.getModel().getRoot();
        if (measureTreeNode.filter(string)) {
            this.tree.updateUI();
        }
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }
}

