/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.templates.templatelist.BaseTemplate;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templatelist.TemplateList;
import oracle.olap.app.templates.templateview.BaseTemplateHyperView;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateHyperParamHierarchy;
import oracle.olap.app.templates.templateview.TemplateHyperParamList;
import oracle.olap.app.templates.templateview.TemplateHyperView;
import oracle.olap.app.templates.templateview.TemplateMetadata;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.stringexpr.ParseException;
import oracle.olap.stringexpr.StringExprParser;

public class TemplateGroupHyperView
extends BaseTemplateHyperView {
    private static final String HIERARCHY = "HIERARCHY";
    private static final Logger LOG = Logger.getLogger(TemplateGroupHyperView.class.getName());
    private final List<BaseTemplateHyperView> templateHyperViews = new ArrayList<BaseTemplateHyperView>();
    private boolean initialized;

    public TemplateGroupHyperView(TemplateContext templateContext, TemplateHyperContext templateHyperContext, TemplateGroup templateGroup, Map<String, String> map) throws SQLException, IOException {
        super(templateContext, templateHyperContext, templateGroup, map);
        this.panel = new JPanel(new FlowLayout(0));
    }

    public TemplateGroupHyperView(TemplateContext templateContext, TemplateHyperContext templateHyperContext, TemplateGroup templateGroup) throws SQLException, IOException {
        this(templateContext, templateHyperContext, templateGroup, null);
    }

    private void init(Map<String, String> map) throws SQLException, IOException {
        block6: {
            TemplateGroup templateGroup;
            TemplateHyperContext templateHyperContext;
            TemplateContext templateContext;
            block7: {
                if (this.initialized) break block6;
                this.initialized = true;
                templateContext = this.getTemplateContext();
                templateHyperContext = this.getTemplateHyperContext();
                templateGroup = this.getTemplateGroup();
                if (templateGroup.getContext() == null || !"CUBE".equalsIgnoreCase(templateGroup.getContext())) break block7;
                Cube cube = this.getTemplateContext().getCube();
                if (cube == null) break block6;
                for (Dimension dimension : cube.getDimensions()) {
                    TemplateContext templateContext2 = new TemplateContext(templateContext.getDatabase(), new TemplateMetadata(dimension));
                    templateContext2.setCube(cube);
                    for (BaseTemplate baseTemplate : templateGroup.getTemplates()) {
                        boolean bl = true;
                        String string = baseTemplate.getCondition();
                        if (string != null) {
                            try {
                                String string2 = StringExprParser.getParseTree(string, dimension);
                                bl = Boolean.parseBoolean(string2);
                            }
                            catch (ParseException parseException) {
                                LOG.log(Level.FINE, parseException.getMessage(), parseException);
                            }
                        }
                        if (!bl) continue;
                        this.addTemplateview(baseTemplate, templateContext2, templateHyperContext, templateGroup, map);
                    }
                }
                break block6;
            }
            for (BaseTemplate baseTemplate : templateGroup.getTemplates()) {
                this.addTemplateview(baseTemplate, templateContext, templateHyperContext, templateGroup, map);
            }
        }
    }

    private void addTemplateview(BaseTemplate baseTemplate, TemplateContext templateContext, TemplateHyperContext templateHyperContext, TemplateGroup templateGroup, Map<String, String> map) throws SQLException, IOException {
        BaseTemplateHyperView baseTemplateHyperView = null;
        if (baseTemplate instanceof Template) {
            Template template = (Template)baseTemplate;
            baseTemplateHyperView = new TemplateHyperView(this, templateContext, templateHyperContext, templateGroup, template, map);
        } else if (baseTemplate instanceof TemplateGroup) {
            TemplateGroup templateGroup2 = (TemplateGroup)baseTemplate;
            baseTemplateHyperView = new TemplateGroupHyperView(this.getTemplateContext(), templateHyperContext, templateGroup2, map);
        }
        if (baseTemplateHyperView != null) {
            baseTemplateHyperView.addPropertyChangeListener(this);
            this.templateHyperViews.add(baseTemplateHyperView);
        }
    }

    @Override
    public String getName() {
        return this.getTemplateGroup().getName();
    }

    @Override
    public TemplateList getTemplateList() {
        return this.getTemplateGroup().getTemplateList();
    }

    public String getLocalizedName() {
        if (this.getTemplateHyperContext().getResources() != null) {
            return this.getTemplateHyperContext().getResources().getXLIFFResource(this.getTemplateGroup().getName());
        }
        return this.getTemplateGroup().getName();
    }

    public List<TemplateHyperView> getTemplateViews() throws SQLException, IOException {
        this.init(null);
        ArrayList<TemplateHyperView> arrayList = new ArrayList<TemplateHyperView>();
        for (BaseTemplateHyperView baseTemplateHyperView : this.templateHyperViews) {
            if (!(baseTemplateHyperView instanceof TemplateHyperView)) continue;
            arrayList.add((TemplateHyperView)baseTemplateHyperView);
        }
        return arrayList;
    }

    public List<BaseTemplateHyperView> getAllTemplateViews() {
        if (this.templateHyperViews == null) {
            return Collections.emptyList();
        }
        return this.templateHyperViews;
    }

    public void setHierarchy(DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        TemplateHyperParam templateHyperParam = this.getHyperParamForType(HIERARCHY);
        if (templateHyperParam != null && templateHyperParam instanceof TemplateHyperParamHierarchy) {
            TemplateHyperParamHierarchy templateHyperParamHierarchy = (TemplateHyperParamHierarchy)templateHyperParam;
            templateHyperParamHierarchy.setValue(dimensionHierarchy.getName());
        }
    }

    @Override
    protected String getUi() {
        return this.getTemplateGroup().getUi();
    }

    @Override
    protected Object getAllParamValue(String string) {
        Object object = super.getAllParamValue(string);
        if (object == null) {
            for (BaseTemplateHyperView baseTemplateHyperView : this.templateHyperViews) {
                object = baseTemplateHyperView.getAllParamValue(string);
                if (object != null) continue;
                return object;
            }
        }
        return object;
    }

    @Override
    public String getExpression() throws SQLException, IOException {
        return this.getExpression(this.getTemplateGroup().getExpression());
    }

    public String getExpression(String string) throws SQLException, IOException {
        this.clearAllParamValues();
        this.buildExpressionMap(this);
        String string2 = this.getExpression(string, null);
        return string2;
    }

    private void buildExpressionMap(TemplateGroupHyperView templateGroupHyperView) throws SQLException, IOException {
        for (BaseTemplateHyperView baseTemplateHyperView : templateGroupHyperView.templateHyperViews) {
            BaseTemplateHyperView baseTemplateHyperView2;
            if (baseTemplateHyperView instanceof TemplateHyperView) {
                String string;
                baseTemplateHyperView2 = (TemplateHyperView)baseTemplateHyperView;
                String string2 = baseTemplateHyperView.getName();
                String string3 = baseTemplateHyperView.getExpression();
                this.currentParameterValues.put(string2, string3);
                this.putAllParamValue(string2, string3);
                for (TemplateHyperParam templateHyperParam : ((TemplateHyperView)baseTemplateHyperView2).getHyperParams()) {
                    if (!(templateHyperParam instanceof TemplateHyperParamList)) continue;
                    Object object = (TemplateHyperParamList)templateHyperParam;
                    string = ((TemplateHyperParam)object).getName();
                    String string4 = ((TemplateHyperParamList)object).getExpression();
                    this.putAllParamValue(string, string4);
                }
                Map<String, String> map = ((TemplateHyperView)baseTemplateHyperView2).getTemplateExpressions();
                for (Object object : map.keySet()) {
                    string = (String)map.get(object);
                    this.putAllParamValue((String)object, string);
                }
            }
            if (!(baseTemplateHyperView instanceof TemplateGroupHyperView)) continue;
            baseTemplateHyperView2 = (TemplateGroupHyperView)baseTemplateHyperView;
            this.buildExpressionMap((TemplateGroupHyperView)baseTemplateHyperView2);
        }
    }

    @Override
    public JPanel getPanel() throws SQLException, IOException {
        this.init(null);
        String string = this.getUi();
        if (string != null) {
            return super.getPanel();
        }
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        for (BaseTemplateHyperView baseTemplateHyperView : this.templateHyperViews) {
            JPanel jPanel = baseTemplateHyperView.getPanel();
            if (jPanel == null) continue;
            this.panel.add((Component)jPanel, gridBagConstraints);
        }
        return this.panel;
    }
}

