/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templateview.ParamFinder;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.db.IdentifierElement;

public abstract class TemplateHyperParam
implements PropertyChangeListener {
    private String name;
    private String defaultValue;
    private boolean editable = true;
    private String type;
    private String expressionProperty;
    private List<TemplateHyperParam> optionalParams;
    private List<PropertyChangeListener> propertyChangeListeners = new ArrayList<PropertyChangeListener>();
    private Set<String> dependantParams;
    protected Param param;
    protected TemplateHyperContext hyperContext;
    protected TemplateContext templateContext;
    protected ParamFinder finder;
    private boolean canWrap;
    public static final String VISIBLE_PROPERTY = "visible";
    public static final String VALUE_CHANGED = "VALUE_CHANGED";
    public static final String VALID_PROPERTY = "VALID_PROPERTY";

    public abstract Component getComponent();

    public abstract Object getValue();

    public abstract Object getValue(String var1);

    public abstract void setValue(Object var1);

    public String getExpression(String string) {
        return this.getExpression();
    }

    public abstract String getExpression();

    public void listenerSafeInit() {
    }

    public void init() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void setDefault(String string) {
        this.defaultValue = string;
        this.setValue(string);
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isVisible() {
        return this.getComponent().isVisible();
    }

    public void setVisible(boolean bl) {
        this.getComponent().setVisible(bl);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, VISIBLE_PROPERTY, !bl, bl);
        this.firePropertyChangeEvent(propertyChangeEvent);
    }

    public void setValueMap(Map<String, String> map) throws SQLException, IOException {
    }

    public final void setUpDependencies(List<TemplateHyperParam> list) {
        if (this.dependantParams == null) {
            return;
        }
        for (TemplateHyperParam templateHyperParam : list) {
            if (!this.dependantParams.contains(templateHyperParam.getType())) continue;
            this.addPropertyChangeListener(templateHyperParam);
        }
    }

    public final void addDependantParam(String string) {
        if (this.dependantParams == null) {
            this.dependantParams = new HashSet<String>();
        }
        this.dependantParams.add(string);
    }

    public final String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.param != null) {
            return this.param.getName();
        }
        return null;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String getType() {
        return this.type;
    }

    public final void setType(String string) {
        this.type = string;
    }

    public final void setContext(TemplateContext templateContext) {
        this.templateContext = templateContext;
    }

    public final void setHyperContext(TemplateHyperContext templateHyperContext) {
        this.hyperContext = templateHyperContext;
    }

    public final void setFinder(ParamFinder paramFinder) {
        this.finder = paramFinder;
    }

    public final void setParam(Param param) {
        this.param = param;
    }

    public final Param getParam() {
        return this.param;
    }

    protected final void addOptionalHyperParams(TemplateHyperParam templateHyperParam) {
        if (this.optionalParams == null) {
            this.optionalParams = new ArrayList<TemplateHyperParam>();
        }
        this.optionalParams.add(templateHyperParam);
    }

    protected final void clearOptionalHyperParams() {
        if (this.optionalParams == null) {
            return;
        }
        this.optionalParams.clear();
    }

    public final List<TemplateHyperParam> getOptionalHyperParams() {
        if (this.optionalParams == null) {
            return Collections.emptyList();
        }
        return this.optionalParams;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.add(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.remove(propertyChangeListener);
    }

    protected final void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        for (PropertyChangeListener propertyChangeListener : this.propertyChangeListeners) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public final void setExpressionProperty(String string) {
        this.expressionProperty = string;
    }

    public final String getExpressionProperty() {
        return this.expressionProperty;
    }

    protected String stripSchema(String string, String string2) {
        IdentifierElement identifierElement;
        if (string2 != null && (identifierElement = new IdentifierElement(string)).getCount() > 0 && identifierElement.getFirst().equals(string2)) {
            if (identifierElement.getCount() == 2) {
                return identifierElement.getSecond();
            }
            if (identifierElement.getCount() == 3) {
                return String.format("%s.%s", identifierElement.getSecond(), identifierElement.getThird());
            }
        }
        return string;
    }

    public abstract ParseNode getPattern();

    public boolean isValid() {
        return true;
    }

    public String getErrorMessage() {
        return null;
    }

    public void setCanWrap(boolean bl) {
        this.canWrap = bl;
    }

    public boolean isCanWrap() {
        return this.canWrap;
    }

    public abstract int getPixelSize(int var1);
}

