/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.TemplateHyperParamCombo;

public class TemplateHyperParamDimension
extends TemplateHyperParamCombo {
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamDimension.class.getName());
    private static final String RESERVED_WORD_TIME = "TIME";
    private static final String DEFAULT_NAME = "dimension";
    private static final ParseNode pattern = new ParseNode("dimension", "dimension");

    public TemplateHyperParamDimension() {
        this.setName(DEFAULT_NAME);
        final ListCellRenderer listCellRenderer = this.hyperCombo.getRenderer();
        this.hyperCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Dimension dimension = (Dimension)object;
                return listCellRenderer.getListCellRendererComponent(jList, dimension.getName(), n, bl, bl2);
            }
        });
    }

    @Override
    public String getErrorMessage() {
        return OLAPArb.getString("EXPRESSION_EDITOR_ERROR_NO_DIMENSION");
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void init() {
        String string;
        this.addDimensions(this.templateContext.getDimensions());
        if (this.getComboBoxModel().getSize() > 0) {
            this.setSelectedElement(this.getComboBoxModel().getElementAt(0));
        }
        if (this.getParam() != null && (string = this.getParam().getInitialDefault()) != null) {
            this.setValue(string.toUpperCase());
        }
    }

    public void addDimensions(List<Dimension> list) {
        this.removeAllElements();
        for (Dimension dimension : list) {
            this.addElement(dimension);
        }
    }

    @Override
    public Object getValue(String string) {
        return this.getValue();
    }

    @Override
    public String getExpression() {
        Dimension dimension = (Dimension)this.getSelectedElement();
        String string = dimension.getName();
        if (string.equalsIgnoreCase(RESERVED_WORD_TIME)) {
            string = String.format("\"%s\"", string);
        }
        return string;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        if ("VALUE_CHANGED".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof DimensionHierarchy) {
            Dimension dimension;
            String string = null;
            Dimension dimension2 = ((DimensionHierarchy)propertyChangeEvent.getNewValue()).getDimension();
            if (!dimension2.equals(dimension = (Dimension)this.getValue())) {
                if (dimension != null) {
                    string = dimension.getName();
                }
                LOG.finest(String.format("updating dimension [new,old,source] [%s,%s,%s]", dimension2.getName(), string, propertyChangeEvent.getSource()));
                this.setSelectedElement(dimension2);
            }
        } else if ("VALID_PROPERTY".equals(propertyChangeEvent.getPropertyName()) && !(bl = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue())) {
            this.removeElement(this.getSelectedElement());
            if (this.getComboBoxModel().getSize() > 0) {
                this.setSelectedElement(this.getComboBoxModel().getElementAt(0));
            }
        }
    }
}

