/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templateview.ParamFinder;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.templateparameters.Dependancy;
import oracle.olap.app.templates.templateview.templateparameters.TemplateParameter;
import oracle.olap.app.templates.templateview.templateparameters.TemplateParameterTypes;
import oracle.olap.app.templates.view.TemplateContext;

public class TemplateHyperParamFactory {
    private static TemplateHyperParamFactory factory;
    private HashMap<String, TemplateParameter> paramMap;
    private static Logger LOG;
    public static final int DEF_VALUE_INDEX = 0;
    public static final int TYPE_INDEX = 1;
    public static final int EXPRESSION_PROPERTY_INDEX = 2;
    public static final int NAME_INDEX = 3;

    private TemplateHyperParamFactory() {
        try {
            TemplateParameterTypes templateParameterTypes = (TemplateParameterTypes)JavaXMLBind.BindToJava(TemplateHyperParamFactory.class.getResource("templateparameters.xml"), TemplateParameterTypes.class.getPackage().getName(), null);
            this.paramMap = new HashMap(templateParameterTypes.getTemplateParameters().size());
            for (TemplateParameter templateParameter : templateParameterTypes.getTemplateParameters()) {
                String string = templateParameter.getType();
                this.paramMap.put(string, templateParameter);
            }
        }
        catch (Exception exception) {
            LOG.finest("Could not load Parameter types Xml file.");
            LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
    }

    public static TemplateHyperParamFactory getInstance() {
        if (factory == null) {
            factory = new TemplateHyperParamFactory();
        }
        return factory;
    }

    public TemplateHyperParam getHyperParam(TemplateContext templateContext, ParamFinder paramFinder, String string, TemplateHyperContext templateHyperContext) {
        String[] stringArray = TemplateHyperParamFactory.splitDefinition(string);
        Param param = null;
        if (paramFinder != null && (param = paramFinder.getParam(stringArray[1])) != null) {
            stringArray[1] = param.getType();
            stringArray[3] = param.getName();
            stringArray[2] = param.getExpressionProperty();
            stringArray[0] = param.getDefault();
        }
        return this.instantiateHyperParam(templateContext, paramFinder, param, templateHyperContext, stringArray[1], stringArray[2], stringArray[3], stringArray[0]);
    }

    private TemplateHyperParam instantiateHyperParam(TemplateContext templateContext, ParamFinder paramFinder, Param param, TemplateHyperContext templateHyperContext, String string, String string2, String string3, String string4) {
        Object object;
        TemplateParameter templateParameter = this.paramMap.get(string);
        if (templateParameter == null) {
            LOG.log(Level.SEVERE, "Parameter Type Not found!", string);
            return null;
        }
        if (templateParameter.isSingleInstance() && templateHyperContext != null && templateHyperContext.getTemplateHyperParamFinder() != null) {
            object = templateHyperContext.getTemplateHyperParamFinder();
            Object object2 = object.getHyperParamForType(string);
            if (object2 == null) {
                object2 = object.getHyperParamForName(string3);
            }
            if (object2 != null) {
                return object2;
            }
        }
        try {
            object = (TemplateHyperParam)templateParameter.getParamClass().newInstance();
            ((TemplateHyperParam)object).setType(string);
            ((TemplateHyperParam)object).setCanWrap(templateParameter.isCanWrap());
            ((TemplateHyperParam)object).setContext(templateContext);
            ((TemplateHyperParam)object).setParam(param);
            ((TemplateHyperParam)object).setHyperContext(templateHyperContext);
            ((TemplateHyperParam)object).setFinder(paramFinder);
            if (string3 != null) {
                ((TemplateHyperParam)object).setName(string3);
            } else {
                ((TemplateHyperParam)object).setName(string);
            }
            if (string4 != null) {
                ((TemplateHyperParam)object).setDefault(string4);
            }
            if (string2 != null) {
                ((TemplateHyperParam)object).setExpressionProperty(string2);
            }
            for (Dependancy dependancy : templateParameter.getDependancies()) {
                ((TemplateHyperParam)object).addDependantParam(dependancy.getType());
            }
            ((TemplateHyperParam)object).listenerSafeInit();
            return object;
        }
        catch (InstantiationException instantiationException) {
            LOG.log(Level.SEVERE, instantiationException.getLocalizedMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.log(Level.SEVERE, illegalAccessException.getLocalizedMessage(), illegalAccessException);
        }
        return null;
    }

    public static String[] splitDefinition(String string) {
        String[] stringArray = new String[]{null, null, null, null};
        int n = string.indexOf(58);
        int n2 = string.indexOf(46);
        if (n2 == -1 && n == -1) {
            stringArray[1] = string;
        } else if (n2 == -1 && n != -1) {
            stringArray[1] = string;
            stringArray[0] = string.substring(n + 1);
        } else if (n2 != -1 && n == -1) {
            stringArray[1] = string.substring(0, n2);
            stringArray[2] = string.substring(n2 + 1);
        } else if (n2 != -1 && n != -1) {
            stringArray[1] = string.substring(0, n2);
            stringArray[2] = string.substring(n2 + 1, n);
            stringArray[0] = string.substring(n + 1);
        }
        stringArray[3] = stringArray[1];
        return stringArray;
    }

    static {
        LOG = Logger.getLogger(TemplateHyperParamFactory.class.getName());
    }
}

