/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.TemplateHyperParamCombo;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamLevel
extends TemplateHyperParamCombo
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamLevel.class.getName());
    private Dimension dimension;
    private static final ParseNode pattern = new ParseNode("level", Type.LEVEL.toString(), ParseNode.PatternType.NONE);

    public TemplateHyperParamLevel() {
        this.addPropertyChangeListener(this);
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        LOG.log(Level.FINEST, "updating dimension [new,old]", new Object[]{propertyChangeEvent.getNewValue(), this.getSelectedElement()});
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Dimension) {
            this.dimension = (Dimension)object;
            this.setDimension(this.dimension);
        }
    }

    @Override
    public void init() {
        String string;
        if (this.getParam() != null && (string = this.getParam().getInitialDefault()) != null) {
            this.setValue(string.toUpperCase());
        }
    }

    private void setDimension(Dimension dimension) {
        this.removeAllElements();
        if (dimension != null) {
            List<DimensionLevel> list = dimension.getLevels();
            if (list.size() == 0) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
            for (DimensionLevel dimensionLevel : list) {
                this.addElement(dimensionLevel.getName());
            }
        }
    }

    public DimensionLevel getLevel() {
        String string = (String)this.getSelectedElement();
        List<DimensionLevel> list = this.dimension.getLevels();
        for (DimensionLevel dimensionLevel : list) {
            if (!dimensionLevel.getName().equals(string)) continue;
            return dimensionLevel;
        }
        return null;
    }

    @Override
    public Object getValue(String string) {
        DimensionLevel dimensionLevel = this.getLevel();
        if (string.equalsIgnoreCase(this.getName())) {
            return dimensionLevel;
        }
        if (string.equalsIgnoreCase(this.getType().toString())) {
            return dimensionLevel;
        }
        return dimensionLevel.toString();
    }

    @Override
    public Object getValue() {
        return this.getLevel();
    }

    @Override
    public String getExpression() {
        return this.getLevel().getID();
    }
}

