/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatelist.Item;
import oracle.olap.app.templates.templateview.ItemElement;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateHyperParamCombo;

public class TemplateHyperParamList
extends TemplateHyperParamCombo
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamList.class.getName());
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    private ParseNode pattern;
    private LinkedList<ItemElement> fullItemList = new LinkedList();

    @Override
    public ParseNode getPattern() {
        if (this.pattern == null) {
            this.pattern = new ParseNode(this.getName(), null, ParseNode.PatternType.CHOICE);
            if (this.getParam() != null) {
                for (Item item : this.getParam().getItems()) {
                    ParseNode parseNode = new ParseNode(this.getName(), null, ParseNode.PatternType.OPTION);
                    String string = item.getExpression();
                    int n = string.indexOf("$sexpr[");
                    int n2 = string.indexOf("]$", n);
                    if (n != -1 && n2 != -1 && n < n2) {
                        string = string.substring(0, n).trim();
                    }
                    n = string.indexOf(123);
                    n2 = string.indexOf(125, n);
                    if (n != -1 && n2 != -1 && n < n2) {
                        string = string.substring(0, n).trim();
                    }
                    if (string.startsWith(",")) {
                        string = string.substring(1);
                    }
                    parseNode.setUserObject(string);
                    this.pattern.add(parseNode);
                }
            }
        }
        return this.pattern;
    }

    @Override
    public Object getValue(String string) {
        Object object = this.getSelectedElement();
        if ((string.toLowerCase().endsWith(NAME) || string.toLowerCase().endsWith(DESCRIPTION)) && object instanceof ItemElement) {
            ItemElement itemElement = (ItemElement)object;
            object = itemElement.getProperty(string);
        }
        return object;
    }

    @Override
    public String getExpression() {
        ItemElement itemElement = (ItemElement)this.getSelectedElement();
        return itemElement.getExpression();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        for (TemplateHyperParam object2 : this.getOptionalHyperParams()) {
            object2.getComponent().setVisible(false);
        }
        Object object = this.getSelectedElement();
        if (object instanceof ItemElement) {
            ItemElement itemElement = (ItemElement)object;
            itemElement.setDefault();
            TemplateHyperParam templateHyperParam = itemElement.getOptional();
            if (templateHyperParam != null) {
                templateHyperParam.setVisible(true);
            }
        }
        super.itemStateChanged(itemEvent);
    }

    @Override
    public boolean isSaveSelectionToParam() {
        return false;
    }

    private void populateComboBoxModel() {
        Object object;
        this.removeAllElements();
        for (ItemElement object2 : this.fullItemList) {
            object = object2.getOptional();
            if (object != null && !((TemplateHyperParam)object).isValid()) continue;
            this.addElement(object2);
        }
        for (TemplateHyperParam templateHyperParam : this.getOptionalHyperParams()) {
            if (this.getSelectedElement() == null) continue;
            object = (ItemElement)this.getSelectedElement();
            templateHyperParam.setVisible(((ItemElement)object).getOptional() != null);
        }
    }

    @Override
    public void listenerSafeInit() {
        Object object2;
        for (Item item : this.getParam().getItems()) {
            object2 = new ItemElement(this.templateContext, this.finder, this.getParam(), this.hyperContext, item);
            this.fullItemList.add((ItemElement)object2);
            TemplateHyperParam object3 = ((ItemElement)object2).getOptional();
            if (object3 == null) continue;
            this.addOptionalHyperParams(object3);
            object3.setVisible(false);
        }
        this.populateComboBoxModel();
        Item item = this.findDefault();
        for (int i = 0; i < this.getComboBoxModel().getSize(); ++i) {
            object2 = this.getComboBoxModel().getElementAt(i);
            ItemElement itemElement = object2;
            if (item == null || !itemElement.equals(item)) continue;
            this.getComboBoxModel().setSelectedItem(itemElement);
        }
        if (this.param.getDefault() != null) {
            this.setValue(this.param.getDefault());
        }
        if (this.getOptionalHyperParams().size() > 0) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("visible")) {
                        ItemElement itemElement = (ItemElement)TemplateHyperParamList.this.getSelectedElement();
                        if (itemElement != null) {
                            for (TemplateHyperParam templateHyperParam : TemplateHyperParamList.this.getOptionalHyperParams()) {
                                templateHyperParam.getComponent().setVisible(templateHyperParam.equals(itemElement.getOptional()));
                            }
                        } else {
                            for (TemplateHyperParam templateHyperParam : TemplateHyperParamList.this.getOptionalHyperParams()) {
                                templateHyperParam.getComponent().setVisible(false);
                            }
                        }
                    } else if ("VALID_PROPERTY".equals(propertyChangeEvent.getPropertyName())) {
                        TemplateHyperParamList.this.populateComboBoxModel();
                        TemplateHyperParamList.this.setValue(TemplateHyperParamList.this.findDefault());
                    }
                }
            };
            for (TemplateHyperParam templateHyperParam : this.getOptionalHyperParams()) {
                templateHyperParam.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    @Override
    public void setValueMap(Map<String, String> map) throws SQLException, IOException {
        for (int i = 0; i < this.getComboBoxModel().getSize(); ++i) {
            ((ItemElement)this.getComboBoxModel().getElementAt(i)).setValueMap(map);
        }
    }

    @Override
    public void setValue(Object object) {
        ParseNode parseNode;
        if (object instanceof ParseNode && (parseNode = (ParseNode)object).getPatternType() == ParseNode.PatternType.OPTION) {
            int n = 0;
            for (ParseNode parseNode2 : this.getPattern().getChildren()) {
                if (parseNode2.getValue().equals(parseNode.getValue())) {
                    this.setSelectedElement(this.getComboBoxModel().getElementAt(n));
                    return;
                }
                ++n;
            }
        }
        super.setValue(object);
    }

    private Item findDefault() {
        for (Item item : this.param.getItems()) {
            if (!item.getInitDefault()) continue;
            return item;
        }
        return null;
    }

    @Override
    public int getPixelSize(int n) {
        ItemElement itemElement = (ItemElement)this.getSelectedElement();
        int n2 = this.getComponent().getFontMetrics(this.getComponent().getFont()).stringWidth(itemElement.toString());
        return n2;
    }
}

