/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.olap.OLAPArb;
import oracle.olap.app.Resources;
import oracle.olap.app.hyper.HyperLabel;
import oracle.olap.app.hyper.HyperLabelActionListener;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatelist.QDRData;
import oracle.olap.app.templates.templateview.MeasureSelector;
import oracle.olap.app.templates.templateview.MeasureTreeNode;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olap.syntaxbuilder.spec.Filter;
import oracle.olap.syntaxbuilder.spec.FilterIterator;

public class TemplateHyperParamMeasure
extends TemplateHyperParam {
    private static final int LENGTH = 30;
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamMeasure.class.getName());
    private static final String DEFAULT_NAME = "measure";
    private final String PROPERTY_ID = "id";
    private static final String BASE = "BASE";
    private static final String DERIVED = "DERIVED";
    private static final ParseNode pattern = new ParseNode("measure", Type.MEASURE.toString(), ParseNode.PatternType.NONE);
    private final HyperLabel qdrComponent;
    private final HyperLabel button;
    private final JLabel label;
    private final JPanel gui = new JPanel(new FlowLayout(0, 0, 0));
    private String measure;
    private List<QDRData> qdr;
    private Cube cube;
    private MeasureSelector selector;
    private MeasureTreeNode root;
    private boolean abreviate;

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    private void setDefaultValue() {
        if (this.root == null) {
            return;
        }
        MeasureTreeNode measureTreeNode = null;
        Object var2_2 = null;
        int[] nArray = new int[]{0};
        try {
            String string = this.getDefault();
            if (string != null) {
                nArray[0] = Math.max(0, Integer.parseInt(string) - 1);
            }
        }
        catch (Exception exception) {
            nArray[0] = 0;
        }
        measureTreeNode = this.iterateCubes(BASE, nArray);
        if (nArray[0] >= 0) {
            measureTreeNode = this.iterateCubes(DERIVED, nArray);
        }
        if (measureTreeNode != null) {
            this.setValue(measureTreeNode);
        }
        this.setQDR(null);
    }

    private MeasureTreeNode iterateCubes(String string, int[] nArray) {
        FilterIterator<Measure> filterIterator = new FilterIterator<Measure>(this.cube.getMeasures(), new MeasureFilter(string));
        MeasureTreeNode measureTreeNode = this.iterateMeasures(filterIterator, nArray);
        MeasureTreeNode measureTreeNode2 = null;
        if (nArray[0] >= 0) {
            for (Cube cube : this.cube.getSchema().getCubes()) {
                if (cube == this.cube) continue;
                filterIterator = new FilterIterator<Measure>(cube.getMeasures(), new MeasureFilter(BASE));
                measureTreeNode2 = this.iterateMeasures(filterIterator, nArray);
                if (measureTreeNode2 != null) {
                    measureTreeNode = measureTreeNode2;
                }
                if (nArray[0] >= 0) continue;
                break;
            }
        }
        return measureTreeNode;
    }

    private MeasureTreeNode iterateMeasures(FilterIterator<Measure> filterIterator, int[] nArray) {
        MeasureTreeNode measureTreeNode = null;
        MeasureTreeNode measureTreeNode2 = null;
        for (Measure measure : filterIterator) {
            measureTreeNode = this.root.find(measure.getID());
            if (measureTreeNode == null) continue;
            measureTreeNode2 = measureTreeNode;
            int n = nArray[0];
            nArray[0] = n - 1;
            if (n > 0) continue;
            break;
        }
        return measureTreeNode2;
    }

    public TemplateHyperParamMeasure() {
        this.gui.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.button = this.createButton();
        this.label = new JLabel(OLAPArb.getString("CALC_EDITOR_NESTED_EXPRESION_LABEL"));
        this.label.setVisible(false);
        this.qdrComponent = this.getQDRComponent();
        this.setName(DEFAULT_NAME);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this.label);
        jPanel.add(this.button);
        this.gui.add(this.button);
        this.gui.add(this.label);
        if (this.qdrComponent != null) {
            this.gui.add(this.qdrComponent);
        }
    }

    private HyperLabel createButton() {
        HyperLabel hyperLabel = new HyperLabel("");
        hyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                if (TemplateHyperParamMeasure.this.measure != null) {
                    TemplateHyperParamMeasure.this.selector.setValue(TemplateHyperParamMeasure.this.measure);
                }
                if (TemplateHyperParamMeasure.this.selector.showPickerDialog()) {
                    TemplateHyperParamMeasure.this.setValue(TemplateHyperParamMeasure.this.selector.getValue());
                }
            }
        });
        return hyperLabel;
    }

    @Override
    public Component getComponent() {
        return this.gui;
    }

    @Override
    public Object getValue() {
        return this.measure;
    }

    @Override
    public Object getValue(String string) {
        return this.getValue();
    }

    @Override
    public void setValue(Object object) {
        MeasureTreeNode measureTreeNode = null;
        List<QDRData> list = null;
        String string = null;
        String string2 = null;
        if (this.cube != null) {
            string2 = this.cube.getSchema().getName();
        }
        if (object == null) {
            this.setDefaultValue();
            return;
        }
        if (object instanceof ParseNode) {
            ParseNode parseNode = (ParseNode)object;
            string = Type.valueFrom(parseNode.getType()) == Type.QDR ? ((ParseNode)parseNode.getChildAt(0)).getFullValue() : parseNode.getFullValue();
            measureTreeNode = this.selector.setValue(this.stripSchema(string, string2));
            list = this.buildQDR();
            QDRData qDRData = null;
            block0: for (ParseNode parseNode2 : parseNode.getChildren()) {
                int n;
                String string3;
                if (parseNode2.getType().equals(Type.DIMENSION.toString())) {
                    string3 = this.stripSchema(parseNode2.getValue(), string2);
                    n = 0;
                    if (string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                        ++n;
                    }
                    for (QDRData qDRData2 : list) {
                        if (!string3.regionMatches(true, n, qDRData2.getDimension(), 0, qDRData2.getDimension().length())) continue;
                        qDRData = qDRData2;
                        continue block0;
                    }
                    continue;
                }
                if (qDRData == null) continue;
                string3 = parseNode2.getValue();
                qDRData.setQuoteMemberExpression(true);
                if (parseNode2.getType().equals(Type.STRING.toString())) {
                    n = 0;
                    int n2 = string3.length();
                    if (string3.indexOf(39) == 0) {
                        n = 1;
                    }
                    if (string3.lastIndexOf(39) == string3.length() - 1) {
                        n2 = string3.length() - 1;
                    }
                    if (n != 0 || n2 != string3.length()) {
                        string3 = string3.substring(n, n2);
                    }
                } else {
                    string3 = parseNode2.getValue();
                    qDRData.setQuoteMemberExpression(false);
                }
                qDRData.setMemberKey(string3);
                qDRData.setMemberDescription(string3);
                LOG.finest(String.format("Setting QDR memberkey: %s", string3));
                qDRData = null;
            }
        } else if (object != null && this.selector != null) {
            string = object.toString();
            measureTreeNode = this.selector.setValue(this.stripSchema(object.toString(), string2));
        }
        this.setQDR(list);
        if (measureTreeNode != null) {
            this.button.setVisible(true);
            this.label.setVisible(false);
            this.setValue(measureTreeNode);
            this.abreviate = false;
        } else if (string != null) {
            this.button.setVisible(false);
            this.label.setVisible(true);
            this.setValue(string, "");
            this.abreviate = true;
        }
    }

    void setValue(String string, String string2) {
        if (this.measure != null && this.measure.equals(string)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", this.measure, string);
        this.measure = string;
        this.button.setToolTipText(string);
        this.label.setToolTipText(string);
        if (string2.length() > 30) {
            string2 = String.format("%s...", string2.substring(0, 27));
        }
        this.button.setText(string2);
        this.firePropertyChangeEvent(propertyChangeEvent);
    }

    void setValue(MeasureTreeNode measureTreeNode) {
        this.setValue(measureTreeNode.getID(), measureTreeNode.toString());
    }

    @Override
    public String getExpression(String string) {
        if ("id".equals(string)) {
            return this.measure;
        }
        String string2 = this.generateQDRText(false);
        if (string2 != null) {
            return this.measure + string2;
        }
        return this.measure;
    }

    @Override
    public String getExpression() {
        return this.getExpression(null);
    }

    void setCube(Cube cube) {
        this.cube = cube;
        Resources resources = this.hyperContext.getResources();
        this.root = new MeasureTreeNode(cube.getAWName(), cube, cube.getSchema().getCubes(), resources, this.hyperContext.getFetchIcon());
        this.selector = new MeasureSelector(this.root, resources, this.button);
        this.setDefaultValue();
    }

    public List<QDRData> getQDR() {
        if (this.qdr == null) {
            this.qdr = this.buildQDR();
        }
        return this.qdr;
    }

    public void setQDR(List<QDRData> list) {
        if ((list == null || this.isNullQdr(list)) && (this.qdr == null || this.isNullQdr(this.qdr))) {
            return;
        }
        if (this.qdr != null && list != null && this.qdr.equals(list)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", this.qdr, list);
        this.qdr = list;
        String string = this.generateQDRText(true);
        this.setQDRText(this.qdrComponent, string);
        this.firePropertyChangeEvent(propertyChangeEvent);
    }

    private boolean isNullQdr(List<QDRData> list) {
        for (QDRData qDRData : list) {
            if (qDRData.getMemberKey() == null) continue;
            return false;
        }
        return true;
    }

    public Cube getCube() {
        return this.cube;
    }

    private HyperLabel getQDRComponent() {
        HyperLabel hyperLabel = new HyperLabel("(...)");
        hyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                List<QDRData> list = TemplateHyperParamMeasure.this.hyperContext.showQDRSelector(TemplateHyperParamMeasure.this.getQDR(), TemplateHyperParamMeasure.this.getCube().getSchema().getName());
                if (list != TemplateHyperParamMeasure.this.qdr) {
                    TemplateHyperParamMeasure.this.setQDR(list);
                }
            }
        });
        return hyperLabel;
    }

    private List<QDRData> buildQDR() {
        ArrayList<QDRData> arrayList = new ArrayList<QDRData>(this.getCube().getDimensions().size());
        for (Dimension dimension : this.getCube().getDimensions()) {
            arrayList.add(new QDRData(dimension.getName(), null, null));
        }
        return arrayList;
    }

    private String generateQDRText(boolean bl) {
        if (this.qdr == null) {
            return null;
        }
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder("[");
        for (QDRData qDRData : this.qdr) {
            if (qDRData.getMemberKey() == null) continue;
            bl2 = true;
            if (bl) {
                stringBuilder.append(qDRData.toString());
            } else {
                stringBuilder.append(qDRData.getExptession());
            }
            stringBuilder.append(",");
        }
        if (bl2) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
        return null;
    }

    private void setQDRText(JComponent jComponent, String string) {
        if (string == null) {
            ((HyperLabel)jComponent).setText("(...)");
        } else {
            ((HyperLabel)jComponent).setText(string);
        }
    }

    @Override
    public void init() {
        this.setCube(this.templateContext.getCube());
    }

    @Override
    public int getPixelSize(int n) {
        int n2 = 0;
        if (this.qdrComponent != null) {
            String string = this.qdrComponent.getText();
            if (string == null) {
                string = "(...)";
            }
            n2 = this.qdrComponent.getFontMetrics(this.qdrComponent.getFont()).stringWidth(string);
        }
        if (this.abreviate) {
            return n2 + this.label.getFontMetrics(this.label.getFont()).stringWidth(this.label.getText());
        }
        return n2 + this.button.getFontMetrics(this.button.getFont()).stringWidth(this.button.getText());
    }

    private class MeasureFilter
    implements Filter<Measure> {
        private String type;

        public MeasureFilter(String string) {
            this.type = string;
        }

        @Override
        public boolean matches(Measure measure) {
            return this.type.equals(measure.getType());
        }
    }
}

