/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.MultiSelectShuttlePanel;
import oracle.olap.app.templates.templateview.TemplateHyperParamMultiSelect;
import oracle.olap.db.IdentifierElement;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamMeasureSelection
extends TemplateHyperParamMultiSelect {
    private Cube cube;

    @Override
    public ParseNode getPattern() {
        ParseNode parseNode = new ParseNode("measure_selection", null, ParseNode.PatternType.LOOP);
        parseNode.add(new ParseNode("measure_selection", Type.MEASURE.toString(), ParseNode.PatternType.NONE));
        return parseNode;
    }

    private void setCube(Cube cube) {
        List<Object> list = new ArrayList();
        this.cube = cube;
        this.helpID = null;
        this.editorTitle = this.hyperContext.getResources().getString("BUILD_SPECIFICATION_MEASURE_SELECTION_LABEL");
        List<Measure> list2 = cube.getMeasures();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.hyperContext.getResources().getString("BUILD_SPECIFICATIONS_AVAILABLE_MEASURE_LIST_LABEL");
        String string2 = this.hyperContext.getResources().getString("BUILD_SPECIFICATIONS_SELECTED_MEASURE_LIST_LABEL");
        for (Measure measure : list2) {
            if (measure.isDerived()) continue;
            String string3 = measure.getName();
            string3 = String.format("%s.%s", cube.getName(), string3);
            arrayList.add(string3);
        }
        this.multiSelectEditor = new MultiSelectShuttlePanel(arrayList, string, string2);
        list = this.getDefaultCubeMeasureSelection(cube);
        this.setValue(list);
    }

    public Cube getCube() {
        return this.cube;
    }

    @Override
    public String getExpression() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.selection.iterator();
        if (iterator.hasNext()) {
            IdentifierElement identifierElement = new IdentifierElement((String)iterator.next());
            stringBuilder.append(identifierElement.getSecond());
            while (iterator.hasNext()) {
                stringBuilder.append(',');
                identifierElement = new IdentifierElement((String)iterator.next());
                stringBuilder.append(identifierElement.getSecond());
            }
        }
        return stringBuilder.toString();
    }

    public List<String> getDefaultCubeMeasureSelection(Cube cube) {
        List<Measure> list = cube.getMeasures();
        String string = cube.getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Measure measure : list) {
            if (measure.isDerived()) continue;
            String string2 = string + "." + measure.getName();
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public void init() {
        this.setCube(this.templateContext.getCube());
    }
}

