/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.olap.app.hyper.HyperLabel;
import oracle.olap.app.hyper.HyperLabelActionListener;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.MultiSelectEditor;
import oracle.olap.app.templates.templateview.TemplateHyperParam;

public abstract class TemplateHyperParamMultiSelect
extends TemplateHyperParam {
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamMultiSelect.class.getName());
    private static int dotWidth;
    protected List<String> selection = new ArrayList<String>();
    private HyperLabel button = new HyperLabel("");
    protected MultiSelectEditor multiSelectEditor;
    protected String helpID = null;
    protected String editorTitle = null;
    protected int maxWidth;

    public TemplateHyperParamMultiSelect() {
        this.button.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                TemplateHyperParamMultiSelect.this.showPicker();
            }
        });
        dotWidth = this.button.getFontMetrics(this.button.getFont()).stringWidth("...");
    }

    private void showPicker() {
        this.multiSelectEditor.setSelectedItems(this.selection);
        JOptionPane jOptionPane = new JOptionPane(this.multiSelectEditor, -1, 2, null);
        JDialog jDialog = jOptionPane.createDialog(this.button, this.editorTitle);
        jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        jDialog.setResizable(true);
        jDialog.setSize(new Dimension(400, 300));
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object instanceof Integer && (Integer)jOptionPane.getValue() == 0) {
            List<String> list = this.multiSelectEditor.getSelectedItems();
            this.setValue(list);
        }
    }

    @Override
    public Component getComponent() {
        return this.button;
    }

    @Override
    public Object getValue() {
        return this.selection;
    }

    @Override
    public Object getValue(String string) {
        return this.getValue();
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", this.selection, object);
            this.selection = new ArrayList<String>(list.size());
            for (Object e : list) {
                if (e instanceof ParseNode) {
                    this.selection.add(((ParseNode)e).getValue());
                    continue;
                }
                this.selection.add(e.toString());
            }
            Object object2 = this.getExpression();
            if (this.maxWidth > 0) {
                object2 = this.trimmToPixels(this.maxWidth, (String)object2);
                this.button.setText((String)object2);
            } else {
                this.button.setText((String)object2);
            }
            this.firePropertyChangeEvent(propertyChangeEvent);
        }
    }

    private String trimmToPixels(int n, String string) {
        try {
            if (n == 0 || string == null || string.length() == 0) {
                return string;
            }
            int n2 = this.button.getFontMetrics(this.button.getFont()).stringWidth(string);
            if (n2 > n && n > dotWidth) {
                int n3;
                int n4;
                n -= dotWidth;
                while (n2 > n && string.length() > 0 && (n4 = (int)((double)(n3 = string.length()) / (double)n2 * (double)n)) < string.length()) {
                    string = string.substring(0, n4);
                    n2 = this.button.getFontMetrics(this.button.getFont()).stringWidth(string);
                }
                string = string + "...";
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, String.format("Could not trim the expression %s", string), throwable);
        }
        return string;
    }

    @Override
    public String getExpression() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.selection.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(',');
                stringBuilder.append(iterator.next());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int getPixelSize(int n) {
        this.maxWidth = n;
        String string = this.trimmToPixels(n, this.getExpression());
        this.button.setText(string);
        return this.button.getFontMetrics(this.button.getFont()).stringWidth(string);
    }
}

