/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateExpression;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templatelist.TemplateList;
import oracle.olap.app.templates.templatelist.TemplateNameFormat;
import oracle.olap.app.templates.templateview.BaseTemplateHyperView;
import oracle.olap.app.templates.templateview.TemplateGroupHyperView;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateHyperParamFactory;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.stringexpr.NameSyntaxParseException;
import oracle.olap.stringexpr.ParamValue;
import oracle.olap.stringexpr.ParseException;
import oracle.olap.stringexpr.StringExprParser;
import oracle.olap.stringexpr.TokenMgrError;

public class TemplateHyperView
extends BaseTemplateHyperView
implements ParamValue {
    private static final Logger LOG = Logger.getLogger(TemplateHyperView.class.getName());
    private TemplateGroupHyperView templateGroupHyperView;
    private Template template;
    private String desc;
    private String nameSuffix;
    private JCheckBox checkBox;
    private TemplateNameFormat templateNameFormat;
    private Measure baseMeasure;
    private DimensionHierarchy levelHier;

    public TemplateHyperView(TemplateGroupHyperView templateGroupHyperView, TemplateContext templateContext, TemplateHyperContext templateHyperContext, TemplateGroup templateGroup, Template template) {
        this(templateGroupHyperView, templateContext, templateHyperContext, templateGroup, template, null);
    }

    public TemplateHyperView(TemplateGroupHyperView templateGroupHyperView, TemplateContext templateContext, TemplateHyperContext templateHyperContext, TemplateGroup templateGroup, Template template, Map<String, String> map) {
        super(templateContext, templateHyperContext, templateGroup, map);
        this.templateGroupHyperView = templateGroupHyperView;
        this.template = template;
        this.desc = template.getName();
        this.nameSuffix = "_" + template.getType();
        if (templateHyperContext.getResources() != null) {
            this.desc = templateHyperContext.getResources().getXLIFFResource(this.desc);
        }
        this.checkBox = new JCheckBox(this.desc);
        this.checkBox.setSelected(template.isSelected());
    }

    @Override
    public TemplateList getTemplateList() {
        return this.template.getTemplateList();
    }

    public Template getTemplate() {
        return this.template;
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public String getType() {
        return this.template.getType();
    }

    public void setDesc(String string) {
        this.desc = string;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDescSuffix() {
        return " " + this.desc;
    }

    @Override
    protected String getUi() {
        if (this.getTemplateGroup().getUi() == null) {
            return this.template.getUi();
        }
        return null;
    }

    public TemplateNameFormat getTemplateNameFormat() {
        return this.templateNameFormat;
    }

    public void setTemplateNameFormat(TemplateNameFormat templateNameFormat) {
        this.templateNameFormat = templateNameFormat;
    }

    public void setNameSuffix(String string) {
        this.nameSuffix = string;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setEnabled(boolean bl) {
        this.checkBox.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.checkBox.isEnabled();
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    @Override
    public Param getParam(String string) {
        for (Param param : this.template.getParams()) {
            if (param.getName() == null || !param.getName().equals(string)) continue;
            return param;
        }
        return super.getParam(string);
    }

    public String generateName(String string, Measure measure, DimensionHierarchy dimensionHierarchy, String string2) throws NameSyntaxParseException, SQLException, IOException {
        if (string.equalsIgnoreCase("name")) {
            return this.generateName(measure, dimensionHierarchy, string2);
        }
        if (string.equalsIgnoreCase("description")) {
            return this.generateDescription(measure, dimensionHierarchy, string2);
        }
        if (string.equalsIgnoreCase("shortDescription")) {
            return this.generateShortDescription(measure, dimensionHierarchy, string2);
        }
        if (string.equalsIgnoreCase("longDescription")) {
            return this.generateLongDescription(measure, dimensionHierarchy, string2);
        }
        return "";
    }

    public String generateName(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = measure.getName() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getName() != null && (string2 = this.generateFromRule(this.templateNameFormat.getName(), measure, dimensionHierarchy)).trim().length() > 0) {
            string3 = string2;
        }
        if ((string3 = string3.replace(' ', '_')).length() > 30) {
            string3 = string3.substring(0, 30);
        }
        return string3;
    }

    public String generateDescription(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = measure.getDescription() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getDescription() != null && (string2 = this.generateFromRule(this.templateNameFormat.getDescription(), measure, dimensionHierarchy)).trim().length() > 0) {
            return string2;
        }
        return string3;
    }

    public String generateShortDescription(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = measure.getShortDescription() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getShortDescription() != null && (string2 = this.generateFromRule(this.templateNameFormat.getShortDescription(), measure, dimensionHierarchy)).trim().length() > 0) {
            return string2;
        }
        return string3;
    }

    public String generateLongDescription(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = measure.getDescription() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getLongDescription() != null && (string2 = this.generateFromRule(this.templateNameFormat.getLongDescription(), measure, dimensionHierarchy)).trim().length() > 0) {
            return string2;
        }
        return string3;
    }

    public String generateFromRule(String string, Measure measure, DimensionHierarchy dimensionHierarchy) throws NameSyntaxParseException, SQLException, IOException {
        try {
            this.baseMeasure = measure;
            this.levelHier = dimensionHierarchy;
            List<String> list = this.getVisibleParamNames();
            String string2 = StringExprParser.getParseTree(string, this, list);
            return string2;
        }
        catch (ParseException parseException) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, parseException);
            throw nameSyntaxParseException;
        }
        catch (TokenMgrError tokenMgrError) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, tokenMgrError);
            throw nameSyntaxParseException;
        }
        catch (RuntimeException runtimeException) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, runtimeException);
            throw nameSyntaxParseException;
        }
    }

    private String getObjectValue(String string, Measure measure, DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        if (string.startsWith("{")) {
            string = string.substring(1, string.length());
        }
        if (string.startsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((string = string.trim()).toLowerCase().startsWith("measure")) {
            string = string.length() > "measure_".length() ? string.substring("measure_".length(), string.length()) : "name";
            return TemplateHyperView.getObjectDesc(measure, string);
        }
        if (string.toLowerCase().startsWith("hierarchy_level")) {
            Object object = this.getProperty("hierarchy_level");
            if (object instanceof NamedObjectWithDesc) {
                String string2 = "name";
                if (string.startsWith("hierarchy_level_")) {
                    string2 = string.substring("hierarchy_level_".length(), string.length());
                }
                NamedObjectWithDesc namedObjectWithDesc = (NamedObjectWithDesc)object;
                return TemplateHyperView.getObjectDesc(namedObjectWithDesc, string2);
            }
            if (object != null) {
                return object.toString();
            }
            return "";
        }
        if (string.toLowerCase().startsWith("hierarchy")) {
            string = string.substring("hierarchy_".length(), string.length());
            return TemplateHyperView.getObjectDesc(dimensionHierarchy, string);
        }
        if (string.toLowerCase().startsWith("level")) {
            DimensionHierarchyLevel dimensionHierarchyLevel;
            string = string.length() > "level_".length() ? string.substring("level_".length(), string.length()) : "name";
            Object object = this.getProperty("LEVEL");
            if (object instanceof DimensionHierarchyLevel && (dimensionHierarchyLevel = (DimensionHierarchyLevel)object) != null) {
                DimensionLevel dimensionLevel = dimensionHierarchyLevel.getDimensionLevel();
                return TemplateHyperView.getObjectDesc(dimensionLevel, string);
            }
        } else if (string.toLowerCase().startsWith("dimension")) {
            string = string.length() > "dimension_".length() ? string.substring("dimension_".length(), string.length()) : "name";
            Object object = this.getProperty("DIMENSION");
            if (object instanceof Dimension) {
                Dimension dimension = (Dimension)object;
                return TemplateHyperView.getObjectDesc(dimension, string);
            }
        } else {
            Object object = this.getProperty(string);
            if (object != null) {
                if (object instanceof String) {
                    return (String)object;
                }
                return object.toString();
            }
        }
        return "";
    }

    public static String getObjectDesc(NamedObjectWithDesc namedObjectWithDesc, String string) {
        String string2 = namedObjectWithDesc.getName();
        if (string.equalsIgnoreCase("name")) {
            return string2;
        }
        if (string.equalsIgnoreCase("description")) {
            string2 = namedObjectWithDesc.getDescription();
        }
        if (string.equalsIgnoreCase("short_description")) {
            string2 = namedObjectWithDesc.getShortDescription();
        }
        if (string.equalsIgnoreCase("long_description")) {
            return namedObjectWithDesc.getDescription();
        }
        if (string2 == null || string2.length() == 0) {
            string2 = namedObjectWithDesc.getName();
        }
        return string2;
    }

    @Override
    public String getValue(String string) throws SQLException, IOException {
        String string2 = this.getObjectValue(string, this.baseMeasure, this.levelHier);
        return string2;
    }

    @Override
    public String getName() {
        return this.getTemplate().getName();
    }

    @Override
    public List<TemplateHyperParam> getHyperParams() {
        if (this.templateGroupHyperView != null && this.templateGroupHyperView.getUi() != null) {
            return this.templateGroupHyperView.getHyperParams();
        }
        return super.getHyperParams();
    }

    @Override
    public String getExpression() throws SQLException, IOException {
        return this.getExpression(null);
    }

    public Map<String, String> getTemplateExpressions() throws SQLException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (TemplateExpression templateExpression : this.getTemplate().getTemplateExpressions()) {
            String string = templateExpression.getName();
            String string2 = templateExpression.getExpression();
            if (string2 == null && (templateExpression = this.getTemplateList().findTemplateExpression(string)) != null) {
                string2 = templateExpression.getExpression();
            }
            String string3 = this.getExpression(string2, null);
            hashMap.put(templateExpression.getName(), string3);
        }
        return hashMap;
    }

    public String getExpression(Measure measure) throws SQLException, IOException {
        String string = this.getTemplate().getExpression();
        return this.getExpression(string, measure);
    }

    public HashMap<String, String> getSQLExpressions(Measure measure, DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        Template template = this.getTemplate();
        if (!template.getTemplateDependencies().isEmpty() && measure.getCube().isSQLExpressionsEnabled()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            List<TemplateExpression> list = template.getTemplateDependencies().get(0).getTemplateExpressions();
            for (TemplateExpression templateExpression : list) {
                hashMap.put(templateExpression.getType(), this.replaceExpressionTokens(measure, dimensionHierarchy, templateExpression.getExpression()));
            }
            return hashMap;
        }
        return null;
    }

    private String replaceExpressionTokens(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws SQLException, IOException {
        String string2 = string;
        while (string2.indexOf("{") >= 0) {
            int n = string2.indexOf("{");
            int n2 = string2.indexOf("}");
            if (n2 < 0) continue;
            String string3 = string2.substring(n + 1, n2);
            String[] stringArray = TemplateHyperParamFactory.splitDefinition(string3);
            String string4 = stringArray[3];
            String string5 = stringArray[2];
            TemplateHyperParam templateHyperParam = this.getHyperParamForName(string4);
            if (templateHyperParam == null) {
                templateHyperParam = this.getHyperParamForType(string4);
            }
            String string6 = "{" + string4 + "}";
            string6 = string4;
            if (templateHyperParam != null) {
                string6 = templateHyperParam.getExpression(string5);
            } else if (string4.equalsIgnoreCase("measure")) {
                if (measure != null) {
                    string6 = measure.getID();
                }
            } else if (string4.equalsIgnoreCase("dependent")) {
                string6 = this.getDependentMeasureName(measure, dimensionHierarchy);
            } else if (string4.equalsIgnoreCase("measure_quoted")) {
                string6 = this.quoteExpression(measure.getID());
            } else if (string4.equalsIgnoreCase("measure_quoted_description")) {
                string6 = this.quoteMeasureDescriptionExpression(measure);
            } else if (string4.equalsIgnoreCase("dependent_quoted")) {
                string6 = this.quoteExpression(this.getDependentMeasureName(measure, dimensionHierarchy));
            } else if (string4.equalsIgnoreCase("dependent_quoted_description")) {
                string6 = this.quoteDependentDescriptionExpression(measure, this.getDependentMeasureDescription(measure, dimensionHierarchy));
            } else if (string4.equalsIgnoreCase("measure_column_name")) {
                string6 = this.getSQLName(measure);
            } else if (string4.equalsIgnoreCase("dependent_column_name")) {
                string6 = this.getSQLDependentName(measure, dimensionHierarchy);
            }
            String string7 = string2;
            string2 = string7.substring(0, n);
            string2 = string2 + string6;
            string2 = string2 + string7.substring(n2 + 1, string7.length());
        }
        return string2;
    }

    private TemplateNameFormat getDependentTemplateNameFormat() {
        String string = this.getTemplate().getTemplateDependencies().get(0).getType();
        for (Template template : this.getTemplateList().getTemplatesOnly()) {
            if (template.getType() == null || !template.getType().equalsIgnoreCase(string)) continue;
            return template.getTemplateNameFormat();
        }
        return null;
    }

    private String getDependentMeasureName(Measure measure, DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        String string = "";
        String string2 = this.getTemplate().getTemplateDependencies().get(0).getType();
        TemplateNameFormat templateNameFormat = this.getDependentTemplateNameFormat();
        try {
            String string3 = templateNameFormat.getName();
            String string4 = this.getTemplateNameFormat().getName();
            this.getTemplateNameFormat().setName(string3);
            string = String.format("%s.%s", measure.getCube().getName(), this.generateName(measure, dimensionHierarchy, "_" + string2));
            this.getTemplateNameFormat().setName(string4);
        }
        catch (NameSyntaxParseException nameSyntaxParseException) {
            LOG.log(Level.SEVERE, nameSyntaxParseException.getMessage(), nameSyntaxParseException);
        }
        return string;
    }

    private String getDependentMeasureDescription(Measure measure, DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        String string = "";
        TemplateNameFormat templateNameFormat = this.getDependentTemplateNameFormat();
        try {
            String string2 = templateNameFormat.getDescription();
            String string3 = this.getTemplateNameFormat().getDescription();
            this.getTemplateNameFormat().setDescription(string2);
            string = this.generateDescription(measure, dimensionHierarchy, "");
            this.getTemplateNameFormat().setDescription(string3);
        }
        catch (NameSyntaxParseException nameSyntaxParseException) {
            // empty catch block
        }
        return string;
    }

    private String getSQLName(Measure measure) {
        String string = measure.getID().substring(measure.getID().indexOf(".") + 1);
        return measure.getCube().getViewName() + "." + string;
    }

    private String getSQLDependentName(Measure measure, DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        String string = "";
        String string2 = this.getTemplate().getTemplateDependencies().get(0).getType();
        TemplateNameFormat templateNameFormat = this.getDependentTemplateNameFormat();
        try {
            String string3 = templateNameFormat.getName();
            String string4 = this.getTemplateNameFormat().getName();
            this.getTemplateNameFormat().setName(string3);
            string = String.format("%s.%s", measure.getCube().getViewName(), this.generateName(measure, dimensionHierarchy, "_" + string2));
            this.getTemplateNameFormat().setName(string4);
        }
        catch (NameSyntaxParseException nameSyntaxParseException) {
            // empty catch block
        }
        return string;
    }

    private String quoteExpression(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringBuffer.append("\"");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken() + "\".\"");
        }
        if (stringBuffer.toString().endsWith(".\"")) {
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        }
        return stringBuffer.toString();
    }

    private String quoteMeasureDescriptionExpression(Measure measure) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string2 = measure.getCube().getDescription() != "" ? measure.getCube().getDescription() : measure.getCube().getName();
        if (string2 == null) {
            string2 = measure.getCube().getName();
        }
        String string4 = string = measure.getDescription() != "" ? measure.getDescription() : measure.getName();
        if (string == null) {
            string = measure.getName();
        }
        stringBuffer.append("\"" + string2 + "\".\"" + string + "\"");
        return stringBuffer.toString();
    }

    private String quoteDependentDescriptionExpression(Measure measure, String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string2 = measure.getCube().getDescription() != "" ? measure.getCube().getDescription() : measure.getCube().getName();
        if (string2 == null) {
            string2 = measure.getCube().getName();
        }
        stringBuffer.append("\"" + string2 + "\".\"" + string + "\"");
        return stringBuffer.toString();
    }

    public void checkDependentTemplateView(String string) {
    }

    public void checkReferencedTemplateView(String string) {
    }
}

